    <div>
        <style>
            /* Max width container with margin auto and padding */
            .max-w-md {
                max-width: 28rem;
                /* 448px */
            }

            .mx-auto {
                margin-left: auto;
                margin-right: auto;
            }

            .mt-10 {
                margin-top: 2.5rem;
                /* 40px */
            }

            .p-6 {
                padding: 1.5rem;
                /* 24px */
            }

            /* Background color and shadow */
            .bg-white {
                background-color: #ffffff;
            }

            .shadow-md {
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1),
                    0 2px 4px -2px rgba(0, 0, 0, 0.1);
            }

            /* Border radius */
            .rounded-lg {
                border-radius: 0.5rem;
                /* 8px */
            }

            /* Text styles */
            .text-xl {
                font-size: 1.25rem;
                /* 20px */
                line-height: 1.75rem;
                /* 28px */
            }

            .font-semibold {
                font-weight: 600;
            }

            .text-center {
                text-align: center;
            }

            .text-purple-800 {
                color: #5a67d8;
                /* Equivalent to a darker shade of purple */
            }

            .text-gray-500 {
                color: #6b7280;
                /* Equivalent to a medium shade of gray */
            }

            .mb-6 {
                margin-bottom: 1.5rem;
                /* 24px */
            }

            /* Space between form elements */
            .space-y-4> :not([hidden])~ :not([hidden]) {
                --tw-space-y-reverse: 0;
                margin-top: calc(1rem * calc(1 - var(--tw-space-y-reverse)));
                /* 16px */
                margin-bottom: calc(1rem * var(--tw-space-y-reverse));
            }

            /* Form labels */
            .block {
                display: block;
            }

            .text-sm {
                font-size: 0.875rem;
                /* 14px */
                line-height: 1.25rem;
                /* 20px */
            }

            .font-medium {
                font-weight: 500;
            }

            .text-gray-700 {
                color: #4a5568;
                /* Equivalent to a dark shade of gray */
            }

            /* Select styles */
            .mt-1 {
                margin-top: 0.25rem;
                /* 4px */
            }

            .w-full {
                width: 100%;
            }

            .py-2 {
                padding-top: 0.5rem;
                /* 8px */
                padding-bottom: 0.5rem;
            }

            .px-3 {
                padding-left: 0.75rem;
                /* 12px */
                padding-right: 0.75rem;
            }

            .border {
                border-width: 1px;
            }

            .border-gray-300 {
                border-color: #d2d6dc;
                /* Equivalent to a light shade of gray */
            }

            .bg-white {
                background-color: #ffffff;
            }

            .rounded-md {
                border-radius: 0.375rem;
                /* 6px */
            }

            .shadow-sm {
                box-shadow: 0 1px 2px 0 rgba(0, 0, 0, 0.05);
            }

            .focus\:outline-none:focus {
                outline: 2px solid transparent;
                outline-offset: 2px;
            }

            .focus\:ring-purple-500:focus {
                box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.5);
            }

            .focus\:border-purple-500:focus {
                border-color: #8b5cf6;
                /* Equivalent to a medium shade of purple */
            }

            /* Button styles */
            .w-full {
                width: 100%;
            }

            .py-2 {
                padding-top: 0.5rem;
                /* 8px */
                padding-bottom: 0.5rem;
            }

            .px-4 {
                padding-left: 1rem;
                /* 16px */
                padding-right: 1rem;
            }

            .bg-purple-600 {
                background-color: #6b46c1;
                /* Equivalent to a medium shade of purple */
            }

            .text-white {
                color: #ffffff;
            }

            .font-semibold {
                font-weight: 600;
            }

            .rounded-md {
                border-radius: 0.375rem;
                /* 6px */
            }

            .shadow-md {
                box-shadow: 0 4px 6px -1px rgba(0, 0, 0, 0.1),
                    0 2px 4px -2px rgba(0, 0, 0, 0.1);
            }

            .hover\:bg-purple-700:hover {
                background-color: #553c9a;
                /* Equivalent to a darker shade of purple */
            }

            .focus\:outline-none:focus {
                outline: 2px solid transparent;
                outline-offset: 2px;
            }

            .focus\:ring-2:focus {
                box-shadow: 0 0 0 2px rgba(139, 92, 246, 0.5);
            }

            .focus\:ring-purple-500:focus {
                box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.5);
            }

            .focus\:ring-opacity-75:focus {
                box-shadow: 0 0 0 3px rgba(139, 92, 246, 0.75);
            }
        </style>
        <div class="max-w-md mx-auto mt-10 p-6 bg-white shadow-md rounded-lg">
            <h2 class="text-xl font-semibold text-center text-purple-800">Seleccione una línea</h2>
            <p class="text-center text-gray-500 mb-6">Seleccione línea y posteriormente un estilo para evaluar calidad
            </p>

            <form wire:submit.prevent="submit" class="space-y-4">
                <div>
                    <label for="linea" class="block text-sm font-medium text-gray-700">Por Favor Seleccione
                        línea</label>
                    <select id="linea" wire:model="selectedLinea"
                        class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <option value="">Seleccione una línea</option>
                        @foreach ($lineas as $linea)
                            <option value="{{ $linea }}">{{ $linea }}</option>
                        @endforeach
                    </select>
                </div>

                <div>
                    <label for="estilo" class="block text-sm font-medium text-gray-700">Seleccione una opción
                        ESTILO</label>
                    <select id="estilo" wire:model="selectedEstilo"
                        class="mt-1 block w-full py-2 px-3 border border-gray-300 bg-white rounded-md shadow-sm focus:outline-none focus:ring-purple-500 focus:border-purple-500">
                        <option value="">Seleccione un estilo</option>
                        @foreach ($estilos as $estilo)
                            <option value="{{ $estilo }}">{{ $estilo }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="text-center">
                    <button type="submit"
                        class="w-full py-2 px-4 bg-purple-600 text-white font-semibold rounded-md shadow-md hover:bg-purple-700 focus:outline-none focus:ring-2 focus:ring-purple-500 focus:ring-opacity-75">
                        Siguiente
                    </button>
                </div>
            </form>
        </div>

    </div>
