<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('procedimientos_proceso_produccion', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('procedimiento_id');
            $table->unsignedBigInteger('proceso_id');
            $table->timestamps();
            $table->softDeletes();

            $table->foreign('procedimiento_id')->references('id')->on('procedimientos_produccion');
            $table->foreign('proceso_id')->references('id')->on('procesos_produccion');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('procedimientos_proceso_produccion');
    }
};
