<?php

namespace App\Filament\Resources;

use App\Filament\Resources\UserResource\Pages;
use App\Filament\Resources\UserResource\RelationManagers;
use App\Models\User;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class UserResource extends Resource
{
    protected static ?string $model = User::class;

    protected static ?string $navigationIcon = 'heroicon-o-user';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('name')
                    ->label('Nombre')
                    ->required()
                    ->maxLength(255),
                Forms\Components\TextInput::make('email')
                    ->label('Correo')
                    ->email()
                    ->required()
                    ->maxLength(255),
                Forms\Components\Select::make('role')
                    ->label('Rol')
                    ->native(false)
                    ->options([
                        6 => 'Asistente Calidad',
                        7 => 'Inspector Calidad',
                        8 => 'TV/Monitor',
                        9 => 'Administrador',
                    ])
                    ->required(),
                Forms\Components\TextInput::make('celular')
                    ->tel()
                    ->maxLength(255),
                Forms\Components\TextInput::make('password')
                    ->label('Contraseña')
                    ->placeholder('Dejar en blanco para no modificar')
                    ->visible()
                    ->password()
                    ->required()
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('name')
                    ->label('Nombre')
                    ->searchable(),
                Tables\Columns\TextColumn::make('email')
                    ->label('Correo')
                    ->searchable(),
                Tables\Columns\TextColumn::make('celular')
                    ->searchable(),
                Tables\Columns\TextColumn::make('role')
                    ->formatStateUsing(function ($state) {
                        return match ($state) {
                            6 => 'Asistente Calidad',
                            7 => 'Inspector Calidad',
                            8 => 'TV/Monitor',
                            9 => 'Administrador',
                            default => 'Desconocido',
                        };
                    })
                    ->sortable(),
                Tables\Columns\TextColumn::make('estado')
                    ->formatStateUsing(function ($state) {
                        return match ($state) {
                            0 => 'Inactivo',
                            1 => 'Activo',
                            default => 'Desconocido',
                        };
                    })
                    ->badge()
                    ->color(fn ($state) => match ($state) {
                        0 => 'danger',
                        1 => 'success',
                        default => 'warning',
                    })
                    ->sortable(),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                //
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getEloquentQuery(): Builder
    {
        return parent::getEloquentQuery()
            ->where('role', 9);
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListUsers::route('/'),
            'create' => Pages\CreateUser::route('/create'),
            'edit' => Pages\EditUser::route('/{record}/edit'),
        ];
    }

    public static function getLabel(): ?string
    {
        return 'Usuarios';
    }
}
