<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ProcesoResource\Pages;
use App\Filament\Resources\ProcesoResource\RelationManagers;
use App\Models\Proceso;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ProcesoResource extends Resource
{
    protected static ?string $model = Proceso::class;

    protected static ?string $navigationIcon = 'heroicon-o-paper-airplane';

    protected static ?int $navigationSort = 5;

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\TextInput::make('descripcion')
                    ->required()
                    ->columnSpanFull()
                    ->maxLength(255),
                Forms\Components\TextInput::make('meta')
                    ->required()
                    ->columnSpanFull()
                    ->numeric(),
                Forms\Components\Select::make('estilo_id')
                    ->label('Estilo a Utilizar')
                    ->options(
                        \App\Models\Estilo::pluck('descripcion', 'id')->toArray()
                    )
                    ->native(false)
                    ->label('Estilo')
                    ->columnSpanFull()
                    ->required(),
                Forms\Components\Select::make('linea_id')
                    ->label('Línea de Producción')
                    ->options(
                        \App\Models\Linea::pluck('nombre', 'id')->toArray()
                    )
                    ->native(false)
                    ->label('Línea')
                    ->columnSpanFull()
                    ->required(),
                Forms\Components\Repeater::make('procedimientosProceso')
                    ->relationship()
                    ->schema([
                        Forms\Components\Select::make('procedimiento_id')
                            ->label('Procedimiento')
                            ->options(
                                \App\Models\Procedimiento::pluck('descripcion', 'id')->toArray()
                            )
                            ->native(false)
                            ->required(),
                        Forms\Components\Select::make('defectos')
                            ->label('Defectos')
                            ->multiple()
                            ->relationship(name: 'defectos', titleAttribute: 'descripcion')
                            ->options(
                                \App\Models\Defecto::pluck('descripcion', 'id')->toArray()
                            )
                            ->native(false)
                            ->required(),
                    ])
                    ->columnSpanFull()
                    ->columns(2)
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('ID Proceso')
                    ->sortable(),
                Tables\Columns\TextColumn::make('descripcion')
                    ->searchable(),
                Tables\Columns\TextColumn::make('estilo.descripcion'),
                Tables\Columns\TextColumn::make('linea.nombre'),
                Tables\Columns\TextColumn::make('meta')
                    ->numeric()
                    ->sortable(),
                Tables\Columns\TextColumn::make('updated_at')
                    ->label('Ultima Actualización')
                    ->since(),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
                Tables\Actions\Action::make('meta')
                    ->label('Actualizar Meta')
                    ->form([
                        Forms\Components\TextInput::make('meta')
                            ->required()
                            ->numeric()
                    ])
                    ->action(function (Proceso $proceso, array $data) {
                        $meta = $data['meta'];
                        $proceso->update(['meta' => $meta]);
                    })
                    ->icon('heroicon-o-pencil')
                    ->modalHeading('Actualizar Meta') // Opcional: Título del modal
                    ->modalSubmitActionLabel('Guardar'), // Opcional: Texto del botón del modal
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                //
            ]);
    }

    public static function getRelations(): array
    {
        return [
            // RelationManagers\ProcedimientosProcesoRelationManager::class,
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListProcesos::route('/'),
            // 'create' => Pages\CreateProceso::route('/create'),
            // 'edit' => Pages\EditProceso::route('/{record}/edit'),
        ];
    }

    public static function getNavigationGroup(): ?string
    {
        return 'Parametrización';
    }

    public static function getModelLabel(): string
    {
        return 'Linea de Producción';
    }

    public static function getNavigationLabel(): string
    {
        return 'Lineas de Producción';
    }

    public static function getPluralLabel(): ?string
    {
        return 'Lineas de Producción';
    }
}
