<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('auth.login');
});

Auth::routes();

Route::get('/dashboard', 'HomeController@index')->name('home');
Route::group(['prefix' => 'ventas'], function() {
    //Cotizaciones
    Route::get('dashboard', 'VentasController@index')->name('ventas.dashboard');
    Route::get('dashboard_gerencia', 'VentasController@dashboardCotizacionesG')->name('ventas.dashboard_gerencia');
    Route::get('cotizacion', 'VentasController@nueva_cotizacion')->name('ventas.cotizacion');
    Route::post('guardar_cotizacion', 'VentasController@guardar_cotizacion')->name('ventas.guardar_cotizacion');
    Route::post('archivar_cotizacion', 'VentasController@archivar_cotizacion')->name('ventas.archivar_cotizacion');
    Route::post('cotizacion_produccion', 'VentasController@cotizacion_produccion')->name('ventas.cotizacion_produccion');
    Route::get('cotizacion_archivadas', 'VentasController@cotizacion_archivadas')->name('ventas.cotizacion_archivadas');
    Route::get('editar_cotizacion/{idCotizacion}', 'VentasController@editarCotizacion')->name('ventas.editar_cotizacion');
    Route::get('cotizacion_ok/{idCotizacion}', 'VentasController@okCotizacion')->name('ventas.ok_cotizacion');
    Route::get('cotizacion_enviar/{idCotizacion}', 'VentasController@cotizacionEnviar')->name('ventas.cotizacion_enviar');
    Route::get('cotizacion_ok2/{idCotizacion}', 'VentasController@okCotizacion2')->name('ventas.ok_cotizacion2');
    Route::post('cotizacion_ok3', 'VentasController@okCotizacion3')->name('ventas.ok_cotizacion3');
    Route::post('actualizar_cotizacion/{idCotizacion}', 'VentasController@actualizarCotizacion')->name('ventas.actualizar_cotizacion');
    Route::get('cotizacion_pdf', 'VentasController@cotizacionPdf')->name('ventas.cotizacion_pdf');
    Route::get('buscar_producto', 'VentasController@buscarProducto')->name('ventas.buscar_producto');
    Route::get('buscar_producto_prima', 'VentasController@buscarProductoPrima')->name('ventas.buscar_producto_prima');
    //Ventas
    Route::get('dashboard_pedidos', 'VentasController@dashboardPedidos')->name('ventas.dashboard_pedidos');
    Route::get('pedidos_venta', 'VentasController@pedidoVenta')->name('ventas.pedido_venta');
    Route::get('dashboard_facturar', 'VentasController@dashboardFacturar')->name('ventas.dashboard_facturar');
    Route::get('pedidos_facturar', 'VentasController@pedidoFacturar')->name('ventas.pedido_facturar');
    Route::get('dashboard_produccion', 'VentasController@dashboardOrdenProduccion')->name('ventas.dashboard_produccion');
    Route::get('dashboard_produccion_gerencia', 'VentasController@dashboardOrdenProduccionGerencia')->name('ventas.dashboard_produccion_gerencia');
    Route::get('orden_produccion/{idCotizacionProducto}', 'VentasController@ordenProduccion')->name('ventas.orden_produccion');
    
    //Orden Produccion
    Route::get('nueva_op', 'VentasController@nuevaOP')->name('ventas.nueva_op');
    Route::post('guardar_op', 'VentasController@guardarOP')->name('ventas.guardar_op');
    Route::get('aprobar_op/{idOrden}', 'VentasController@aprobarOP')->name('ventas.aprobar_op');
    Route::post('orden_produccion_ok/{op}', 'VentasController@actualizarOkOP')->name('ventas.orden_produccion_ok');
    Route::post('orden_produccion_ok2/{op}', 'VentasController@actualizarOkOP2')->name('ventas.orden_produccion_ok2');
    Route::get('orden_produccion_ver/{idOrden}', 'VentasController@verOP')->name('ventas.orden_produccion_ver');
    Route::post('anular_op', 'VentasController@anularOP')->name('ventas.anular_op');
    Route::get('anular_op_gerencia/{idOrden}', 'VentasController@anularOPG')->name('ventas.anular_op_gerencia');
    //Productos
    Route::get('dashboard_productos', 'VentasController@dashboardProducto')->name('ventas.dashboard_producto');
    Route::get('producto', 'VentasController@producto')->name('ventas.producto');
    Route::post('guardar_producto', 'VentasController@guardar_producto')->name('ventas.guardar_producto');
    Route::post('buscar_producto', 'VentasController@buscar_producto')->name('ventas.buscar_producto');
    Route::get('editar_producto/{idProducto}', 'VentasController@editarProducto')->name('ventas.editar_producto');
    Route::post('actualizar_producto/{producto}', 'VentasController@actualizarProducto')->name('ventas.actualizar_producto');
    Route::get('eliminar_producto/{id}', 'VentasController@eliminarProducto')->name('ventas.eliminar_producto');
    //
    Route::get('productos_tipos', 'VentasController@productoTipos')->name('ventas.productos_tipos');
    Route::get('productos_tipos_nuevo', 'VentasController@productoTiposNuevo')->name('ventas.productos_tipos_nuevo');
    Route::post('productos_tipos_guardar', 'VentasController@productoTiposGuardar')->name('ventas.productos_tipos_guardar');
    Route::get('productos_tipos_eliminar/{id}', 'VentasController@productoTiposEliminar')->name('ventas.productos_tipos_eliminar');
    //
    Route::get('productos_categorias', 'VentasController@productoCategorias')->name('ventas.productos_categorias');
    Route::get('productos_categorias_nuevo', 'VentasController@productoCategoriasNuevo')->name('ventas.productos_categorias_nuevo');
    Route::post('productos_categorias_guardar', 'VentasController@productoCategoriasGuardar')->name('ventas.productos_categorias_guardar');
    Route::get('productos_categorias_eliminar/{id}', 'VentasController@productoCategoriasEliminar')->name('ventas.productos_categorias_eliminar');
    //
    Route::get('productos_medidas', 'VentasController@productoMedidas')->name('ventas.productos_medidas');
    Route::get('productos_medidas_nuevo', 'VentasController@productoMedidasNuevo')->name('ventas.productos_medidas_nuevo');
    Route::post('productos_medidas_guardar', 'VentasController@productoMedidasGuardar')->name('ventas.productos_medidas_guardar');
    Route::get('productos_medidas_eliminar/{id}', 'VentasController@productoMedidasEliminar')->name('ventas.productos_medidas_eliminar');
    //Clientes
    Route::get('dashboard_clientes', 'VentasController@dashboardClientes')->name('ventas.dashboard_clientes');
    Route::get('cliente', 'VentasController@cliente')->name('ventas.cliente');
    Route::post('guardar_cliente', 'VentasController@guardar_cliente')->name('ventas.guardar_cliente');
    Route::post('buscar_cliente', 'VentasController@buscar_cliente')->name('ventas.buscar_cliente');
    Route::get('editar_cliente/{idCliente}', 'VentasController@editarCliente')->name('ventas.editar_cliente');
    Route::post('actualizar_cliente/{cliente}', 'VentasController@actualizarCliente')->name('ventas.actualizar_cliente');
    Route::get('eliminar_cliente/{id}', 'VentasController@eliminarCliente')->name('ventas.eliminar_cliente');
});

Route::group(['prefix' => 'compras'], function() {
    Route::get('dashboard', 'ComprasController@index')->name('compras.dashboard');
    Route::get('orden_compra', 'ComprasController@ordenCompra')->name('compras.orden_compra');

});
Route::group(['prefix' => 'inventario'], function() {
    Route::get('dashboard', 'InventarioController@index')->name('inventario.dashboard');
    Route::get('dashboard_salida', 'InventarioController@salidaAlamacen')->name('inventario.dashboard_salida');
    Route::get('dashboard_envios', 'InventarioController@enviosAlamacen')->name('inventario.dashboard_envios');
    Route::get('dashboard_archivo', 'InventarioController@dashboardArchivo')->name('inventario.dashboard_archivo');
    Route::get('dashboard_inventario', 'InventarioController@dashboardInventario')->name('inventario.dashboard_inventario');
    Route::get('dashboard_inventario_materia_prima', 'InventarioController@dashboardInventarioMateriaPrima')->name('inventario.dashboard_inventario_materia_prima');
    Route::get('dashboard_inventario_materia_prima_salidas', 'InventarioController@dashboardInventarioMateriaPrimaSalidas')->name('inventario.dashboard_inventario_materia_prima_salidas');
    Route::get('op_ok/{ordenProduccionP}', 'InventarioController@ordenProduccionRecibido')->name('inventario.op_ok');
    Route::post('ingreso_almacen', 'InventarioController@ingresoAlmacen')->name('inventario.ingreso_almacen');
    Route::post('salida_almacen_ajax', 'InventarioController@salidaAlmacenFactura')->name('inventario.salida_almacen_ajax');
    Route::post('salida_almacen_ajax_inventario', 'InventarioController@salidaAlmacenFacturaInventario')->name('inventario.salida_almacen_ajax_inventario');
    Route::post('salida_almacen_ajax_inventario_eliminar', 'InventarioController@salidaAlmacenFacturaInventarioEliminar')->name('inventario.salida_almacen_ajax_inventario_eliminar');
    Route::post('salida_almacen_inventario_ajax', 'InventarioController@salidaAlmacenInventario')->name('inventario.salida_almacen_inventario_ajax');
    Route::post('almacen_terminar_ajax', 'InventarioController@salidaAlmacenTerminar')->name('inventario.almacen_terminar_ajax');
    Route::post('almacen_terminar_inventario_ajax', 'InventarioController@salidaAlmacenInventarioTerminar')->name('inventario.almacen_terminar_inventario_ajax');
    Route::get('historial_producto/{idProducto}', 'InventarioController@historialProducto')->name('inventario.salida_almacen');
    Route::get('generar_envio/{idEnvio}', 'InventarioController@generarEnvio')->name('inventario.generar_envio');
    Route::get('ajuste_inventario', 'InventarioController@ajusteInventario')->name('inventario.ajuste_inventario');
    Route::get('ajuste_inventario_prima', 'InventarioController@ajusteInventarioPrima')->name('inventario.ajuste_inventario_prima');
    Route::post('ajuste_inventario_guardar', 'InventarioController@ajusteInventarioGuardar')->name('inventario.ajuste_inventario_guardar');
    Route::post('ajuste_inventario_prima_guardar', 'InventarioController@ajusteInventarioPrimaGuardar')->name('inventario.ajuste_inventario_prima_guardar');
    Route::post('ingreso_almacen_ajax', 'InventarioController@ingresoAlmacenAjax')->name('inventario.ingreso_almacen_ajax');
    Route::post('salida_almacen_facturacion', 'InventarioController@salidaAlmacenFacturacion')->name('inventario.salida_almacen_facturacion');
});
//Fabricacion
Route::group(['prefix' => 'fabricacion'], function() {
    Route::get('dashboard', 'FabricacionController@index')->name('fabricacion.dashboard');
    Route::get('orden_produccion/{id}', 'FabricacionController@ordenProduccion')->name('fabricacion.orden_produccion');
    Route::get('orden_produccion_terminar/{id}', 'FabricacionController@ordenProduccionTerminar')->name('fabricacion.orden_produccion_terminar');
    Route::post('op_actualizar/{op}', 'FabricacionController@actualizarOP')->name('fabricacion.op_actualizar');
    Route::post('op_parcial', 'FabricacionController@parcialOP')->name('fabricacion.op_parcial');
    Route::post('op_parcial_editar', 'FabricacionController@parcialOPEditar')->name('fabricacion.op_parcial_editar');
    Route::post('op_parcial_eliminar', 'FabricacionController@eliminarEntregaParcial')->name('fabricacion.op_parcial_eliminar');
    Route::post('op_parcial_rechazar', 'FabricacionController@rechazarEntregaParcial')->name('fabricacion.op_parcial_rechazar');
    Route::post('op_parcial_actualizar', 'FabricacionController@parcialOPActualizar')->name('fabricacion.op_parcial_actualizar');
});
//Contabilidad
Route::group(['prefix' => 'contabilidad'], function() {
    Route::get('dashboard', 'ContabilidadController@index')->name('contabilidad.dashboard');
    Route::get('factura/{idSalida}', 'ContabilidadController@factura')->name('contabilidad.factura');
    Route::get('nueva_factura', 'ContabilidadController@facturaNueva')->name('contabilidad.nueva_factura');
    Route::post('guardar_factura', 'ContabilidadController@guardarFactura')->name('contabilidad.guardar_factura');
    Route::post('guardar_factura_nueva', 'ContabilidadController@guardarFacturaNueva')->name('contabilidad.guardar_factura_nueva');
    Route::get('dashboard_facturas', 'ContabilidadController@mostrarFacturas')->name('contabilidad.dashboard_facturas');
    Route::get('recibo_caja/{idFactura}', 'ContabilidadController@reciboCaja')->name('contabilidad.recibo_caja');
    Route::post('cancelar_factura', 'ContabilidadController@cancelarFactura')->name('contabilidad.cancelar_factura');
    Route::post('recibo_caja_facturas', 'ContabilidadController@reciboCajaFactura')->name('contabilidad.recibo_caja_facturas');
    Route::get('ver_recibo_caja/{id_recibo}', 'ContabilidadController@verReciboCaja')->name('contabilidad.ver_recibo_caja');
    Route::post('guardar_recibo_caja', 'ContabilidadController@guardarReciboCaja')->name('contabilidad.guardar_recibo_caja');
    Route::get('dashboard_facturas_canceladas', 'ContabilidadController@mostrarFacturasCanceladas')->name('contabilidad.dashboard_facturas_canceladas');
    Route::get('dashboard_cuenta_corriente', 'ContabilidadController@cuentaCorriente')->name('contabilidad.dashboard_cuenta_corriente');
    Route::get('ver_cuenta_corriente/{id_cliente}', 'ContabilidadController@verCuentaCorriente')->name('contabilidad.ver_cuenta_corriente');
});