<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="<?php echo e(asset('images/favicon.png')); ?>">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php echo e(config('app.name', 'Laravel')); ?></title>

    <!-- Scripts -->
  

    <script src="<?php echo e(asset('js/app.js')); ?>"></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">

    <!-- Styles -->
    <link href="<?php echo e(asset('css/app.css')); ?>" rel="stylesheet">

    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/1.10.19/css/jquery.dataTables.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/1.5.6/css/buttons.dataTables.min.css"/>
    <link href="<?php echo e(asset('css/style.min.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('css/extras.css')); ?>" rel="stylesheet">

    <script src="<?php echo e(asset('js/sweetalert2.min.js')); ?>"></script>
    <script src="https://cdn.jsdelivr.net/gh/gitbrent/bootstrap4-toggle@3.6.1/js/bootstrap4-toggle.min.js"></script>
    <script src="https://cdn.datatables.net/1.10.21/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.flash.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.print.min.js"></script>

    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.dataTables.min.css">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.8.4/moment.min.js"></script>
    <script src="https://cdn.datatables.net/plug-ins/1.12.1/sorting/datetime-moment.js"></script>

</head>
<body>
    <?php if(auth()->guard()->guest()): ?>
                            
    <?php else: ?>
    <div id="appInterna">
        <?php endif; ?>
        <main class="">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
    </div>
</body>
<script src="<?php echo e(asset('js/moment.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/picker.js')); ?>"></script>
<script src="<?php echo e(asset('js/picker.date.js')); ?>"></script>
<script src="<?php echo e(asset('js/daterangepicker.js')); ?>"></script>

<script src="https://cdn.datatables.net/responsive/2.3.0/js/dataTables.responsive.min.js"></script>

<script>
    $(document).ready(function(){
        $("#myTab li:eq(0) a").tab('show');
        $('#example').DataTable({
            "order":[[ 0, "desc" ]],
            "paging": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive:{
                breakpoints: [
                    { name: 'desktop', width: 920 },
                    { name: 'tablet',  width: 768 },
                    { name: 'fablet',  width: 668},
                    { name: 'phone',   width: 480 }
                ]
            }
            
        });
        $('#example_edit').DataTable({
            "order":[[ 0, "desc" ]],
            "paging": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive:{
                breakpoints: [
                    { name: 'desktop', width: 920 },
                    { name: 'tablet',  width: 768 },
                    { name: 'fablet',  width: 668},
                    { name: 'phone',   width: 480 }
                ]
            },
            columnDefs: [
                { responsivePriority: 3, targets: 0 },
                { responsivePriority: 0, targets: 2 },
                { responsivePriority: 1, targets: -1 }
            ]
            
        });
        $('#example_edit2').DataTable({
            "order":[[ 0, "desc" ]],
            "paging": false,
            dom: 'Bfrtip',
            buttons: [
                'excel', 'print'
            ],

            responsive:{
                breakpoints: [
                    { name: 'desktop', width: 920 },
                    { name: 'tablet',  width: 768 },
                    { name: 'fablet',  width: 668},
                    { name: 'phone',   width: 480 }
                ]
            },
            columnDefs: [
                { responsivePriority: 3, targets: 0 },
                { responsivePriority: 0, targets: 2 },
                { responsivePriority: 1, targets: -2 }
            ]
            
        });
        $('.daterange-single').daterangepicker({
            singleDatePicker: true,
            locale: {
                format: 'DD-MM-YYYY'
            }
        });
    })
    <?php if(session('message')): ?>
        Swal.fire({
            position: 'top-end',
            title: "<?php echo e(session('message')); ?>",
            showConfirmButton: false,
            timer: 1500
        });
    <?php endif; ?>
</script>
</html>
<?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/layouts/app.blade.php ENDPATH**/ ?>