<?php $__env->startSection('content'); ?>
    
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Trazabilidad de Produccion</h2>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#registroModal">
                    Registrar Produccion
                </button>
            </div>
        </div>
        <div class="container mt-4">
            <form method="GET" action="<?php echo e(route('fabricacion.filtrar_trazabilidad')); ?>" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_inicio">Fecha Inicio</label>
                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_fin">Fecha Fin</label>
                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="linea_id_filtro">Línea</label>
                            <select class="form-control" id="linea_id_filtro" name="linea_id">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $lineas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($linea->id); ?>"><?php echo e($linea->nombre); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    
                </div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </form>
        </div>
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>#</td>
                        <td>Linea</td>
                        <td>Fecha</td>
                        <td>Estilo</td>
                        <td>Curva/Meta</td>
                        <td>Produccion</td>
                        <td>Produccion Acumulada</td>
                        <td>% Productividad</td>
                        <td>SMV</td>
                        <td>Operarios</td>
                        <td>Minutos</td>
                        <td>Meta</td>
                        <td>% Curva</td>
                        <td>PO</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    <?php
                        $produccion_acumulada = 0;
                    ?>
                    <?php $__currentLoopData = $producciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $colorEstado = match ($produccion->estado) {
                                0 => 'danger',
                                1 => '',
                                2 => 'danger',
                                default => 'warning',
                            };

                            $meta = ($produccion->minutos / $produccion->smv) * $produccion->operarios;
                            $curva_meta = $meta * ($produccion->curva_porcentaje / 100);
                            $producido = $produccion->producido ?? 0;
                            $porcentaje_productividad = ($producido / $curva_meta) * 100;
                            $produccion_acumulada += $producido;
                        ?>
                        <tr>
                            <td class="alert alert-<?php echo e($colorEstado); ?>">
                                <?php echo e($produccion->id); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->linea?->nombre); ?> - <?php echo e($produccion->linea?->encargado?->name); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->created_at->format('d/m/Y')); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->estilo); ?>

                            </td>
                            <td>
                                <?php echo e($curva_meta); ?>

                            </td>
                            <td>
                                <?php echo e($producido); ?>

                            </td>
                            <td>
                                <?php echo e($produccion_acumulada); ?>

                            </td>
                            <td>
                                <?php echo e(number_format($porcentaje_productividad, 2)); ?>%
                            </td>
                            </td>
                            <td>
                                <?php echo e($produccion->smv); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->operarios); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->minutos); ?>

                            </td>
                            <td>
                                <?php echo e($meta); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->curva_porcentaje); ?>%
                            </td>
                            <td>
                                <?php echo e($produccion->po); ?>

                            </td>
                            <td class="d-flex justify-content-center align-items-center">
                                <?php if($produccion->estado == 1): ?>
                                    <button class="btn btn-danger" onclick="anular('<?php echo e($produccion->id); ?>')">
                                        ANULAR
                                    </button>
                                <?php else: ?>
                                    ANULADO
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    
                </tbody>
            </table>
        </div>
    </div>

    
    <div class="modal fade" id="registroModal" tabindex="-1" role="dialog" aria-labelledby="registroModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width:800px !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="registroModalLabel">Agregar Registro</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="registroForm" method="POST" action="<?php echo e(route('fabricacion.guardar_trazabilidad')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="number" hidden name="trazabilidad_id" id="trazabilidad_id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="estilo">Estilo</label>
                                    <input type="text" class="form-control" id="estilo" name="estilo" required>
                                </div>
                                <div class="form-group">
                                    <label for="smv">SMV</label>
                                    <input type="number" step="0.01" class="form-control" id="smv" name="smv"
                                        required>
                                </div>
                                <div class="form-group">
                                    <label for="operarios">Operarios</label>
                                    <input type="number" class="form-control" id="operarios" name="operarios" required>
                                </div>
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="minutos">Minutos</label>
                                    <input type="number" step="0.01" class="form-control" id="minutos"
                                        name="minutos" required>
                                </div>
                                <div class="form-group">
                                    <label for="curva_porcentaje">% Curva</label>
                                    <input type="number" step="0.01" class="form-control" id="curva_porcentaje"
                                        name="curva_porcentaje" required>
                                </div>
                                <div class="form-group">
                                    <label for="po">PO</label>
                                    <input type="text" class="form-control" id="po" name="po" required>
                                </div>
                                <div class="form-group">
                                    <label for="linea_id">Línea</label>
                                    <select class="form-control" id="linea_id" name="linea_id" required>
                                        <option value="">Seleccione una línea</option>
                                        <?php $__currentLoopData = $lineas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($linea->id); ?>"><?php echo e($linea->nombre); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const minutosInput = document.getElementById('minutos');
            const smvInput = document.getElementById('smv');
            const operariosInput = document.getElementById('operarios');
            const metaInput = document.getElementById('meta');

            function calculateMeta() {
                const minutos = parseFloat(minutosInput.value) || 0;
                const smv = parseFloat(smvInput.value) || 0;
                const operarios = parseFloat(operariosInput.value) || 0;

                if (smv !== 0) {
                    const meta = (minutos / smv) * operarios;
                    metaInput.value = Math.round(meta);
                } else {
                    metaInput.value = 0;
                }
            }

            minutosInput.addEventListener('input', calculateMeta);
            smvInput.addEventListener('input', calculateMeta);
            operariosInput.addEventListener('input', calculateMeta);
        });
    </script>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function anular() {
            Swal.fire({
                title: 'Anular',
                text: '¿Desea anular este ingreso?',
                icon: 'danger',
                showCancelButton: true,
                confirmButtonText: 'Sí, solicitar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        'Anulado',
                        'El ingreso ha sido anulado.',
                        'success'
                    );
                }
            });
        }

        function editarRegistro(id, producto, estilo, descripcion, meta_curva, produccion, smv, operarios, minutos, meta,
            curva_porcentaje, po, estado, tipo, linea_id, encargado_id) {
            document.getElementById('trazabilidad_id').value = id;
            document.getElementById('producto').value = producto;
            document.getElementById('estilo').value = estilo;
            document.getElementById('descripcion').value = descripcion;
            document.getElementById('meta_curva').value = meta_curva;
            document.getElementById('produccion').value = produccion;
            document.getElementById('smv').value = smv;
            document.getElementById('operarios').value = operarios;
            document.getElementById('minutos').value = minutos;
            document.getElementById('meta').value = meta;
            document.getElementById('curva_porcentaje').value = curva_porcentaje;
            document.getElementById('po').value = po;
            document.getElementById('linea_id').value = linea_id;
            document.getElementById('encargado_id').value = encargado_id;
            $('#registroModal').modal('show');
        }

        function limpiarFormulario() {
            document.getElementById('registroForm').action =
                '<?php echo e(route('fabricacion.guardar_trazabilidad')); ?>'; // Cambia la acción del formulario para crear
            document.getElementById('registroForm').reset();
            $('#registroModal').modal('show');
        }

        document.addEventListener('DOMContentLoaded', function() {
            const minutosInput = document.getElementById('minutos');
            const smvInput = document.getElementById('smv');
            const operariosInput = document.getElementById('operarios');
            const metaInput = document.getElementById('meta');

            function calculateMeta() {
                const minutos = parseFloat(minutosInput.value) || 0;
                const smv = parseFloat(smvInput.value) || 0;
                const operarios = parseFloat(operariosInput.value) || 0;

                if (smv !== 0) {
                    const meta = (minutos / smv) * operarios;
                    metaInput.value = meta.toFixed(2);
                } else {
                    metaInput.value = 0;
                }
            }

            minutosInput.addEventListener('input', calculateMeta);
            smvInput.addEventListener('input', calculateMeta);
            operariosInput.addEventListener('input', calculateMeta);
        });

        function anular(id) {
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, anular'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`/fabricacion/trazabilidad/${id}/anulacion`, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire(
                                    'Anulado!',
                                    'El registro ha sido anulado.',
                                    'success'
                                ).then(() => {
                                    location.reload(); // Recargar la página después de la confirmación
                                });
                            } else {
                                Swal.fire(
                                    'Error!',
                                    data.message || 'Hubo un problema al anular el registro.',
                                    'error'
                                );
                            }
                        })
                        .catch((error) => {
                            Swal.fire(
                                'Error!',
                                'Hubo un problema al anular el registro.',
                                'error'
                            );
                        });
                }
            });
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/fabricacion/dashboard_trazabilidad.blade.php ENDPATH**/ ?>