<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\SalidaAlmacen;
use App\CotizacionProductos;
use App\Cliente;
use App\Producto;
use App\User;
use App\Facturas;
use App\ReciboCaja;
use App\ReciboCajaFactura;
use App\NotaDebito;
use App\Cotizacion;
use App\Ajustes;
use PDF;
use DateTime;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
?>




<?php $__env->startSection('content'); ?>
    <style>
        .form-check {
            display: inline-block;
            top: -15px;
            left: 13px;
        }

        .verTotal22 {
            text-align: right;
            margin-right: 400px;
            font-size: 17px;
            font-weight: 700;
        }

        .regresar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .eliminar {
            margin-top: -10px;
            padding-left: 6px;
        }

        .nota_ {
            margin-top: -10px;
            padding-left: 6px;
        }

        .fa-upload {
            padding-top: 5px;
            padding-left: 6px;
        }
    </style>

    <div id="contenedor-dashboard" class="container-fluid">

        <form action="<?php echo e(route('rrhh.comisiones_por_usuario_fecha')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="row p-3">
                <div class="col-md-2">
                    <h2>Detalle de comisiones</h2>
                </div>
                <div class="row p-2">
                    <div class="col-md-16">
                        <select class="form-control" name="mes">
                            <option selected disabled value="0">Escoger mes</option>
                            <option value="1">Enero</option>
                            <option value="2">Febrero</option>
                            <option value="3">Marzo</option>
                            <option value="4">Abril</option>
                            <option value="5">Mayo</option>
                            <option value="6">Junio</option>
                            <option value="7">Julio</option>
                            <option value="8">Agosto</option>
                            <option value="9">Septiembre</option>
                            <option value="10">Octubre</option>
                            <option value="11">Noviembre</option>
                            <option value="12">Diciembre</option>
                        </select>
                    </div>
                </div>
                <div class="row p-2">
                    <div class="col-md-16">
                        <select class="form-control" name="anio" id="anio">
                            <option value="0">Escoger año</option>
                            <option value="2022">2022</option>
                            <option value="2023">2023</option>
                            <option value="2024">2024</option>
                            <option value="2025">2025</option>
                        </select>
                    </div>
                </div>
                <div class="row p-2">
                    <div class="col-md-1">
                        <input type="hidden" name="userselect" value="<?php echo $idUsuario; ?>">
                        <button class="btn btn-primary" type="submit">Buscar</button>
                    </div>
                </div>
            </div>
        </form>

        <div class="col-md-12">
            <table id="example2" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Fecha de cobro</td>
                        <td>Vendedor</td>
                        <td>Cliente</td>
                        <td>Factura</td>
                        <td>Valor de factura</td>
                        <td>No. Recibo de Caja</td>
                        <td>Total pagado</td>
                        <td>Capuchón</td>
                        <td>BOPP/ PVC / Plastipel</td>
                        <td>Lienzos Carton / PVC</td>
                        <td>IVA</td>
                        <td>Valor afecto Comisión</td>
                        <td>Cálculo comisión</td>
                        <td style="visibility: hidden">Cálculo Number</td>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $recibos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $sum_totales = $factura->efectivo + $factura->cheque + $factura->retencion;
                        $valor_real_cancelado = floatval($sum_totales);
                        ?>
                        <tr>
                            <td> <?php echo e($factura->fecha_cobro); ?> </td>
                            <td> <?php echo e($factura->vendedor); ?> </td>
                            <td> <?php echo e($factura->cliente); ?> </td>
                            <td> <?php echo e($factura->no_sat ?? ''); ?> </td>
                            <td>Q <?php echo e(number_format($factura->facturado ?? '', 2, '.', ',')); ?> </td>
                            <td> <?php echo e($factura->no_recibo); ?> </td>
                            <td style="border-right: 1px solid #848484;">Q
                                <?php echo e(number_format($valor_real_cancelado ?? '', 2, '.', ',')); ?></td>
                            
                            <?php if ($factura->id_categoria == 16) { ?>
                            <td class="table-success">Q <?php echo e(number_format($valor_real_cancelado ?? '', 2, '.', ',')); ?></td>
                            <td class="table-info"></td>
                            <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                            <?php }elseif($factura->id_categoria != 16 || $factura->id_categoria != 18 || $factura->id_categoria != 26){ ?>
                            <td class="table-success"></td>
                            <td class="table-info">Q <?php echo e(number_format($valor_real_cancelado ?? '', 2, '.', ',')); ?></td>
                            <td class="table-primary" style="border-right: 1px solid #848484;"></td>
                            <?php }elseif($factura->id_categoria == 18){ ?>
                            <td class="table-success"></td>
                            <td class="table-info"></td>
                            <td class="table-primary" style="border-right: 1px solid #848484;">Q
                                <?php echo e(number_format($valor_real_cancelado ?? '', 2, '.', ',')); ?></td>
                            <?php } ?>
                            
                            <td>
                                <?php
                                if ($factura->regimen == 1 && preg_match('/\d/', $factura->nit)) {
                                    $iva = ($valor_real_cancelado / 1.12) * 0.12;
                                    //echo '<br> tipo de regimen:'.$factura->regimen;
                                    //echo '<br> NIT:'.$factura->nit."<br>";
                                    echo 'Q ' . number_format($iva, 2, '.', ',');
                                } else {
                                    //echo '<br> tipo de regimen:'.$factura->regimen;
                                    //echo '<br> NIT:'.$factura->nit."<br>";
                                    echo 'Q 0.00';
                                }
                                ?>
                            </td>
                            <td>
                                <?php
                                if ($factura->regimen == 1 && preg_match('/\d/', $factura->nit)) {
                                    $iva = $valor_real_cancelado / 1.12;
                                    echo 'Q ' . number_format($iva, 2, '.', ',');
                                } else {
                                    $iva = $valor_real_cancelado;
                                    echo 'Q ' . number_format($iva, 2, '.', ',');
                                }
                                ?>
                            </td>

                            
                            <td class="table-warning">
                                <?php
                                
                                if ($factura->regimen == 1 && preg_match('/\d/', $factura->nit)) {
                                    if ($factura->id_categoria == 16) {
                                        $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                        $comision = ($valor_real_cancelado - $iva) * 0.05;
                                        echo 'Q ' . number_format($comision, 2, '.', ',');
                                    } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                        $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                        $comision = ($valor_real_cancelado - $iva) * 0.02;
                                        echo 'Q ' . number_format($comision, 2, '.', ',');
                                    }
                                } else {
                                    if ($factura->id_categoria == 16) {
                                        $comision = $valor_real_cancelado * 0.05;
                                        echo 'Q ' . number_format($comision, 2, '.', ',');
                                    } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                        $comision = $valor_real_cancelado * 0.02;
                                        echo 'Q ' . number_format($comision, 2, '.', ',');
                                    }
                                }
                                
                                ?>
                            </td>
                            
                            <td style="visibility: hidden" class="table-warning">
                                <?php
                                
                                if ($factura->regimen == 1 && preg_match('/\d/', $factura->nit)) {
                                    if ($factura->id_categoria == 16) {
                                        $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                        $comision = ($valor_real_cancelado - $iva) * 0.05;
                                        echo number_format($comision, 2, '.', ',');
                                        $sumArrayT[] = $comision ?? 0;
                                    } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                        $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                                        $comision = ($valor_real_cancelado - $iva) * 0.02;
                                        echo number_format($comision, 2, '.', ',');
                                        $sumArrayT[] = $comision ?? 0;
                                    }
                                } else {
                                    if ($factura->id_categoria == 16) {
                                        $comision = $valor_real_cancelado * 0.05;
                                        echo number_format($comision, 2, '.', ',');
                                        $sumArrayT[] = $comision ?? 0;
                                    } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                                        $comision = $valor_real_cancelado * 0.02;
                                        echo number_format($comision, 2, '.', ',');
                                        $sumArrayT[] = $comision ?? 0;
                                    }
                                }
                                
                                ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td><b>Total</b></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td><b id="sumaComisionX">Q 
                            <?php
                            
                            if (isset($sumArrayT)) {
                                $suma = 0;
                                foreach ($sumArrayT as $valor) {
                                    $suma += $valor;
                                }
                                echo number_format($suma,2,'.',',') ; // Esto imprimirá 15
                            }
                            
                            ?>
                        </b></td>
                        <td style="visibility: hidden"></td>
                    </tr>
                </tfoot>
            </table>
        </div>
        <div class="col-md-12">
            <h2>Recibos de caja sin factura o producto asignado.</h2>
            <table id="example3" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Fecha de cobro</td>
                        <td>Vendedor</td>
                        <td>Cliente</td>
                        <td>No.Recibo de caja</td>
                        <td>Observación</td>
                        <td>Monto</td>
                    </tr>
                </thead>
                <tbody>

                    <?php $__currentLoopData = $recibosAnticipo; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $factura): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td> <?php echo e($factura->fecha_cobro); ?> </td>
                            <td> <?php echo e($factura->vendedor); ?> </td>
                            <td> <?php echo e($factura->cliente); ?> </td>
                            <td> <?php echo e($factura->no_recibo); ?> </td>
                            <td> <?php echo e($factura->razon); ?> </td>
                            <td>Q <?php echo e(number_format($factura->monto, 2, '.', ',')); ?> </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </tbody>
            </table>
        </div>
    </div>

    <script>
        jQuery.fn.dataTable.Api.register('sum()', function() {
            return this.flatten().reduce(function(a, b) {
                if (typeof a === 'string') {
                    a = a.replace(/[^\d.-]/g, '') * 1;
                }
                if (typeof b === 'string') {
                    b = b.replace(/[^\d.-]/g, '') * 1;
                }

                return a + b;
            }, 0);
        });
        var token = '<?php echo e(csrf_token()); ?>';

        $('.form-check-input').change(function() {
            var total = 0;
            var facturas = new Array();
            $($('.form-check-input').get().reverse()).each(function($seleccion) {

                if ($(this).is(':checked')) {
                    var fel = $(this).attr('data-fel');
                    const buscar_fel = facturas.filter(element => element == fel);
                    if (buscar_fel.length == 0) {
                        facturas.push(fel);
                    }
                    if (facturas.length >= 5) {
                        alert('Solo puedes ingresar 4 facturas por recibo');
                        $(this).prop("checked", false);
                        console.log($(this));
                        return;
                    }
                    var subtotal = parseFloat($(this).attr('data-total'));
                    total = total + subtotal;
                }

            })

            $('#total_cliente').text('Q ' + total.toFixed(2));
        });
        $(".regresar").click(function() {
            var confirmacion = confirm("Desea regresar la factura a pendiente de facturar?");
            if (confirmacion) {
                return true;
            } else {
                return false;
            }
            return false;
        })
        $(".eliminar").click(function() {
            var confirmacion = confirm("Desea eliminar la factura?");
            if (confirmacion) {
                return true;
            } else {
                return false;
            }
            return false;
        })
        $('.nota_').each(function() {
            $(this).click(function() {
                var id_factura = $(this).attr('data-id_factura');
                $('#id_factura').val(id_factura);
            })
        })
        $('#btnTerminarOrdenInventario').click(function() {
            $('#btnTerminarOrdenInventario').attr('disabled', 'disabled');
            var inventario = $('#id_inventario2').val();
            $.ajax({
                type: 'POST',
                url: '<?php echo e(route('contabilidad.nota_debito')); ?>',
                headers: {
                    'X-CSRF-TOKEN': token
                },
                data: {
                    tipo: $('#tipo_debito').val(),
                    cantidad: $('#cantidad2').val(),
                    observaciones: $('#observaciones2').val(),
                    id_factura: $('#id_factura').val(),
                },
                success: function(data) {
                    $('#entregaAlmacen').modal('hide');
                    location.reload(true);
                }
            });
        })
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#example3').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print', 'copy'
                ]
            });
            $('#example2').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [{
                        extend: 'excelHtml5',
                        text: 'Excel',
                        filename: 'calculo_comision', // Nombre personalizado del archivo
                        exportOptions: {
                            columns: ':not(:last-child)', // Excluir la última columna
                            modifier: {
                                selected: null
                            },
                            orthogonal: 'export',
                            footer: true // Incluir el contenido del footer
                        }
                    },
                    'print',
                    'copy'
                ],
                drawCallback: function() {
                    var api = this.api();

                    let dollarUSLocale = Intl.NumberFormat('en-IN');
                    $("#data7").html(
                        api.column(8, {
                            page: 'current'
                        }).data().sum().toFixed(2).replace(/\d(?=(\d{3})+\.)/g, '$&,')
                    );

                }
            });
        })

        $(document).ready(function() {
            // Identificar la columna por su índice (en este caso, la columna 14, índice 13)
            var columnIndex = 13;

            // Obtener todas las celdas de la columna
            var cells = $('#example2 tbody td:nth-child(' + (columnIndex + 1) + ')');

            // Inicializar la variable de suma
            var suma = 0;

            // Iterar sobre las celdas y sumar los valores
            cells.each(function() {
                var valor = parseFloat($(this).text()) || 0;
                suma += valor;
            });

            // Formatear el total con puntos decimales y el formato de quetzales
            var totalFormateado = suma.toLocaleString('es-GT', {
                style: 'currency',
                currency: 'GTQ',
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });

            $('#sumaComision').html(totalFormateado);
            console.log('Suma de la columna 14:', suma);
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('rrhh.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/rrhh/comisiones_por_usuario.blade.php ENDPATH**/ ?>