<?php $__env->startSection('content'); ?>
    
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Inventario Insumos y Accesorios</h2>
                <a type="button" href="<?php echo e(route('inventario.ingreso_insumo')); ?>" class="btn btn-primary">Registrar
                    Ingreso</a>
            </div>
        </div>
        <?php
            $estadosColores = [
                1 => 'success',
                2 => 'warning',
                3 => 'info',
                4 => 'success',
                99 => 'danger',
                999 => 'danger',
            ];
        ?>
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>Correlativo</td>
                        <td>Descripcion</td>
                        <td>Cliente</td>
                        <td>PO</td>
                        <td>Fecha</td>
                        <td>Linea de negocio</td>
                        <td>Estado</td>
                        <td>Observaciones</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $inventarioInsumos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insumo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $cantidadDisponible =
                                $insumo->detalle->sum('cantidad_recibida') - $insumo->detalle->sum('entregado');
                        ?>
                        <tr>
                            <td>
                                INV-<?php echo e($insumo->id); ?>

                            </td>
                            <td>
                                <a href="<?php echo e(route('inventario.detalle_insumo', $insumo->id)); ?>"
                                    class="d-flex justify-content-center align-items-center"><?php echo e($insumo->descripcion); ?>


                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                        viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                        stroke-linecap="round" stroke-linejoin="round"
                                        class="icon icon-tabler icons-tabler-outline icon-tabler-eye ml-2">
                                        <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                        <path d="M10 12a2 2 0 1 0 4 0a2 2 0 0 0 -4 0" />
                                        <path
                                            d="M21 12c-2.4 4 -5.4 6 -9 6c-3.6 0 -6.6 -2 -9 -6c2.4 -4 5.4 -6 9 -6c3.6 0 6.6 2 9 6" />
                                    </svg>
                                </a>
                            </td>
                            <td>
                                <?php echo e($insumo->cliente->nombre); ?>

                            </td>
                            <td>
                                <?php echo e($insumo->po); ?>

                            </td>
                            <td>
                                <?php echo e(\Carbon\Carbon::parse($insumo->fecha_ingreso)->format('d/m/Y')); ?>

                            </td>
                            <td>
                                <?php
                                    $lineaNegocioNombre = match ($insumo->linea_negocio_id) {
                                        1 => 'Maquila',
                                        2 => 'KOTON TEXTILES',
                                        3 => 'SHARKAR',
                                        default => 'Desconocido', // Opcional: manejar caso por defecto
                                    };

                                    echo $lineaNegocioNombre;
                                ?>
                            </td>
                            <td class="alert alert-<?php echo e($estadosColores[$insumo->estado]); ?>">
                                <?php
                                    $estado = match ($insumo->estado) {
                                        1 => 'Ingreso Completo',
                                        2 => 'Ingreso Incompleto',
                                        3 => 'Salida Parcial',
                                        4 => 'Salida Completa',
                                        99 => 'Solicitud de Anulación',
                                        999 => 'Anulado',
                                        default => 'Desconocido', // Opcional: manejar caso por defecto
                                    };

                                    echo $estado;
                                ?>
                            </td>
                            <td>
                                <?php echo e($insumo->observaciones); ?>

                            </td>
                            <td class="d-flex justify-content-center align-items-center">
                                
                                <?php if($insumo->imagen): ?>
                                    <button class="btn" title="Ver Imagen Adjunta">
                                        <a href="/storage/inventarios/<?php echo e($insumo->imagen); ?>" target="_blank">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-camera-plus">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path
                                                    d="M12 20h-7a2 2 0 0 1 -2 -2v-9a2 2 0 0 1 2 -2h1a2 2 0 0 0 2 -2a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1a2 2 0 0 0 2 2h1a2 2 0 0 1 2 2v3.5" />
                                                <path d="M16 19h6" />
                                                <path d="M19 16v6" />
                                                <path d="M9 13a3 3 0 1 0 6 0a3 3 0 0 0 -6 0" />
                                            </svg>
                                        </a>
                                    </button>
                                <?php endif; ?>
                                <?php if($insumo->reclamo && $insumo->estado != 1): ?>
                                    <button class="btn">
                                        <a href="<?php echo e(route('inventario.reclamo_insumo', $insumo->id)); ?>">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-file-invoice">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M14 3v4a1 1 0 0 0 1 1h4" />
                                                <path
                                                    d="M17 21h-10a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h7l5 5v11a2 2 0 0 1 -2 2z" />
                                                <path d="M9 7l1 0" />
                                                <path d="M9 13l6 0" />
                                                <path d="M13 17l2 0" />
                                            </svg>
                                        </a>
                                    </button>
                                <?php endif; ?>
                                <?php if($insumo->estado < 3): ?>
                                    <button class="btn">
                                        <a onclick="solicitudAnulacion()">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-cancel">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M3 12a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" />
                                                <path d="M18.364 5.636l-12.728 12.728" />
                                            </svg>
                                        </a>
                                    </button>
                                <?php endif; ?>
                                <?php if($cantidadDisponible > 0): ?>
                                    <button class="btn">
                                        <a onclick="procesarSalida(<?php echo e($insumo->id); ?>)">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"
                                                class="icon icon-tabler icons-tabler-outline icon-tabler-stack-pop">
                                                <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                                <path d="M7 9.5l-3 1.5l8 4l8 -4l-3 -1.5" />
                                                <path d="M4 15l8 4l8 -4" />
                                                <path d="M12 11v-7" />
                                                <path d="M9 7l3 -3l3 3" />
                                            </svg>
                                        </a>
                                    </button>
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
    </div>

    <?php $__currentLoopData = $inventarioInsumos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $insumo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <!-- Modal PROCESAR SALIDA-->
        <div class="modal fade" id="procesarSalidaModal-<?php echo e($insumo->id); ?>" tabindex="-1"
            aria-labelledby="procesarSalidaModalLabel" aria-hidden="true">
            <div class="modal-dialog" style="max-width:1200px !important;">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="procesarSalidaModalLabel">Procesar Salida</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <form action="<?php echo e(route('inventario.entrega_parcial_insumo')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="modal-body">
                            <div id="step2">
                                <h5>Datos de Ingreso</h5>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <td>Correlativo</td>
                                            <td>Descripcion</td>
                                            <td>Cliente</td>
                                            <td>PO</td>
                                            <td>Fecha</td>
                                            <td>Linea de negocio</td>
                                            <td>Estado</td>
                                            <td>Observaciones</td>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td><?php echo e($insumo->id); ?></td>
                                            <td><?php echo e($insumo->descripcion); ?></td>
                                            <td><?php echo e($insumo->cliente->nombre); ?></td>
                                            <td><?php echo e($insumo->po); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($insumo->fecha_ingreso)->format('d/m/Y')); ?></td>
                                            <td> <?php
                                                $lineaNegocioNombre = match ($insumo->linea_negocio_id) {
                                                    1 => 'Maquila',
                                                    2 => 'KOTON TEXTILES',
                                                    3 => 'SHARKAR',
                                                    default => 'Desconocido', // Opcional: manejar caso por defecto
                                                };

                                                echo $lineaNegocioNombre;
                                            ?></td>
                                            <td> <?php
                                                $estado = match ($insumo->estado) {
                                                    1 => 'Ingreso Completo',
                                                    2 => 'Ingreso Incompleto',
                                                    3 => 'Salida Parcial',
                                                    4 => 'Salida Completa',
                                                    99 => 'Solicitud de Anulación',
                                                    999 => 'Anulado',
                                                    default => 'Desconocido', // Opcional: manejar caso por defecto
                                                };
                                                echo $estado;
                                            ?></td>
                                            <td>
                                                <?php echo e($insumo->observaciones); ?>

                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                                <h5>Detalle de Ingreso</h5>
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th>Cantidad a Entregar</th>
                                            <th scope="col" style='min-width: 300px;'>Descripción</th>
                                            <th scope="col">Unidad de medida</th>
                                            <th scope="col">Cantidad Disponible</th>
                                            <th scope="col">Cantidad Entregada</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $insumo->detalle; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $detalle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $cantidadDisponible = $detalle->cantidad_recibida - $detalle->entregado;
                                            ?>
                                            <tr>
                                                <td>
                                                    <input type="number" class="hidden" name="idsDetalle[]"
                                                        value="<?php echo e($detalle->id); ?>" hidden>
                                                    <input type="number" class="form-control" name="cantidad_entregar[]"
                                                        value="<?php echo e($cantidadDisponible); ?>"
                                                        max="<?php echo e($cantidadDisponible); ?>" min="1">
                                                </td>
                                                <td><?php echo e($detalle->descripcion); ?></td>
                                                <td><?php echo e($detalle->unidadMedida->nombre); ?></td>
                                                <td><?php echo e($cantidadDisponible); ?></td>
                                                <td><?php echo e($detalle->entregado); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                                <button class="btn btn-success" id="processButton">Procesar</button>
                            </div>
                        </div>
                        <input type="number" class="hidden" name="insumo_id" value="<?php echo e($insumo->id); ?>" hidden>
                    </form>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function mostrarSuccess(mensaje) {
            Swal.fire({
                icon: 'success',
                title: mensaje,
                showConfirmButton: false,
                timer: 1500
            });
        }

        function solicitudAnulacion() {
            Swal.fire({
                title: 'Anular Ingreso',
                text: '¿Desea solicitar la autorización para anular este ingreso?',
                icon: 'danger',
                showCancelButton: true,
                confirmButtonText: 'Sí, solicitar',
                cancelButtonText: 'Cancelar'
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire(
                        'Solicitud enviada',
                        'La solicitud para anular el ingreso ha sido enviada.',
                        'success'
                    );
                }
            });
        }

        function procesarSalida(label_id) {
            // Mostrar el modal inicial
            $('#procesarSalidaModal-' + label_id).modal('show');
            let modal = document.getElementById('procesarSalidaModal-' + label_id);
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('inventario.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/inventario/dashboard_insumo.blade.php ENDPATH**/ ?>