<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Orden Produccion</title>
</head>
<style>
    * {
        font-size: 13px;
    }

    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 20px;
    }

    .container {
        width: 800px;
        margin: 0 auto;
        background: #fff;
        padding: 50px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .header table,
    .info table {
        width: 100%;
    }

    .header .logo {
        width: 150px;
        height: 150px;
    }

    .info p {
        margin: 5px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    table,
    th,
    td {
        border: 1px solid #000;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    thead {
        background-color: #f0f0f0;
    }

    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .observaciones {
        font-size: 0.9em;
    }

    .observaciones ul {
        margin: 0;
        padding-left: 20px;
    }

    .observaciones ul li {
        margin-bottom: 5px;
    }

    .text-blue-600 {
        color: #2c5282;
    }

    .bg-blue-300 {
        background-color: #cfe2f3;
    }
</style>

<body>
    <div class="">
        <div class="header">
            <table width="100%" style="border: none; border-collapse: collapse;">
                <tr style="border: none;">
                    <td style="width: 30%; border: none;">
                        <img src="https://koton.webdevgt.com/public/images/logo_concisa.png" alt="Logo"
                            class="logo" style="margin-left: 10px;">
                    </td>
                    <td style="width: 40%; border: none;">
                        <p style="font-size: 34px;text-align:center;">MUESTRA COMERCIAL</p>
                    </td>
                    <td style="width: 30%; border: none;">
                        <p style="font-size: 28px;text-align:center;">OP-<strong
                                style="font-size: 28px;"><?php echo e($op->id); ?></strong></p>
                    </td>
                </tr>
            </table>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">DATOS GENERALES</p>
                <table>
                    <tr>
                        <td style="width: 50%;"><strong>Empresa/Proyecto:</strong>
                            <?php echo e($op->cliente->nombre ?? 'Inventario'); ?></td>
                        <td><strong>Tipo de producto:</strong>
                            <?php echo e($op->micras); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><strong>Asesor Comercial:</strong>
                            <?php if($op->id_cotizacion_producto == 999999): ?>
                                Inventario
                            <?php else: ?>
                                <?php echo e($op->cliente->info_ejecutivo->name ?? ''); ?>

                            <?php endif; ?>
                        </td>
                        <td><strong>Unidades:</strong> <?php echo e($op->producto->medida->nombre); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Producto:</strong> <?php echo e($op->producto->nombre); ?></td>
                        <td><strong>Fecha Entrega:</strong>
                            <?php if($op->fecha_prevista): ?>
                                <?php echo e(date('d/m/Y', strtotime($op->fecha_prevista))); ?>

                            <?php endif; ?>
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Cotización:</strong>
                            <?php if($op->id_cotizacion_producto == 999999): ?>
                                Inventario
                            <?php else: ?>
                                <?php echo e($op->id_cotizacion_producto); ?>

                            <?php endif; ?>
                        </td>
                        <td style="width: 50%;"><strong>Fecha Emision:</strong>
                            <?php echo e(date('d/m/Y', strtotime($op->created_at))); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><strong>Lugar de Entrega:</strong>
                            <?php echo e($op->lugar_entrega); ?>

                        </td>
                        <td><strong>Detalle Etnico:</strong>
                            <?php echo e($op->caracteristicas); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><strong>Punto de Contacto:</strong>
                            <?php echo e($op->cliente->nombre_contacto ?? 'N/A'); ?>

                        </td>
                        <td><strong>Tipo de Tela:</strong>
                            <?php echo e($op->lista_materiales); ?>

                        </td>
                    </tr>
                    <tr>
                        <td><strong>Estado:</strong>
                            <?php if($op->status == 1): ?>
                                Pendiente
                            <?php elseif($op->status == 2): ?>
                                En Proceso
                            <?php elseif($op->status == 3): ?>
                                Finalizado
                            <?php elseif($op->status == 4): ?>
                                Anulado
                            <?php endif; ?>
                        </td>
                        <td><strong>Diseño de la prenda:</strong>
                            <?php echo e($op->diseno_prenda); ?>

                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="observaciones"><strong>Observaciones:</strong> <?php echo e($op->observaciones); ?></p>
                        </td>
                        <td>
                            <p class="observaciones"><strong>Comentarios:</strong> <?php echo e($op->comentario_ing); ?>

                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">DATOS DE LA PRENDA</p>
                <table style="width: 50%;">
                    <tr style="width: 50%;">
                        <td><strong>Cantidad:</strong>
                            <?php echo e($op->cantidad); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Genero:</strong>
                            <?php echo e($op->detalle->genero); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Talla:</strong>
                            <?php echo e($op->detalle->talla); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Personalizacion:</strong>
                            <?php echo e($op->detalle->personalizacion); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Bordados:</strong>
                            <?php echo e($op->detalle->bordados); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Serigrafia:</strong>
                            <?php echo e($op->detalle->serigrafia); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Sublimacion:</strong>
                            <?php echo e($op->detalle->sublimacion); ?></td>
                    </tr>
                    <tr>
                        <td><strong>Color:</strong>
                            <?php echo e($op->detalle->color); ?></td>
                    </tr>
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">ILUSTRACIONES DE LA PRENDA</p>
                <table>
                    <?php $__currentLoopData = collect($op->detalle->ilustraciones_prenda)->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagenesChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php $__currentLoopData = $imagenesChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td style="width: 50%; text-align: center;">
                                    <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents($ilustracionesURL . '/' . $imagen))); ?>"
                                        alt="Ilustracion" style="width: 300px;">
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($imagenesChunk->count() < 2): ?>
                                <td style="width: 50%;"></td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">LOGOS DE LA PRENDA</p>
                <table>
                    <?php $__currentLoopData = collect($op->detalle->logos_prenda)->chunk(2); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagenesChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <?php $__currentLoopData = $imagenesChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imagen): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <td style="width: 50%; text-align: center;">
                                    <img src="data:image/png;base64,<?php echo e(base64_encode(file_get_contents($logosURL . '/' . $imagen))); ?>"
                                        alt="Logos" style="width: 300px;">
                                </td>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php if($imagenesChunk->count() < 2): ?>
                                <td style="width: 50%;"></td>
                            <?php endif; ?>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </table>
            </div>
        </div>
    </div>
</body>

</html>
<?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/ventas/pdf/orden_produccion.blade.php ENDPATH**/ ?>