<?php $__env->startSection('content'); ?>
    

    <div id="contenedor_interno" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <nav aria-label="breadcrumb">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(route('ventas.dashboard_produccion_gerencia')); ?>">Ordenes de
                                Produción</a></li>
                        <li class="breadcrumb-item active" aria-current="page">Aprobación OP <?php echo e($op->id); ?> <a
                                href="<?php echo e(route('contabilidad.ver_cuenta_corriente_info', $op->id_cliente)); ?>"
                                target="_blank" title="Ver cuenta corriente"><i class="fas fa-search-dollar"
                                    style="font-size: 26px;"></i></a></li>
                    </ol>
                </nav>

                <form action="<?php echo e(route('ventas.orden_produccion_ok', $op->id)); ?>" onkeydown="return event.key != 'Enter';"
                    method="POST" enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>

                    <?php if($op->status == 1): ?>
                        <input type="submit" class="botonColor" value="Autorizar Orden Producción" />
                        <a type="button" href="<?php echo e(route('ventas.anular_op_gerencia', $op->id)); ?>"
                            class="btn btn-danger">Anular</a>
                    <?php endif; ?>
            </div>
            <hr>
        </div>
    </div>

    <div id="contenedor_contenido" class="container-fluid px-lg-5">
        <div class="row">
            <div class="col-md-12">
                <h2>Orden de Producción</h2>
            </div>
            <div class="col-md-12">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Es para inventario</label>
                            <div class="col-sm-8">
                                <input class="form-check-input" <?php echo e($op->inventario == 1 ? 'checked' : ''); ?> type="checkbox"
                                    id="gridCheck" name="inventario" value="1">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Cliente</label>
                            <div class="col-sm-8">
                                <p class="inputText"><?php echo e($op->cliente->nombre ?? 'Inventario'); ?></p>
                                <input type="hidden" class="form-control-plaintext" name="id_cliente"
                                    value="<?php echo e($op->id_cliente); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Producto</label>
                            <div class="col-sm-8">
                                <p class="inputText"><?php echo e($op->producto->nombre); ?></p>
                                <input type="hidden" class="form-control-plaintext" name="id_producto"
                                    value="<?php echo e($op->id_producto); ?>">
                            </div>
                        </div>

                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Cantidades para producir</label>
                            <div class="col-sm-8">
                                <input type="text" id="cantidad" class="form-control-plaintext" name="cantidad"
                                    value="<?php echo e($op->cantidad); ?>" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Unidad de medida</label>
                            <div class="col-sm-8">
                                <input type="text" readonly class="form-control-plaintext"
                                    value="<?php echo e($op->producto->medida->nombre); ?>" placeholder="">
                                <input type="hidden" class="form-control-plaintext" name="id_medida"
                                    value="<?php echo e($op->producto->medida->id); ?>">
                            </div>
                        </div>
                        
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Condiciones de entrega</label>
                            <div class="col-sm-8">
                                <textarea class="form-control" name="condiciones_entrega" id="" cols="30" rows="4" required
                                    readonly><?php echo e($op->condiciones_entrega); ?></textarea>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Ejecutivo</label>
                            <div class="col-sm-8">
                                <input type="text" readonly class="form-control-plaintext"
                                    value="<?php echo e($op->cliente->info_ejecutivo->name ?? 'Inventario'); ?>" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Número de cotización</label>
                            <div class="col-sm-8">
                                <a href="<?php echo e(asset('/cotizaciones/CO_' . $op->id_cotizacion_producto)); ?>.pdf"
                                    target='_blank'><i class="fas fa-camera"></i> <?php echo e($op->id_cotizacion_producto); ?></a>
                                <input type="hidden" class="form-control-plaintext"
                                    value="CO<?php echo e($op->id_cotizacion_producto); ?>" placeholder="">
                                <input type="hidden" name="id_cotizacion" value="<?php echo e($op->id_cotizacion); ?>">
                                <input type="hidden" name="id_cotizacion_producto"
                                    value="<?php echo e($op->id_cotizacion_producto); ?>">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Número de orden compra</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="numero_oc"
                                    value="<?php echo e($op->numero_oc); ?>" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Lugar de Entrega</label>
                            <div class="col-sm-8">
                                <input id="lugar_entrega" name="lugar_entrega" type="text"
                                    class="form-control-plaintext" value="" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Fecha de Entrega Planificada</label>
                            <div class="col-sm-8">
                                <input type="date" id="fecha_entrega_planificada" name="fecha_entrega_planificada"
                                    class="form-control-plaintext" value="" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Tipo de Producto</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="tipo_producto" value=""
                                    placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Detalle Etnico</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="detalle_etnico"
                                    value="" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Tipo de Tela</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="tipo_tela"
                                    value="<?php echo e($op->lista_materiales); ?>" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Diseño de la prenda</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="diseno_prenda"
                                    value="<?php echo e($op->diseno_prenda); ?>" placeholder="">
                            </div>
                        </div>
                        <div class="form-group row">
                            <label for="" class="col-sm-4 col-form-label">Notas Importantes</label>
                            <div class="col-sm-8">
                                <input type="text" class="form-control-plaintext" name="notas_importantes"
                                    value="" placeholder="">
                            </div>
                        </div>
                    </div>
                </div>


            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col-md-12">
                <h2>Datos de la prenda</h2>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Genero</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="genero_prenda" value=""
                            placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Talla</label>
                    <div class="col-sm-8">
                        <input id="talla_prenda" name="kgs_millar" type="text" class="form-control-plaintext"
                            value="" placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Personalizacion</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="personalizacion_prenda"
                            value="" placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Bordados</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="bordado_prenda" value=""
                            placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Serigrafia</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="serigrafia_prenda" value=""
                            placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Sublimacion</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="sublimacion_prenda" value=""
                            placeholder="">
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Color</label>
                    <div class="col-sm-8">
                        <input type="text" class="form-control-plaintext" name="color_prenda" value=""
                            placeholder="">
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Ilustracion de la prenda</label>
                    <div class="col-sm-8">
                        <input type="file" class="form-control-file" id="referencia_prenda_file"
                            name="referencia_prenda[]" multiple
                            onchange="previewImages('referencia_prenda_file', 'preview_referencia_prenda')">
                        <div id="preview_referencia_prenda" class="mt-2"></div>
                        <button type="button" class="btn btn-secondary mt-2"
                            onclick="clearImages('referencia_prenda_file', 'preview_referencia_prenda')">Limpiar</button>
                    </div>
                </div>
                <div class="form-group row">
                    <label for="" class="col-sm-4 col-form-label">Logos en la prenda</label>
                    <div class="col-sm-8">
                        <input type="file" class="form-control-file" id="logos_prenda_file" name="logos_prenda[]"
                            multiple onchange="previewImages('logos_prenda_file', 'preview_logos_prenda')">
                        <div id="preview_logos_prenda" class="mt-2"></div>
                        <button type="button" class="btn btn-secondary mt-2"
                            onclick="clearImages('logos_prenda_file', 'preview_logos_prenda')">Limpiar</button>
                    </div>
                </div>
            </div>
        </div>
        </form>
    </div>
    <script>
        // var kgs_millar = document.getElementById('kgs_millar');
        // materialProcesar(kgs_millar)

        function nuevaFila() {
            var row = document.getElementsByClassName("producto"); // find row to copy
            console.log(row);
            var table = document.getElementById("contenedorProductos"); // find table to append to
            var clone = row[0].cloneNode(true); // copy children too
            table.appendChild(clone); // add new row to end of table
        }

        // function materialProcesar(element) {

        //     var cantidad = document.getElementById('cantidad').value;
        //     var kgMillar = element.value;
        //     var total = parseFloat(kgMillar) * parseFloat(cantidad);
        //     document.getElementById('kgProcesar').value = total.toFixed(2);
        //     console.log(total);

        // }

        function previewImages(inputId, previewId) {
            var input = document.getElementById(inputId);
            var preview = document.getElementById(previewId);
            preview.innerHTML = '';

            for (var i = 0; i < input.files.length; i++) {
                var file = input.files[i];
                var reader = new FileReader();

                reader.onload = function(e) {
                    var img = document.createElement('img');
                    img.setAttribute('src', e.target.result);
                    img.setAttribute('class', 'img-thumbnail mr-2 mb-2');
                    img.style.height = '100px'; // Ajusta la altura de la previsualización
                    preview.appendChild(img);
                }

                reader.readAsDataURL(file);
            }
        }

        function clearImages(inputId, previewId) {
            var input = document.getElementById(inputId);
            var preview = document.getElementById(previewId);
            input.value = '';
            preview.innerHTML = '';
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('ventas.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/ventas/orden_produccion_ok.blade.php ENDPATH**/ ?>