<?php $__env->startSection('content'); ?>
<style>
  .form-check{
    display: inline-block;
    top: -15px;
    left: 13px;
  }
</style>
<div class="container date-consult">
    <div class="row">
        <div class="md-col-4 my-4">
            <form action="<?php echo e(route('contabilidad.canceladas')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="d-flex flex-column justify-content-center">
                    <div class="d-flex justify-content-center align-items-center">
                        <p class="font-weight-bolder text-uppercase">Fecha Inicio: <input class="date-picker"
                                type="date" name="fechaInicio" id="datepicker"></p>
                        <p class="font-weight-bolder text-uppercase">Fecha Final: <input class="date-picker"
                                type="date" name="fechaFin" id="datepicker2"></p>
                    </div>
                    <div class="d-flex">
                        <div class="d-flex justify-content-center align-items-center">
                            <div>
                                <button type="submit" class="btn btn-dark mx-auto">Consultar</button>
                            </div>
                            <?php if(isset($fechaInicio) && isset($fechaFin)): ?>
                            <div class="d-flex">
                              <p class="blockquote mx-2">Fecha consultada</p>
                              <p class="blockquote"> del  <strong><?php echo e($fechaInicio); ?>  </strong></p>
                              <p class="blockquote">- al -<strong><?php echo e($fechaFin); ?> </strong></p>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
  </div>
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>facturas Canceladas</h2>

      
      <a type="button" onclick="cancelado()" class="botonColorNaranja">Cancelado</a>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <table id="example14" class="display" style="width:100%">
      <thead>
        <tr>
          <td>Tipo</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Cantidad</td>
          <td>Producto</td>
          <td>Precio</td>
          <td>Total</td>
          <td>Documento NC/ND</td>
          <td>Recibo</td>
          <td>SAT</td>
        </tr>
      </thead>
      <tbody>      
        <?php $__currentLoopData = $salidasAlmacen; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $op): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <tr>
            <td><?php echo e($op->id); ?></td>
            <td><?php echo e(date("d/m/Y h:i:s", strtotime($op->created_at))); ?></td>
            <td><?php echo e($op->cliente->nombre??''); ?></td>
            <td><?php echo e($op->cantidad); ?></td>
            <td><?php echo e($op->producto->nombre??''); ?></td>
            <td><?php echo e(number_format($op->precio,2,'.',',')); ?></td>
            <td><?php echo e(number_format($op->total,2,'.',',')); ?></td>
            <?php if($op->nota): ?>
            <td><?php echo e(number_format($op->nota->cantidad,2,'.',',')); ?> <?php echo e($op->nota->estatus==1?'ND':'NC'); ?></td>
            <?php else: ?>
            <td></td>
            <?php endif; ?>
            <td><a href="<?php echo e(route('contabilidad.ver_recibo_caja',$op->id_recibo_caja_factura)); ?>" title="Ver recibo" target="_blank"><i class="fas fa-camera"></i> <?php echo e($op->recibo_caja->recibo_caja_numero??''); ?></a></td>
            <td>
              <?php if($op->archivo_factura): ?>
              <a href="<?php echo e(asset("/facturas/".$op->archivo_factura)); ?>" target='_blank' title="Ver factura"><i class="fas fa-camera"></i> <?php echo e($op->no_sat); ?></a>
              <?php else: ?>
              <?php echo e($op->no_sat); ?>

              <?php endif; ?>
            </td>
          </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </tbody>
    </table>
  </div>
</div>
<script>
  var token = '<?php echo e(csrf_token()); ?>';

 function cancelado(){
   document.querySelectorAll('.form-check-input').forEach(element => {
     var padre=element.parentElement.parentElement.parentElement;
     var id_factura=$(element).attr('data-id');
     if(element.checked ){
       jQuery( document ).ready(function() {
         $.ajax({
           type:'POST',
           url:'<?php echo e(route('contabilidad.cancelar_factura')); ?>',
           headers: {'X-CSRF-TOKEN': token},
           data:{
            id_factura:id_factura,
           },
           success:function(data){
             if(data){
               padre.remove();
               Swal.fire({
                   position: 'top-end',
                   title: "La factura cancelada",
                   showConfirmButton: false,
                   timer: 1500
               });
             }
           }
         });
       });
     }
   });
 }
</script>
<script>
$(document).ready(function() {
    var total = 0;

    $('#example14').dataTable( {
    "paging": false,
    "order":[[ 0, "desc" ]],
              dom: 'Bfrtip',
              buttons: [
                  'excel', 'print'
              ],
      drawCallback: function () {

        
      }
  });
    
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('contabilidad.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/devpwg5/laravelrp.com/resources/views/contabilidad/dashboard_facturas_canceladas.blade.php ENDPATH**/ ?>