<?php $__env->startSection('content'); ?>
    
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Produccion por tallas</h2>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#registroModal">
                    Registrar Produccion
                </button>
            </div>
        </div>
        <div class="container mt-4">
            <form method="GET" action="<?php echo e(route('fabricacion.filtrar_produccion_talla')); ?>" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_inicio">Fecha Inicio</label>
                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_fin">Fecha Fin</label>
                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="linea_id_filtro">Línea</label>
                            <select class="form-control" id="linea_id_filtro" name="linea_id">
                                <option value="">Todos</option>
                                <?php $__currentLoopData = $lineas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($linea->id); ?>"><?php echo e($linea->nombre); ?> - <?php echo e($linea->encargado->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="estado_filtro">Estado</label>
                            <select class="form-control" id="estado_filtro" name="estado">
                                <option value="">Todos</option>
                                <option value="1" selected>Activo</option>
                                <option value="2">Anulado</option>
                            </select>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </form>
        </div>
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>#</td>
                        <td>Fecha</td>
                        <td>Linea</td>
                        <td>Produccion</td>
                        <td>Talla</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $producciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $produccion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $colorEstado = match ($produccion->estado) {
                                0 => 'danger',
                                1 => '',
                                2 => 'danger',
                                default => 'warning',
                            };
                        ?>
                        <tr>
                            <td class="alert alert-<?php echo e($colorEstado); ?>">
                                <?php echo e($produccion->id); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->created_at->format('d/m/Y')); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->linea?->nombre); ?> - <?php echo e($produccion->linea?->encargado?->name); ?>

                            </td>

                            <td>
                                <?php echo e($produccion->cantidad); ?>

                            </td>
                            <td>
                                <?php echo e($produccion->talla?->nombre); ?>

                            </td>
                            <td class="d-flex justify-content-center align-items-center">
                                <?php if($produccion->estado == 1): ?>
                                    <button class="btn btn-danger" onclick="anular('<?php echo e($produccion->id); ?>')">
                                        ANULAR
                                    </button>
                                    
                                <?php else: ?>
                                    ANULADO
                                <?php endif; ?>
                            </td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>
        <?php
            $totalesPorTalla = $producciones
                ->where('estado', 1)
                ->groupBy('talla_id')
                ->map(function ($items) {
                    return $items->sum('cantidad');
                });
        ?>

        <div class="container mt-4">
            <h3>Producción por Talla</h3>
            <table class="table">
                <thead>
                    <tr>
                        <th>Talla</th>
                        <th>Producción</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $totalesPorTalla; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $talla_id => $total): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $tallaNombre = $tallas->firstWhere('id', $talla_id)->nombre ?? 'Desconocida';
                        ?>
                        <tr>
                            <td><?php echo e($tallaNombre); ?></td>
                            <td><?php echo e($total); ?></td>
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
                <tfoot>
                    <tr>
                        <td><strong>Total</strong></td>
                        <td><strong><?php echo e($totalesPorTalla->sum()); ?></strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <div class="modal fade" id="registroModal" tabindex="-1" role="dialog" aria-labelledby="registroModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width:800px !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="registroModalLabel">Agregar/Editar Registro</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="registroForm" method="POST" action="<?php echo e(route('fabricacion.guardar_produccion_talla')); ?>">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="produccion_id" id="produccion_id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="linea_id">Línea</label>
                                    <select class="form-control" id="linea_id" name="linea_id" required>
                                        <option value="">Seleccione una línea</option>
                                        <?php $__currentLoopData = $lineas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $linea): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($linea->id); ?>"><?php echo e($linea->nombre); ?> -
                                                <?php echo e($linea->encargado?->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="cantidad_talla">Cantidad y Talla</label>
                                    <div id="cantidadTallaContainer">
                                        <!-- Aquí se agregarán dinámicamente los inputs -->
                                    </div>
                                    <button type="button" class="btn btn-secondary" id="addCantidadTalla">Agregar
                                        Cantidad</button>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function editarRegistro(id, descripcion, cantidad, estado, tipo, talla_id, linea_id, encargado_id) {
            document.getElementById('produccion_id').value = id;
            document.getElementById('descripcion').value = descripcion;
            document.getElementById('cantidad').value = cantidad;
            document.getElementById('talla_id').value = talla_id;
            document.getElementById('linea_id').value = linea_id;
            document.getElementById('encargado_id').value = encargado_id;

            $('#registroModal').modal('show');
        }

        function limpiarFormulario() {
            document.getElementById('registroForm').action =
                '<?php echo e(route('fabricacion.guardar_produccion_talla')); ?>'; // Cambia la acción del formulario para crear
            document.getElementById('registroForm').reset();
            $('#registroModal').modal('show');
        }

        function anular(id) {
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, anular'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`/fabricacion/produccion_talla/${id}/anulacion`, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire(
                                    'Anulado!',
                                    'El registro ha sido anulado.',
                                    'success'
                                ).then(() => {
                                    location.reload(); // Recargar la página después de la confirmación
                                });
                            } else {
                                Swal.fire(
                                    'Error!',
                                    data.message || 'Hubo un problema al anular el registro.',
                                    'error'
                                );
                            }
                        })
                        .catch((error) => {
                            Swal.fire(
                                'Error!',
                                'Hubo un problema al anular el registro.',
                                'error'
                            );
                        });
                }
            });
        }
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const addBtn = document.getElementById('addCantidadTalla');
            const container = document.getElementById('cantidadTallaContainer');

            addBtn.addEventListener('click', function() {
                const div = document.createElement('div');
                div.classList.add('row', 'mb-2');

                div.innerHTML = `
                    <div class="col-md-5">
                        <input type="number" class="form-control" name="cantidades[]" placeholder="Cantidad" required>
                    </div>
                    <div class="col-md-5">
                        <select class="form-control" name="tallas[]" required>
                            <option value="">Seleccione una talla</option>
                            <?php $__currentLoopData = $tallas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $talla): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($talla->id); ?>"><?php echo e($talla->nombre); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger removeCantidadTalla">&times;</button>
                    </div>
                `;

                container.appendChild(div);

                div.querySelector('.removeCantidadTalla').addEventListener('click', function() {
                    div.remove();
                });
            });
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('fabricacion.menu', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/n344795/koton.webdevgt.com/resources/views/fabricacion/dashboard_produccion_talla.blade.php ENDPATH**/ ?>