<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Orden Produccion</title>
</head>
<style>
    * {
        font-size: 13px;
    }

    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 20px;
    }

    .container {
        width: 800px;
        margin: 0 auto;
        background: #fff;
        padding: 50px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .header table,
    .info table {
        width: 100%;
    }

    .header .logo {
        width: 150px;
        height: 150px;
    }

    .info p {
        margin: 5px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    table,
    th,
    td {
        border: 1px solid #000;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    thead {
        background-color: #f0f0f0;
    }

    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .observaciones {
        font-size: 0.9em;
    }

    .observaciones ul {
        margin: 0;
        padding-left: 20px;
    }

    .observaciones ul li {
        margin-bottom: 5px;
    }

    .text-blue-600 {
        color: #2c5282;
    }

    .bg-blue-300 {
        background-color: #cfe2f3;
    }
</style>

<body>
    <div class="">
        <div class="header">
            <table width="100%" style="border: none; border-collapse: collapse;">
                <tr style="border: none;">
                    <td style="width: 30%; border: none;">
                        <img src="https://koton.webdevgt.com/public/images/logo_concisa.png" alt="Logo"
                            class="logo" style="margin-left: 10px;">
                    </td>
                    <td style="width: 40%; border: none;">
                        <p style="font-size: 34px;text-align:center;">MUESTRA COMERCIAL</p>
                    </td>
                    <td style="width: 30%; border: none;">
                        <p style="font-size: 28px;text-align:center;">OP-<strong
                                style="font-size: 28px;">{{ $op->id }}</strong></p>
                    </td>
                </tr>
            </table>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">DATOS GENERALES</p>
                <table>
                    <tr>
                        <td style="width: 50%;"><strong>Empresa/Proyecto:</strong>
                            {{ $op->cliente->nombre ?? 'Inventario' }}</td>
                        <td><strong>Tipo de producto:</strong>
                            {{ $op->micras }}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Asesor Comercial:</strong>
                            @if ($op->id_cotizacion_producto == 999999)
                                Inventario
                            @else
                                {{ $op->cliente->info_ejecutivo->name ?? '' }}
                            @endif
                        </td>
                        <td><strong>Unidades:</strong> {{ $op->producto->medida->nombre }}</td>
                    </tr>
                    <tr>
                        <td><strong>Producto:</strong> {{ $op->producto->nombre }}</td>
                        <td><strong>Fecha Entrega:</strong>
                            @if ($op->fecha_prevista)
                                {{ date('d/m/Y', strtotime($op->fecha_prevista)) }}
                            @endif
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Cotización:</strong>
                            @if ($op->id_cotizacion_producto == 999999)
                                Inventario
                            @else
                                {{ $op->id_cotizacion_producto }}
                            @endif
                        </td>
                        <td style="width: 50%;"><strong>Fecha Emision:</strong>
                            {{ date('d/m/Y', strtotime($op->created_at)) }}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Lugar de Entrega:</strong>
                            {{ $op->lugar_entrega }}
                        </td>
                        <td><strong>Detalle Etnico:</strong>
                            {{ $op->caracteristicas }}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Punto de Contacto:</strong>
                            {{ $op->cliente->nombre_contacto ?? 'N/A' }}
                        </td>
                        <td><strong>Tipo de Tela:</strong>
                            {{ $op->lista_materiales }}
                        </td>
                    </tr>
                    <tr>
                        <td><strong>Estado:</strong>
                            @if ($op->status == 1)
                                Pendiente
                            @elseif ($op->status == 2)
                                En Proceso
                            @elseif ($op->status == 3)
                                Finalizado
                            @elseif ($op->status == 4)
                                Anulado
                            @endif
                        </td>
                        <td><strong>Diseño de la prenda:</strong>
                            {{ $op->diseno_prenda }}
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <p class="observaciones"><strong>Observaciones:</strong> {{ $op->observaciones }}</p>
                        </td>
                        <td>
                            <p class="observaciones"><strong>Comentarios:</strong> {{ $op->comentario_ing }}
                            </p>
                        </td>
                    </tr>
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">DATOS DE LA PRENDA</p>
                <table style="width: 50%;">
                    <tr style="width: 50%;">
                        <td><strong>Cantidad:</strong>
                            {{ $op->cantidad }}</td>
                    </tr>
                    <tr>
                        <td><strong>Genero:</strong>
                            {{ $op->detalle->genero }}</td>
                    </tr>
                    <tr>
                        <td><strong>Talla:</strong>
                            {{ $op->detalle->talla }}</td>
                    </tr>
                    <tr>
                        <td><strong>Personalizacion:</strong>
                            {{ $op->detalle->personalizacion }}</td>
                    </tr>
                    <tr>
                        <td><strong>Bordados:</strong>
                            {{ $op->detalle->bordados }}</td>
                    </tr>
                    <tr>
                        <td><strong>Serigrafia:</strong>
                            {{ $op->detalle->serigrafia }}</td>
                    </tr>
                    <tr>
                        <td><strong>Sublimacion:</strong>
                            {{ $op->detalle->sublimacion }}</td>
                    </tr>
                    <tr>
                        <td><strong>Color:</strong>
                            {{ $op->detalle->color }}</td>
                    </tr>
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">ILUSTRACIONES DE LA PRENDA</p>
                <table>
                    @foreach (collect($op->detalle->ilustraciones_prenda)->chunk(2) as $imagenesChunk)
                        <tr>
                            @foreach ($imagenesChunk as $imagen)
                                <td style="width: 50%; text-align: center;">
                                    <img src="data:image/png;base64,{{ base64_encode(file_get_contents($ilustracionesURL . '/' . $imagen)) }}"
                                        alt="Ilustracion" style="width: 300px;">
                                </td>
                            @endforeach
                            @if ($imagenesChunk->count() < 2)
                                <td style="width: 50%;"></td>
                            @endif
                        </tr>
                    @endforeach
                </table>
            </div>
            <div style="margin-top: 30px;">
                <p style="font-size: 24px;font-weight:600;">LOGOS DE LA PRENDA</p>
                <table>
                    @foreach (collect($op->detalle->logos_prenda)->chunk(2) as $imagenesChunk)
                        <tr>
                            @foreach ($imagenesChunk as $imagen)
                                <td style="width: 50%; text-align: center;">
                                    <img src="data:image/png;base64,{{ base64_encode(file_get_contents($logosURL . '/' . $imagen)) }}"
                                        alt="Logos" style="width: 300px;">
                                </td>
                            @endforeach
                            @if ($imagenesChunk->count() < 2)
                                <td style="width: 50%;"></td>
                            @endif
                        </tr>
                    @endforeach
                </table>
            </div>
        </div>
    </div>
</body>

</html>
