@extends('layouts.app')

@section('content')
    @extends('ventas.menu')
    <style>
        .form-group.form-check {
            display: inline-block;
            top: -11px;
        }

        .fa-file-pdf {
            padding-left: 6px;
        }
    </style>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Orden Producción</h2>
                <a type="button" onclick="archivar()" class="botonColorNaranja">Anular</a>
            </div>
        </div>
        <div class="col-md-12">
            <br>
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>OP</td>
                        <td>Fecha</td>
                        <td>Cliente</td>
                        <td>Cantidad</td>
                        <td>Unidades</td>
                        <td>Producto</td>
                        <td>Ejecutivo</td>
                        <td>Fecha Entrega Prevista</td>
                        <td>Cotización</td>
                        <td>Muestra Comercial</td>
                        <td>Estado</td>
                        <td>Acción</td>
                    </tr>
                </thead>
                <tbody>
                    <?php $idCotizacion = 0; ?>

                    @foreach ($ops as $op)
                        <tr data-id="{{ $op->id }}"
                            class="{{ $op->status == 3 ? 'table-success' : '' }} {{ $op->status == 4 ? 'table-success' : '' }}">
                            <td>{{ $op->id }}</td>
                            <td>{{ date('d/m/Y h:i:s', strtotime($op->created_at)) }}</td>
                            <td>
                                {{ $op->cliente->nombre ?? 'Inventario' }}</td>
                            <td>{{ $op->cantidad }}</td>
                            <td>{{ $op->producto->medida->nombre }}</td>
                            <td>
                                {{ $op->producto->nombre }}
                            </td>
                            <td>
                                @if ($op->id_cotizacion_producto == 999999)
                                    Inventario
                                @else
                                    {{ $op->cliente->info_ejecutivo->name ?? '' }}
                                @endif

                            </td>
                            <td>
                                {{-- @if ($op->fecha_entrega)
                                    {{ date('d/m/Y', strtotime($op->updated_at)) }}
                                @endif --}}
                                {{ date('d/m/Y', strtotime($op->fecha_prevista))}}
                            </td>
                            <td>
                                @if ($op->id_cotizacion_producto != 999999)
                                    <a href="{{ asset('/cotizaciones/CO_' . $op->id_cotizacion_producto . '.pdf') }}"
                                        target='_blank'>{{ $op->id_cotizacion_producto }}<i
                                            class="far fa-file-pdf"></i></a>
                                @endif
                            </td>
                            <td>
                                <a href="{{ route('ventas.orden_produccion_pdf', $op->id) }}">Ver<i
                                    class="far fa-file-pdf"></i></a>
                            </td>
                            <td class='status'>
                                @if ($op->status == 1)
                                    Pendiente autorizar
                                @endif
                                @if ($op->status == 2)
                                    Autorizada
                                @endif
                                @if ($op->status == 3)
                                    Proceso
                                @endif
                                @if ($op->status == 4)
                                    Terminada
                                @endif
                                @if ($op->status == 5)
                                    Facturación
                                @endif
                                @if ($op->status == 99)
                                    Anulado
                                @endif
                            </td>

                            <td>
                                @if ($op->status == 1)
                                    <div class="form-group form-check"><input type="checkbox" class="form-check-input"
                                            id="exampleCheck1"></div>
                                @endif
                                @if ($op->status == 2)
                                    <div class="form-group form-check"><input type="checkbox" class="form-check-input"
                                            id="exampleCheck1"></div>
                                    <a type="button" href="{{ route('ventas.orden_produccion_ver', $op->id) }}"
                                        class="btn btn-outline-primary">Ver</a>
                                @endif
                                @if ($op->status == 3)
                                    <a type="button" href="{{ route('ventas.orden_produccion_ver', $op->id) }}"
                                        class="btn btn-outline-primary">Ver</a>
                                @endif
                                @if ($op->status == 4)
                                    <a type="button" href="{{ route('ventas.orden_produccion_ver', $op->id) }}"
                                        class="btn btn-outline-primary">Ver</a>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
    <script>
        function archivar() {
            document.querySelectorAll('.form-check-input').forEach(element => {
                var padre = element.parentElement.parentElement.parentElement;
                var idOP = padre.getAttribute('data-id');
                if (element.checked) {
                    jQuery(document).ready(function() {
                        var token = '{{ csrf_token() }}';
                        $.ajax({
                            type: 'POST',
                            url: '{{ route('ventas.anular_op') }}',
                            headers: {
                                'X-CSRF-TOKEN': token
                            },
                            data: {
                                idOP: idOP,
                            },
                            success: function(data) {
                                if (data) {
                                    $(padre).find('.status').text('Anulada');
                                    Swal.fire({
                                        position: 'top-end',
                                        title: "Orden Producción anulada",
                                        showConfirmButton: false,
                                        timer: 1500
                                    });
                                }
                            }
                        });
                    });
                }
            });
        }
    </script>
@endsection
