@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor-dashboard" class="container-fluid ">
    <div class="row ">
      <div class="col-md-12">
        <h2>Clientes</h2>
        <a type="button" href="{{route('ventas.cliente')}}" class="botonColor">Nuevo</a>
      </div>
    </div>
</div>
<br>
<table id="example" class="display" style="width:100%">
<thead>
  <tr>
    <td>ID</td>
    <td>NOMBRE</td>
    <td>NIT</td>
    <td>CORREO</td>
    <td>REFERENCIA</td>
    <td>CREDITO</td>
    <td>EJECUTIVO</td>
    <td>ACCIÓN</td>
  </tr>
</thead>
<tbody>
@foreach ($clientes as $cliente)
  <tr>
    <td>{{$cliente['id']}}</td>
    <td><a href="{{ route('ventas.editar_cliente',$cliente['id']) }}" target="_blank">{{$cliente['nombre']}}</a></td>
    <td>{{$cliente['nit']}}</td>
    <td>{{$cliente['correo_electronico']}}</td>
    <td>{{$cliente['referencia']}}</td>
    <td>
      @if($cliente['condiciones_pago']==1)
        Contado
      @endif
      @if($cliente['condiciones_pago']==2)
        15 días
      @endif
      @if($cliente['condiciones_pago']==3)
        30 días
      @endif
      @if($cliente['condiciones_pago']==4)
        45 días
      @endif
      @if($cliente['condiciones_pago']==5)
        60 días
      @endif
    </td>
    <td>{{$cliente->info_ejecutivo['name']??''}}</td>
    <td><a href="{{ route('ventas.editar_cliente',$cliente['id']) }}" target="_blank"><i class="fas far fa-edit"></i></a></td>
  </tr>
@endforeach
</tbody>
</table>
@endsection
