@extends('layouts.app')

@section('content')
@extends('ventas.menu')

<div id="contenedor-dashboard" class="container-fluid">
    <div class="row ">
      <div class="col-md-12">
        <h2>Cotizaciones:</h2>
        <a type="button" href="{{route('ventas.cotizacion')}}" class="botonColor">Nueva</a>
        <button type="button" id="btnAprobacion" onclick="produccion()" class="btn botonColorMorado">Aprobación cliente</button>
        <button id="btnArchivar" type="button" onclick="archivar()" class="botonColorNaranja">Archivar</button>
        <button id="btnAnular" type="button" onclick="anular()" class="btn btn-warning">Anular</button>
      </div>
    </div>
    <div class="col-md-12">
      <br>
      <br>
      <table id="example_edit" class="display table_cotizaciones" style="width:100%"> 
          <thead>
            <tr>
              <td>CO</td>
              <td>Fecha de cotización</td>
              <td>Cliente</td>
              <td>Cantidad</td>
              <td>Producto</td>
              <td>Usuario</td>
              <td>Total</td>
              <td>Validez</td>
              <td>Status</td>
              <td>Acción</td>
            </tr>
          </thead>
          <tbody>
            <?php $idCotizacion=0;?>
            @foreach ($cotizaciones as $cotizacion)
              <?php
              //dd($cotizacion);
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr data-id="{{$cotizacion->idCotizacionProducto}}" class="bg-warning idOkdangerA">
                <td>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->cantidad}} {{$cotizacion->nombreMedida}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>
                  @if($cotizacion->id_usuario==1)
                    Admin
                  @endif
                  @if($cotizacion->id_usuario==4)
                    Noemi De Leon
                  @endif
                  @if($cotizacion->id_usuario==5)
                    Esmeralda Canel
                  @endif
                  @if($cotizacion->id_usuario==6)
                    Amilcar Mazariegos
                  @endif
                  @if($cotizacion->id_usuario==7)
                  Ingeniero Rodolfo Castillo
                  @endif
                  @if($cotizacion->id_usuario==8)
                  Ana Lopez
                  @endif
                  
                </td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>En aprobación</td>
                <td>
                <div class="form-group form-check"><input type="checkbox" data-id="{{$cotizacion->idCotizacionProducto}}" class="form-check-input" id="exampleCheck1"></div>
                </td>
              </tr>
            @endforeach
            <?php $idCotizacion=0;?>
            @foreach ($cotizaciones2 as $cotizacion)
              <?php
              //dd($cotizacion);
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="bg-success idOkdangerA" data-id="{{$cotizacion->idCotizacionProducto}}">
                <td class='idOksuccess'>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->cantidad}} {{$cotizacion->nombreMedida}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>
                  @if($cotizacion->id_usuario==1)
                    Admin
                  @endif
                  @if($cotizacion->id_usuario==4)
                    Noemi De Leon
                  @endif
                  @if($cotizacion->id_usuario==5)
                    Esmeralda Canel
                  @endif
                  @if($cotizacion->id_usuario==6)
                    Amilcar Mazariegos
                  @endif
                  @if($cotizacion->id_usuario==7)
                  Ingeniero Rodolfo Castillo
                  @endif
                  @if($cotizacion->id_usuario==8)
                  Ana Lopez
                  @endif
                  
                </td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>Cliente: {{$cotizacion->comentario_ing??''}}</td>
                <td>
                  <a href="{{route('ventas.cotizacion_enviar',$cotizacion->idCotizacionProducto)}}" title="Generar Cotización"><i class="editarC fas fa-mail-bulk"></i></a>
                </td>
              </tr>
            @endforeach
            <?php $idCotizacion=0;?>
            @foreach ($cotizaciones3 as $cotizacion)
              <?php
              //dd($cotizacion);
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="bg-danger idOkdangerA" data-id="{{$cotizacion->idCotizacionProducto}}">
                <td class='idOkdanger'>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->cantidad}} {{$cotizacion->nombreMedida}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>
                  @if($cotizacion->id_usuario==1)
                    Admin
                  @endif
                  @if($cotizacion->id_usuario==4)
                    Noemi De Leon
                  @endif
                  @if($cotizacion->id_usuario==5)
                    Esmeralda Canel
                  @endif
                  @if($cotizacion->id_usuario==6)
                    Amilcar Mazariegos
                  @endif
                  @if($cotizacion->id_usuario==7)
                  Ingeniero Rodolfo Castillo
                  @endif
                  @if($cotizacion->id_usuario==8)
                  Ana Lopez
                  @endif
                  
                </td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>Cambios: {{$cotizacion->comentario_ing??''}}</td>
                <td>
                  <div class="form-group form-check"><input type="checkbox" class="form-check-input" data-id="{{$cotizacion->idCotizacionProducto}}" id="exampleCheck1"></div>
                  <a href="{{route('ventas.editar_cotizacion',$cotizacion->idCotizacionProducto)}}"><i class="editarC far fa-edit"></i></a>
                </td>
              </tr>
            @endforeach
            <?php $idCotizacion=0;?>
            @foreach ($cotizaciones4 as $cotizacion)
              <?php
              //dd($cotizacion);
                if($idCotizacion!=$cotizacion->id){
                  $idCotizacion=$cotizacion->id;
                  $contador=0;
                }
                $contador++;
              ?>
              <tr class="bg-success" data-id="{{$cotizacion->idCotizacionProducto}}">
                <td class='idOkprimary'>{{$cotizacion->idCotizacionProducto}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->created_at))}}</td>
                <td>{{$cotizacion->nombreCliente}}</td>
                <td>{{$cotizacion->cantidad}} {{$cotizacion->nombreMedida}}</td>
                <td>{{$cotizacion->nombreProducto}}</td>
                <td>
                  @if($cotizacion->id_usuario==1)
                    Admin
                  @endif
                  @if($cotizacion->id_usuario==4)
                    Noemi De Leon
                  @endif
                  @if($cotizacion->id_usuario==5)
                    Esmeralda Canel
                  @endif
                  @if($cotizacion->id_usuario==6)
                    Amilcar Mazariegos
                  @endif
                  @if($cotizacion->id_usuario==7)
                  Ingeniero Rodolfo Castillo
                  @endif
                  @if($cotizacion->id_usuario==8)
                  Ana Lopez
                  @endif
                  
                </td>
                <td>Q {{number_format(($cotizacion->cantidad*$cotizacion->precio), 2, '.', '')}}</td>
                <td>{{date("d/m/Y h:i:s", strtotime($cotizacion->validez_cotizacion))}}</td>
                <td>Cliente: {{$cotizacion->comentario_ing??''}}</td>
                <td>
                  <div class="form-group form-check"><input type="checkbox" data-id="{{$cotizacion->idCotizacionProducto}}" class="form-check-input" id="exampleCheck1"></div>
                  <a  href="{{ asset('/cotizaciones/CO_'.$cotizacion->idCotizacionProducto.'.pdf') }}" title="Ver cotización" target='_blank'><i class="editarC far fa-file-pdf"></i></a>
                </td>
              </tr>
            @endforeach
          </tbody>
      </table>
    </div>
</div>
<script>
  function archivar(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        $('#btnArchivar').prop('disabled', true);
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.archivar_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                if(data==2){
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada facturación",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }else{
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada aprobación de producción",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }
                $('#btnArchivar').prop('disabled', false);
              }
            }
          });
        });
      }
    });
  }
  function anular(){
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      var idCotizacionProducto=padre.getAttribute('data-id');
      if(element.checked ){
        $('#btnAnular').prop('disabled', true);
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.anular_cotizacion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                if(data==2){
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada facturación",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }else{
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización fue anulada",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }
                $('#btnAnular').prop('disabled', false);
              }
            }
          });
        });
      }
    });
  }
  function produccion(){
    $('#btnAprobacion').prop('disabled', true);
    document.querySelectorAll('.form-check-input').forEach(element => {
      var padre=element.parentElement.parentElement.parentElement;
      if(element.checked ){
        var idCotizacionProducto=$(element).attr('data-id');
        jQuery( document ).ready(function() {
          var token = '{{ csrf_token() }}';
          $.ajax({
            type:'POST',
            url:'{{ route('ventas.cotizacion_produccion') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idCotizacionProducto:idCotizacionProducto,
            },
            success:function(data){
              if(data){
                padre.remove();
                if(data==2){
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada facturación",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }else{
                  padre.remove();
                  Swal.fire({
                      position: 'top-end',
                      title: "Cotización enviada aprobación de producción",
                      showConfirmButton: false,
                      timer: 1500
                  });
                }
                $('#btnAprobacion').prop('disabled', false);
              }
            }
          });
        });
      }
    });
  }
</script>
@endsection
