<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <title>Prueba PDF</title>
</head>
<style>
    * {
        font-size: 15px;
    }

    body {
        font-family: Arial, sans-serif;
        margin: 0;
        padding: 20px;
    }

    .container {
        width: 800px;
        margin: 0 auto;
        background: #fff;
        padding: 50px;
        box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
    }

    .header table,
    .info table {
        width: 100%;
    }

    .header .logo {
        width: 150px;
        height: 150px;
    }

    .info p {
        margin: 5px 0;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-bottom: 20px;
    }

    table,
    th,
    td {
        border: 1px solid #000;
    }

    th,
    td {
        padding: 8px;
        text-align: left;
    }

    thead {
        background-color: #f0f0f0;
    }

    tbody tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .observaciones {
        font-size: 0.9em;
    }

    .observaciones ul {
        margin: 0;
        padding-left: 20px;
    }

    .observaciones ul li {
        margin-bottom: 5px;
    }

    .text-blue-600 {
        color: #2c5282;
    }

    .bg-blue-300 {
        background-color: #cfe2f3;
    }
</style>

<body>
    <div class="">
        <div class="header">
            <table width="100%" style="border: none; border-collapse: collapse;">
                <tr style="border: none;">
                    <td style="width: 30%;border: none;">
                        <img src="https://koton.webdevgt.com/public/images/logo_concisa.png" alt="Logo"
                            class="logo">
                    </td>
                    <td style="width: 60%; line-height: .4;border: none;margin-left:10px;">
                        <p>KOTON TEXTILS</p>
                        <p>7a. Av. 14-44 zona 9, Edificio La Galería, 3er Nivel</p>
                        <p>Oficina 302, Guatemala</p>
                        <p>Tel. +502 2493-3351, 3094-6441 info@sharkarstore.com</p>
                        <p>NIT 10965473-0</p>
                    </td>
                </tr>
            </table>
        </div>

        <div class="info">
            <table width="100%" style="border: none; border-collapse: collapse;">
                @if ($insumo->cliente)
                    <tr style="border: none;">
                        <td style="width: 20%; font-weight: bold;border: none;">EMPRESA:</td>
                        <td style="width: 80%; border-bottom: 1px solid #000;border: none;">
                            {{ $insumo->cliente->nombre }}</td>
                    </tr>
                    <tr style="border: none;">
                        <td style="width: 20%; font-weight: bold;border: none;">DIRECCION:</td>
                        <td style="width: 80%; border-bottom: 1px solid #000;border: none;">
                            {{ $insumo->cliente->direccion ?? 'N/A' }}</td>
                    </tr>
                @endif
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">FECHA:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;border: none;">{{ date('d/m/Y') }}</td>
                </tr>
                <tr style="border: none;">
                    <td style="width: 20%; font-weight: bold;border: none;">ASUNTO:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;border: none;">Nos dirigimos a usted para
                        informarle sobre
                        un inconveniente encontrado en el último envío de materiales recibido el
                        {{ date('d/m/Y', strtotime($insumo->fecha_ingreso)) }}.</td>
                </tr>
                <tr>
                    <td style="width: 20%; font-weight: bold;border: none;">INCONVENIENTE:</td>
                    <td style="width: 80%; border-bottom: 1px solid #000;border: none;">Despues de la verificación de
                        los materiales
                        recibidos, hemos notado que la cantidad recibida no coincide con la cantidad esperada. A
                        continuación, se detallan las diferencias encontradas:</td>
                </tr>
            </table>
        </div>

        <table>
            <thead>
                <tr class="bg-blue-300">
                    <th>DESCRIPCION</th>
                    <th>ESTILO</th>
                    <th>COLOR</th>
                    <th>TALLA</th>
                    <th>UNI. MEDIDA</th>
                    <th>CANTIDAD ESPERADA</th>
                    <th>CANTIDAD RECIBIDA</th>
                    <th>FALTANTE</th>
                </tr>
            </thead>
            <tbody>
                @foreach ($insumoFaltante as $detalle)
                    <tr>
                        <td>
                            {{ $detalle->descripcion }}
                        </td>
                        <td>
                            {{ $detalle->estilo }}
                        </td>
                        <td>
                            {{ $detalle->color?->nombre ?? 'N/A' }}
                        </td>
                        <td>
                            {{ $detalle->talla?->nombre ?? 'N/A' }}
                        </td>
                        <td>
                            {{ $detalle->unidad_medida?->nombre ?? 'N/A' }}
                        </td>
                        <td>
                            {{ $detalle->cantidad_esperada }}
                        </td>
                        <td>
                            {{ $detalle->cantidad_recibida }}
                        </td>
                        <td>
                            {{ $detalle->cantidad_esperada - $detalle->cantidad_recibida }}
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        {{-- <div class="observaciones">
            <p><strong>OBSERVACIONES:</strong></p>
            <ul>
                <li>El tiempo de garantía de la prenda es de 12 meses por daños de confección o descomposición del
                    material.</li>
                <li>El tiempo de entrega de las prendas es en 05 días hábiles desde la confirmación de la orden.</li>
                <li>El tiempo de sostenimiento de oferta es de 45 días</li>
            </ul>
        </div> --}}

        <div class="signatures">
            <table width="100%">
                <tr>
                    <td style="width: 33%; text-align: center;">
                        <img src="https://koton.webdevgt.com/public/images/ana2.png" alt="FIRMA1"
                            style="width: 100px;">
                        <p>ENCARGADO DE ALMACEN</p>
                        <p class="text-blue-600">Nombre Persona</p>
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <img src="https://koton.webdevgt.com/public/images/sello2.png" alt="SELLO"
                            style="width: 200px;">
                    </td>
                    <td style="width: 33%; text-align: center;">
                        <p style="margin-bottom:85px;">FIRMA DE ENTERADO</p>
                    </td>
                </tr>
            </table>
        </div>
        <div class="footer">
            <img src="https://koton.webdevgt.com/public/images/pie.png" alt="FORMA" style="width: 100%;">
        </div>
    </div>
</body>

</html>
