@extends('layouts.app')

@section('content')
    @extends('inventario.menu')
    <style>
        #catalogo_productos {
            width: 100%;
        }

        #preview-imagen {
            max-width: 100px;
            height: auto;
            margin-top: 10px;
        }
    </style>
    <form action="{{ route('inventario.actualizar_insumo', $insumo->id) }}" id="formEnviar" method="POST"
        enctype="multipart/form-data">
        @csrf
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('inventario.dashboard_insumo') }}">Insumos y
                                    accesorios</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Detalle</li>
                        </ol>
                    </nav>
                    <button class="btn botonColor" id="botonEnviar" type="submit">Actualizar</button>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Detalle de insumo <span id='referencia'></span> <span id='ver_cuenta_corriente'></span></h2>
                </div>
                <div class="col-md-12 mt-4">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Linea de Negocio</label>
                                <div class="col-sm-8">
                                    <select name="linea_negocio" id="lineaNegocio" class="form-control"
                                        onchange="ocultarSeccionCliente(this)">
                                        <option value="1" {{ $insumo->linea_negocio_id == 1 ? 'selected' : '' }}>
                                            Maquila</option>
                                        <option value="2" {{ $insumo->linea_negocio_id == 2 ? 'selected' : '' }}>
                                            Koton Texils</option>
                                        <option value="3" {{ $insumo->linea_negocio_id == 3 ? 'selected' : '' }}>
                                            SHARKAR</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row" id="seccionCliente">
                                <label for="" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="cliente" onchange="infoCliente(this)"
                                        id="exampleFormControlSelect1" required>
                                        <option value="">Seleccione un cliente</option>
                                        @foreach ($clientes as $cliente)
                                            <option value="{{ $cliente['id'] }}">{{ $cliente['nombre'] }}</option>
                                            @if ($cliente['id'] == $insumo['cliente_id'])
                                                <option value="{{ $cliente['id'] }}" selected>{{ $cliente['nombre'] }}
                                                </option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">P.O.</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="po"
                                        value="{{ $insumo->po }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Descripcion</label>
                                <div class="col-sm-8">
                                    <input type="text" class="form-control-plaintext" name="descripcion_general"
                                        value="{{ $insumo->descripcion }}" placeholder="">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Fecha de ingreso</label>
                                <div class="col-sm-8">
                                    <input type="date" name="fecha_ingreso" class="form-control-plaintext" placeholder=""
                                        value="{{ $insumo->fecha_ingreso }}">
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="" class="col-sm-4 col-form-label">Observaciones</label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="observaciones_general" id="" cols="30" rows="4">{{ $insumo->observaciones }}</textarea>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="imagen" class="col-sm-4 col-form-label">Actualizar Imagen</label>
                                <div class="col-sm-8">
                                    <input type="file" class="form-control" name="imagen" id="imagen"
                                        accept="image/*">
                                    <img id="preview-imagen" src="#" alt="Previsualización"
                                        style="display: none; margin-top: 10px; max-width: 300px; height: auto;">
                                    <button type="button" id="clear-imagen" class="btn btn-danger"
                                        style="margin-top: 10px; display: none;">Limpiar</button>
                                </div>
                            </div>
                            @if ($insumo->imagen)
                                <div class="form-group row">
                                    <label for="" class="col-sm-4 col-form-label">Imagen Actual</label>
                                    <div class="col-sm-8">
                                        <img src="/storage/inventarios/{{ $insumo->imagen }}" alt="Visualizacion"
                                            style="margin-top: 10px; max-width: 300px; height: auto;">
                                    </div>
                                </div>
                            @endif
                        </div>
                    </div>
                    <!-- Productos -->
                    <div class="row">
                        <div class="col-md-12">
                            <ul class="nav nav-tabs" id="myTab">
                                <li class="nav-item">
                                    <a href="#home" class="nav-link" data-toggle="tab">Lista de ingreso</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade" id="home">
                                    <table class="table-responsive">
                                        <thead>
                                            <tr>
                                                <th></th>
                                                <th scope="col" style='min-width: 300px;'>Descripción</th>
                                                <th scope="col">Unidad de medida</th>
                                                <th scope="col">Estilo</th>
                                                <th scope="col">Color</th>
                                                <th scope="col">Talla</th>
                                                <th scope="col">Cantidad Esperada</th>
                                                <th scope="col">Cantidad Ingresada</th>
                                                <th scope="col">Cajas</th>
                                                <th scope="col">Observaciones</th>
                                                <th scope="col">Faltante</th>
                                                <th scope="col">Entregado</th>
                                            </tr>
                                        </thead>
                                        <tbody id="contenedorProductos">
                                            @foreach ($insumo->detalle as $item)
                                                <tr class="producto">
                                                    <td><a class="botonColorRojo" onclick="eliminarFila(this)"><i
                                                                class="fas fa-trash"></i></a></td>
                                                    <td><input type="text" name="descripcion[]" class="form-control"
                                                            value="{{ $item->descripcion }}"></td>
                                                    <td>
                                                        <select name="medida[]" id="" class="form-control">
                                                            <option value="">N/A</option>
                                                            @foreach ($medidas as $medida)
                                                                @if ($medida['id'] == $item->unidad_medida_id)
                                                                    <option value="{{ $medida['id'] }}" selected>
                                                                        {{ $medida['nombre'] }}
                                                                    </option>
                                                                @else
                                                                    <option value="{{ $medida['id'] }}">
                                                                        {{ $medida['nombre'] }}
                                                                    </option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td><input type="text" name="estilo[]" class="form-control"
                                                            value="{{ $item->estilo }}">
                                                    </td>
                                                    <td>
                                                        <select name="color[]" id="" class="form-control">
                                                            <option value="">N/A</option>
                                                            @foreach ($colores as $color)
                                                                @if ($color['id'] == $item->color_id)
                                                                    <option value="{{ $color['id'] }}" selected>
                                                                        {{ $color['nombre'] }}
                                                                    </option>
                                                                @else
                                                                    <option value="{{ $color['id'] }}">
                                                                        {{ $color['nombre'] }}
                                                                    </option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        <select name="talla[]" id="" class="form-control">
                                                            <option value="">N/A</option>
                                                            @foreach ($tallas as $talla)
                                                                @if ($talla['id'] == $item->talla_id)
                                                                    <option value="{{ $talla['id'] }}" selected>
                                                                        {{ $talla['nombre'] }}
                                                                    </option>
                                                                @else
                                                                    <option value="{{ $talla['id'] }}">
                                                                        {{ $talla['nombre'] }}
                                                                    </option>
                                                                @endif
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td><input type="number" name="cantidad_esperada[]"
                                                            class="form-control" value="{{ $item->cantidad_esperada }}"
                                                            onchange="calcularTotal(this)"></td>
                                                    <td><input type="number" name="cantidad_ingresada[]"
                                                            class="form-control" value="{{ $item->cantidad_recibida }}"
                                                            onchange="calcularTotal(this)"></td>
                                                    <td><input type="number" name="cajas[]" class="form-control"
                                                            value="{{ $item->cajas }}"></td>
                                                    <td><input type="text" name="observaciones[]" class="form-control"
                                                            value="{{ $item->observaciones }}"></td>
                                                    <td><input type="number" name="faltante[]" class="form-control"
                                                            value="{{ $item->faltante }}" readonly></td>
                                                    <td>
                                                        <input class="form-control" type="number" readonly
                                                            value="{{ $item->entregado ?? 0 }}">
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                    <br>
                                    <a class="btn btn-primary" onclick="nuevaFila()">Agregar otro</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

        <!-- Script JavaScript -->
        <script>
            function nuevaFila() {
                var fila = document.querySelector('.producto').cloneNode(true);
                fila.querySelectorAll('input').forEach(input => input.value = '');
                fila.querySelectorAll('select').forEach(select => select.selectedIndex = 0);
                document.getElementById('contenedorProductos').appendChild(fila);
            }

            function eliminarFila(elemento) {
                var fila = elemento.parentNode.parentNode;
                fila.parentNode.removeChild(fila);
            }

            function calcularTotal(elemento) {
                var fila = elemento.parentNode.parentNode;
                var cantidadEsperada = parseFloat(fila.querySelector('input[name="cantidad_esperada[]"]').value) || 0;
                var cantidadIngresada = parseFloat(fila.querySelector('input[name="cantidad_ingresada[]"]').value) || 0;
                var faltante = cantidadEsperada - cantidadIngresada;
                fila.querySelector('input[name="faltante[]"]').value = faltante;
            }

            function ocultarSeccionCliente(select) {
                var seccionCliente = document.getElementById('seccionCliente');
                if (select.value !== 'Maquila') {
                    seccionCliente.style.display = 'none';
                } else {
                    seccionCliente.style.display = 'block';
                }
            }

            function guardarFormulario() {
                Swal.fire({
                    title: 'Guardado correctamente',
                    icon: 'success',
                    confirmButtonText: 'Aceptar'
                });

                // direccionar al dashboard de insumos
                setTimeout(() => {
                    window.location.href = "{{ route('inventario.dashboard_insumo') }}";
                }, 2000);
            }

            document.getElementById('imagen').addEventListener('change', function(event) {
                const reader = new FileReader();
                reader.onload = function() {
                    const output = document.getElementById('preview-imagen');
                    output.src = reader.result;
                    output.style.display = 'block';
                    document.getElementById('clear-imagen').style.display = 'inline-block';
                };
                reader.readAsDataURL(event.target.files[0]);
            });

            document.getElementById('clear-imagen').addEventListener('click', function() {
                document.getElementById('imagen').value = '';
                document.getElementById('preview-imagen').style.display = 'none';
                document.getElementById('clear-imagen').style.display = 'none';
            });
        </script>
    </form>
@endsection
