@extends('layouts.app')
@section('content')
@extends('inventario.menu')
<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Nuevos Ingresos</h2>
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>OP</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Producto</td>
          <td>Cantidad</td>
          <td>Unidades</td>
          <td>Observaciones</td>
          <td>Rechazos</td>
          <td>Acción</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($opParciales as $op)
          @if($op->status!=99)
          <tr>
            <td>{{$op->id_op}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>{{$op->op->cliente->nombre??'Inventario'}}</td>
            <td>{{$op->op->producto->nombre}}</td>
            <td>{{$op->cantidad}}</td>
            <td>{{$op->op->producto->medida->nombre}}</td>
            <td>{{$op->observaciones}}</td>
            <td>{{$op->obseervacion_almacen}}</td>
            <td>
              <a onclick="inventario(this)" class="" title="Aprobación de ingresos" data-id_parcial="{{$op->id}}"><i class="fas fa-clipboard-check"></i></a>
              <a href="#" data-id="{{$op->id}}" title="Rechazar ingreso" class="recharIngreso" style="margin-left:10px;"><i class="fas fa-ban"></i></a>
            </td>
          </tr>
          @endif
        @endforeach
      </tbody>
  </table>
  </div>
</div>
<script>
  function inventario(elemento){    
    jQuery( document ).ready(function() {
      var token = '{{ csrf_token() }}';
      $.ajax({
            type:'POST',
            url:'{{ route('inventario.ingreso_almacen_ajax') }}',
            headers: {'X-CSRF-TOKEN': token},
            data:{
              idOrden:$(elemento).attr('data-id_parcial'),
            },
            success:function(data){
              var padre=$(elemento).parent().parent();
              if(data){
                padre.remove();
                Swal.fire({
                    position: 'top-end',
                    title: "Ingreso a almacen",
                    showConfirmButton: false,
                    timer: 1500
                });
              }
            }
      });
    });
    return false;
  }
  $('.recharIngreso').each(function(){
    $(this).click(function(){
      var token = '{{ csrf_token() }}';
      var idOP=$(this).attr('data-id');
      var rechazo = prompt("Motivo del rechazo");

      if (rechazo) {
        $.ajax({
          type:'POST',
          url:'{{ route('fabricacion.op_parcial_rechazar') }}',
          headers: {'X-CSRF-TOKEN': token},
          data:{
            idOP:idOP,
            rechazo:rechazo
          },
          success:function(data){
            location.reload();
          }
        });
      }else{
        alert('Debes ingresar un motivo')
      }
      return false;
    })
  });  
</script>
@endsection
