@extends('layouts.app')

@section('content')
    @extends('fabricacion.menu')
    <style>
        #catalogo_productos {
            width: 100%;
        }
    </style>
    <form action="{{ route('fabricacion.actualizar_corte') }}" id="formEnviar" method="POST">
        @csrf
        <input type="number" name="orden_corte_id" hidden value="{{ $corte->id }}">
        <div id="contenedor_interno" class="container-fluid">
            <div class="row ">
                <div class="col-md-12">
                    <nav aria-label="breadcrumb">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('inventario.dashboard_insumo') }}">Control de
                                    corte</a>
                            </li>
                            <li class="breadcrumb-item active" aria-current="page">Detalle</li>
                        </ol>
                    </nav>
                    <button class="btn botonColor" id="botonEnviar">Actualizar</button>
                </div>
                <hr>
            </div>
        </div>

        <div id="contenedor_contenido" class="container-fluid px-lg-5">
            <div class="row">
                <div class="col-md-12">
                    <h2>Detalle de corte - CRT00001 - <span id='referencia'></span> <span
                            id='ver_cuenta_corriente'>12/07/2024</span>
                    </h2>
                </div>
                <div class="col-md-12 mt-4">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="lineaNegocio" class="col-sm-4 col-form-label">Linea de Negocio</label>
                                <div class="col-sm-8">
                                    <select name="linea_negocio_id" id="lineaNegocio" class="form-control"
                                        onchange="ocultarSeccionCliente(this)">
                                        @php
                                            $lineaNegocio = match ($corte->linea_negocio_id) {
                                                1 => 'Maquila',
                                                2 => 'KOTON TEXTILS',
                                                3 => 'SHARKAR',
                                                default => 'Desconocido',
                                            };
                                        @endphp
                                        <option value="{{ $corte->linea_negocio_id }}">{{ $lineaNegocio }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row" id="seccionCliente">
                                <label for="cliente" class="col-sm-4 col-form-label">Cliente</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="cliente_id" onchange="infoCliente(this)"
                                        id="cliente" required>
                                        <option value="{{ $corte->cliente_id }}">{{ $corte->cliente?->nombre }}</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="jefe_corte" class="col-sm-4 col-form-label">Cortador</label>
                                <div class="col-sm-8">
                                    <input type="text" name="cortador" value="{{ $corte->cortador }}"
                                        class="form-control-plaintext" placeholder="Koton">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="jefe_corte" class="col-sm-4 col-form-label">Tendedor</label>
                                <div class="col-sm-8">
                                    <input type="text" name="tendedor" value="{{ $corte->tendedor }}"
                                        class="form-control-plaintext" placeholder="Koton">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="estilo" class="col-sm-4 col-form-label">Estilo</label>
                                <div class="col-sm-8">
                                    <select name="estilo_id" id="estilo" class="form-control">
                                        @foreach ($estilos as $estilo)
                                            <option value="{{ $estilo->id }}">{{ $estilo->nombre }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            {{-- <div class="form-group row">
                                <label for="fin_corte" class="col-sm-4 col-form-label">Orden</label>
                                <div class="col-sm-8">
                                    <input type="text" id="orden" class="form-control-plaintext"
                                        placeholder="CRT00001">
                                </div>
                            </div> --}}
                            <div class="form-group row">
                                <label for="fin_corte" class="col-sm-4 col-form-label">Marca</label>
                                <div class="col-sm-8">
                                    <input type="text" name="marca" value="{{ $corte->marca }}"
                                        class="form-control-plaintext" placeholder="Koton">
                                </div>
                            </div>
                            {{-- <div class="form-group row">
                                <label for="observaciones" class="col-sm-4 col-form-label">Observaciones</label>
                                <div class="col-sm-8">
                                    <textarea class="form-control" name="observaciones" id="observaciones" cols="30" rows="4">{{$corte->observaciones}}</textarea>
                                </div>
                                --}}
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label for="lienzos" class="col-sm-4 col-form-label">Consumo</label>
                                <div class="col-sm-8">
                                    <input type="text" name="consumo" class="form-control-plaintext" placeholder=""
                                        value="{{ $corte->consumo }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="lienzos" class="col-sm-4 col-form-label">Yardas a Utilizar</label>
                                <div class="col-sm-8">
                                    <input type="text" name="yardas_utilizar" class="form-control-plaintext"
                                        placeholder="" value="{{ $corte->yardas_utilizar }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="lienzos" class="col-sm-4 col-form-label">Lienzos</label>
                                <div class="col-sm-8">
                                    <input type="text" name="lienzos_general" class="form-control-plaintext"
                                        placeholder="" value="{{ $corte->lienzos }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="color" class="col-sm-4 col-form-label">Color</label>
                                <div class="col-sm-8">
                                    <select class="form-control" name="color_id" onchange="infoCliente(this)"
                                        id="cliente" required>
                                        @foreach ($colores as $color)
                                            @if ($corte->color_id == $color->id)
                                                <option value="{{ $color->id }}" selected>{{ $color->nombre }}
                                                </option>
                                            @else
                                                <option value="{{ $color->id }}">{{ $color->nombre }}</option>
                                            @endif
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="ancho" class="col-sm-4 col-form-label">Ancho</label>
                                <div class="col-sm-8">
                                    <input type="text" name="ancho" class="form-control-plaintext" placeholder=""
                                        value="{{ $corte->ancho }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="largo_trazo" class="col-sm-4 col-form-label">Largo de trazo</label>
                                <div class="col-sm-8">
                                    <input type="text" name="largo_trazo" class="form-control-plaintext"
                                        placeholder="" value="{{ $corte->largo_trazo }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inicio_tendido" class="col-sm-4 col-form-label">Inicio de Tendido</label>
                                <div class="col-sm-8">
                                    <input type="time" name="inicio_tendido" class="form-control" placeholder=""
                                        value="{{ $corte->inicio_tendido }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="fin_tendido" class="col-sm-4 col-form-label">Finalizado Tendido</label>
                                <div class="col-sm-8">
                                    <input type="time" name="fin_tendido" class="form-control" placeholder=""
                                        value="{{ $corte->fin_tendido }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="inicio_corte" class="col-sm-4 col-form-label">Inicio de Corte</label>
                                <div class="col-sm-8">
                                    <input type="time" name="inicio_corte" class="form-control" placeholder=""
                                        value="{{ $corte->inicio_corte }}">
                                </div>
                            </div>
                            <div class="form-group row">
                                <label for="fin_corte" class="col-sm-4 col-form-label">Finalizado Corte</label>
                                <div class="col-sm-8">
                                    <input type="time" name="fin_corte" class="form-control" placeholder=""
                                        value="{{ $corte->fin_corte }}">
                                </div>
                            </div>
                        </div>

                        <!-- Productos -->
                        <div class="row">
                            <div class="col-md-12">
                                <ul class="nav nav-tabs" id="myTab">
                                    <li class="nav-item">
                                        <a href="#home" class="nav-link" data-toggle="tab">Lista de corte</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div class="tab-pane fade" id="home">
                                        <table class="table-responsive">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th scope="col">Rollos</th>
                                                    <th scope="col">Lote</th>
                                                    <th scope="col">LB, KG o MT</th>
                                                    <th scope="col">Yardas Etiqueta</th>
                                                    <th scope="col">Lienzos</th>
                                                    <th scope="col">Yardas Tendidas</th>
                                                    <th scope="col">Tipo de Defecto</th>
                                                    <th scope="col">Puntas</th>
                                                    <th scope="col">Puntas Utilizadas</th>
                                                    <th scope="col">Sobrantes</th>
                                                    <th scope="col">Faltantes</th>
                                                    <th scope="col">Empalmes</th>
                                                    <th scope="col">Comentarios</th>
                                                </tr>
                                            </thead>
                                            <tbody id="contenedorProductos">
                                                @foreach ($corte->detalle as $detalle)
                                                    <tr class="producto">
                                                        <input type="number" hidden style="display:none;" name="ids[]"
                                                            value="{{ $detalle->id }}">
                                                        <td><a class="botonColorRojo" onclick="eliminarFila(this)"><i
                                                                    class="fas fa-trash"></i></a></td>
                                                        <td><input type="text" class="form-control" name="rollos[]"
                                                                value="{{ $detalle->rollos }}"></td>
                                                        <td><input type="text" class="form-control" name="lote[]"
                                                                value="{{ $detalle->lote }}"></td>
                                                        <td>
                                                            <select class="form-control" name="medida_id[]">
                                                                @foreach ($unidades_medida as $medida)
                                                                    <option value="{{ $medida->id }}">
                                                                        {{ $medida->nombre }}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td><input type="text" class="form-control"
                                                                name="yardas_etiqueta[]" value="{{ $detalle->yardas }}">
                                                        </td>
                                                        <td><input type="text" class="form-control" name="lienzos[]"
                                                                value="{{ $detalle->lienzos }}"></td>
                                                        <td><input type="text" class="form-control"
                                                                name="yardas_tendidas[]"
                                                                value="{{ $detalle->yardas_tendidas }}"></td>
                                                        <td>
                                                            <select class="form-control" name="tipo_defecto_id[]">
                                                                <option value="">N/A</option>
                                                                @foreach ($tipo_defectos as $defecto)
                                                                    <option value="{{ $defecto->id }}">
                                                                        {{ $defecto->nombre }}</option>
                                                                @endforeach
                                                            </select>
                                                        </td>
                                                        <td><input type="text" class="form-control" name="puntas[]"
                                                                value="{{ $detalle->puntas }}"></td>
                                                        <td><input type="text" class="form-control"
                                                                name="puntas_utilizadas[]"
                                                                value="{{ $detalle->puntas_utilizadas }}"></td>
                                                        <td><input type="text" class="form-control" name="sobrantes[]"
                                                                value="{{ $detalle->sobrantes }}">
                                                        </td>
                                                        <td><input type="text" class="form-control" name="faltantes[]"
                                                                value="{{ $detalle->faltantes }}">
                                                        </td>
                                                        <td><input type="text" class="form-control" name="empalmes[]"
                                                                value="{{ $detalle->empalmes }}">
                                                        </td>
                                                        <td><input type="text" class="form-control"
                                                                name="observaciones[]"
                                                                value="{{ $detalle->observaciones }}"></td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                        <br>
                                        <a class="btn btn-primary" onclick="nuevaFila()">Agregar otro</a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

            <!-- Script JavaScript -->
            <script>
                function nuevaFila() {
                    var fila = document.querySelector('.producto').cloneNode(true);
                    fila.querySelectorAll('input').forEach(input => input.value = '');
                    fila.querySelectorAll('select').forEach(select => select.selectedIndex = 0);
                    document.getElementById('contenedorProductos').appendChild(fila);
                }

                function eliminarFila(elemento) {
                    var fila = elemento.parentNode.parentNode;
                    fila.parentNode.removeChild(fila);
                }

                function calcularTotal(elemento) {
                    var fila = elemento.parentNode.parentNode;
                    var cantidadEsperada = parseFloat(fila.querySelector('input[name="cantidad_esperada[]"]').value) || 0;
                    var cantidadIngresada = parseFloat(fila.querySelector('input[name="cantidad_ingresada[]"]').value) || 0;
                    var faltante = cantidadEsperada - cantidadIngresada;
                    fila.querySelector('input[name="faltante[]"]').value = faltante;
                }

                function ocultarSeccionCliente(select) {
                    var seccionCliente = document.getElementById('seccionCliente');
                    if (select.value !== 'Maquila') {
                        seccionCliente.style.display = 'none';
                    } else {
                        seccionCliente.style.display = 'block';
                    }
                }

                function guardarFormulario() {
                    Swal.fire({
                        title: 'Guardado correctamente',
                        icon: 'success',
                        confirmButtonText: 'Aceptar'
                    });

                    // direccionar al dashboard de insumos
                    setTimeout(() => {
                        window.location.href = "{{ route('fabricacion.dashboard_corte') }}";
                    }, 1000);
                }
            </script>

    </form>
@endsection
