@extends('layouts.app')

@section('content')
    @extends('fabricacion.menu')
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row ">
            <div class="col-md-12">
                <h2>Produccion por tallas</h2>
                <button type="button" class="btn btn-primary" data-toggle="modal" data-target="#registroModal">
                    Registrar Produccion
                </button>
            </div>
        </div>
        <div class="container mt-4">
            <form method="GET" action="{{ route('fabricacion.filtrar_produccion_talla') }}" id="filterForm">
                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_inicio">Fecha Inicio</label>
                            <input type="date" class="form-control" id="fecha_inicio" name="fecha_inicio">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label for="fecha_fin">Fecha Fin</label>
                            <input type="date" class="form-control" id="fecha_fin" name="fecha_fin">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="linea_id_filtro">Línea</label>
                            <select class="form-control" id="linea_id_filtro" name="linea_id">
                                <option value="">Todos</option>
                                @foreach ($lineas as $linea)
                                    <option value="{{ $linea->id }}">{{ $linea->nombre }} - {{ $linea->encargado->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <label for="estado_filtro">Estado</label>
                            <select class="form-control" id="estado_filtro" name="estado">
                                <option value="">Todos</option>
                                <option value="1" selected>Activo</option>
                                <option value="2">Anulado</option>
                            </select>
                        </div>
                    </div>
                </div>
                <button type="submit" class="btn btn-primary">Filtrar</button>
            </form>
        </div>
        <div class="col-md-12">
            <br>
            <table id="example" class="display" style="width:100%">
                <thead>
                    <tr>
                        <td>#</td>
                        <td>Fecha</td>
                        <td>Linea</td>
                        <td>Produccion</td>
                        <td>Talla</td>
                        <td>Acciones</td>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($producciones as $produccion)
                        @php
                            $colorEstado = match ($produccion->estado) {
                                0 => 'danger',
                                1 => '',
                                2 => 'danger',
                                default => 'warning',
                            };
                        @endphp
                        <tr>
                            <td class="alert alert-{{ $colorEstado }}">
                                {{ $produccion->id }}
                            </td>
                            <td>
                                {{ $produccion->created_at->format('d/m/Y') }}
                            </td>
                            <td>
                                {{ $produccion->linea?->nombre }} - {{ $produccion->linea?->encargado?->name }}
                            </td>

                            <td>
                                {{ $produccion->cantidad }}
                            </td>
                            <td>
                                {{ $produccion->talla?->nombre }}
                            </td>
                            <td class="d-flex justify-content-center align-items-center">
                                @if ($produccion->estado == 1)
                                    <button class="btn btn-danger" onclick="anular('{{ $produccion->id }}')">
                                        ANULAR
                                    </button>
                                    {{-- <button class="btn"
                                        onclick="editarRegistro('{{ $produccion->id }}', '{{ $produccion->descripcion }}', '{{ $produccion->cantidad }}', '{{ $produccion->estado }}', '{{ $produccion->tipo }}', '{{ $produccion->talla_id }}', '{{ $produccion->linea_id }}', '{{ $produccion->encargado_id }}')">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                            viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1"
                                            stroke-linecap="round" stroke-linejoin="round"
                                            class="icon icon-tabler icons-tabler-outline icon-tabler-edit">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path d="M7 7h-1a2 2 0 0 0 -2 2v9a2 2 0 0 0 2 2h9a2 2 0 0 0 2 -2v-1" />
                                            <path
                                                d="M20.385 6.585a2.1 2.1 0 0 0 -2.97 -2.97l-8.415 8.385v3h3l8.385 -8.415z" />
                                            <path d="M16 5l3 3" />
                                        </svg>
                                    </button> --}}
                                @else
                                    ANULADO
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
        @php
            $totalesPorTalla = $producciones
                ->where('estado', 1)
                ->groupBy('talla_id')
                ->map(function ($items) {
                    return $items->sum('cantidad');
                });
        @endphp

        <div class="container mt-4">
            <h3>Producción por Talla</h3>
            <table class="table">
                <thead>
                    <tr>
                        <th>Talla</th>
                        <th>Producción</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($totalesPorTalla as $talla_id => $total)
                        @php
                            $tallaNombre = $tallas->firstWhere('id', $talla_id)->nombre ?? 'Desconocida';
                        @endphp
                        <tr>
                            <td>{{ $tallaNombre }}</td>
                            <td>{{ $total }}</td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <td><strong>Total</strong></td>
                        <td><strong>{{ $totalesPorTalla->sum() }}</strong></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <div class="modal fade" id="registroModal" tabindex="-1" role="dialog" aria-labelledby="registroModalLabel"
        aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width:800px !important;">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="registroModalLabel">Agregar/Editar Registro</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="registroForm" method="POST" action="{{ route('fabricacion.guardar_produccion_talla') }}">
                        @csrf
                        <input type="hidden" name="produccion_id" id="produccion_id">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="linea_id">Línea</label>
                                    <select class="form-control" id="linea_id" name="linea_id" required>
                                        <option value="">Seleccione una línea</option>
                                        @foreach ($lineas as $linea)
                                            <option value="{{ $linea->id }}">{{ $linea->nombre }} -
                                                {{ $linea->encargado?->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="fecha">Fecha</label>
                                    <input type="date" class="form-control" id="fecha" name="fecha" required>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="cantidad_talla">Cantidad y Talla</label>
                                    <div id="cantidadTallaContainer">
                                        <!-- Aquí se agregarán dinámicamente los inputs -->
                                    </div>
                                    <button type="button" class="btn btn-secondary" id="addCantidadTalla">Agregar
                                        Cantidad</button>
                                </div>
                            </div>
                        </div>
                        <button type="submit" class="btn btn-primary">Guardar</button>
                    </form>
                </div>
            </div>
        </div>
    </div>


    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

    <script>
        function editarRegistro(id, descripcion, cantidad, estado, tipo, talla_id, linea_id, encargado_id) {
            document.getElementById('produccion_id').value = id;
            document.getElementById('descripcion').value = descripcion;
            document.getElementById('cantidad').value = cantidad;
            document.getElementById('talla_id').value = talla_id;
            document.getElementById('linea_id').value = linea_id;
            document.getElementById('encargado_id').value = encargado_id;

            $('#registroModal').modal('show');
        }

        function limpiarFormulario() {
            document.getElementById('registroForm').action =
                '{{ route('fabricacion.guardar_produccion_talla') }}'; // Cambia la acción del formulario para crear
            document.getElementById('registroForm').reset();
            $('#registroModal').modal('show');
        }

        function anular(id) {
            Swal.fire({
                title: '¿Estás seguro?',
                text: "Esta acción no se puede deshacer",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Sí, anular'
            }).then((result) => {
                if (result.isConfirmed) {
                    fetch(`/fabricacion/produccion_talla/${id}/anulacion`, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': '{{ csrf_token() }}'
                            }
                        })
                        .then(response => response.json())
                        .then(data => {
                            if (data.success) {
                                Swal.fire(
                                    'Anulado!',
                                    'El registro ha sido anulado.',
                                    'success'
                                ).then(() => {
                                    location.reload(); // Recargar la página después de la confirmación
                                });
                            } else {
                                Swal.fire(
                                    'Error!',
                                    data.message || 'Hubo un problema al anular el registro.',
                                    'error'
                                );
                            }
                        })
                        .catch((error) => {
                            Swal.fire(
                                'Error!',
                                'Hubo un problema al anular el registro.',
                                'error'
                            );
                        });
                }
            });
        }
    </script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const addBtn = document.getElementById('addCantidadTalla');
            const container = document.getElementById('cantidadTallaContainer');

            addBtn.addEventListener('click', function() {
                const div = document.createElement('div');
                div.classList.add('row', 'mb-2');

                div.innerHTML = `
                    <div class="col-md-5">
                        <input type="number" class="form-control" name="cantidades[]" placeholder="Cantidad" required>
                    </div>
                    <div class="col-md-5">
                        <select class="form-control" name="tallas[]" required>
                            <option value="">Seleccione una talla</option>
                            @foreach ($tallas as $talla)
                                <option value="{{ $talla->id }}">{{ $talla->nombre }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-md-2">
                        <button type="button" class="btn btn-danger removeCantidadTalla">&times;</button>
                    </div>
                `;

                container.appendChild(div);

                div.querySelector('.removeCantidadTalla').addEventListener('click', function() {
                    div.remove();
                });
            });
        });
    </script>
@endsection
