@extends('layouts.app')

@section('content')
@extends('fabricacion.menu')


<div id="contenedor-dashboard" class="container-fluid">
  <div class="row ">
    <div class="col-md-12">
      <h2>Ordenes de Producción</h2>
      @if (Auth::user()->id==4 || Auth::user()->id==2 || Auth::user()->id==12 || Auth::user()->id==7)
          <a type="button" href="{{route('ventas.nueva_op')}}" class="botonColorVerde">Nueva</a>
      @endif
    </div>
  </div>
  <div class="col-md-12">
    <br>
    <br>
    <table id="example" class="display" style="width:100%">
      <thead>
        <tr>
          <td>OP</td>
          <td>Fecha</td>
          <td>Cliente</td>
          <td>Cantidad</td>
          <td>Producto</td>
          <td>Ejecutivo</td>
          <td>Planificación Producción</td>
          <td>Estado</td>
          <td>Pendiente fabricar</td>
          <td>Kgs Millar</td>
          <td>Kgs Procesar</td>
          <td>Acción</td>
        </tr>
      </thead>
      <tbody>      
        @foreach ($ops as $op)
          <tr class="{{$op->status==2?'table-warning':''}} {{$op->status==3?'table-success':''}} {{$op->status==4?'table-success':''}}">
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y h:i:s", strtotime($op->created_at))}}</td>
            <td>{{$op->cliente->nombre??'Inventario'}}</td>
            <td>{{$op->cantidad}} {{$op->producto->medida->nombre}}</td>
            <td>{{$op->producto->nombre}}</td>
            
            <td>{{$op->cliente->info_ejecutivo->name??'Inventario'}}</td>
            <td>{{$op->fecha_entrega?date("d/m/Y", strtotime($op->fecha_entrega)):''}}</td>

            <td>
              @if ($op->status==2)
                Autorizada
              @endif
              @if ($op->status==3)
                Proceso
              @endif
              @if ($op->status==4)
                Terminada
              @endif
              @if ($op->status==99)
                Anulada
              @endif
            </td>
            <td>
              @if ($op->status==3)
              <?php
                $cantidad=$op->cantidad;
                $ordenes_paciales=0;
                foreach ($op->ordenes_paciales as $key => $x) {
                  $ordenes_paciales=$ordenes_paciales+(int)$x->cantidad;
                }
                $cantidad=$cantidad-$ordenes_paciales;
                //dd($cantidad);
                
              ?>
               {{$cantidad}} {{$op->producto->medida->nombre}}
              @endif
            </td>
            <td>{{$op->producto->factor_conversion_kilos}}</td>
            <td>{{$op->producto->factor_conversion_kilos*$op->cantidad}}</td>
            <td>
              @if ($op->status==2)
              <a href="{{route('fabricacion.orden_produccion',$op->id)}}" class="" title="Ver orden de producción"><i class="far fa-eye"></i></a>
              @endif
              @if ($op->status==3)
              <a href="{{route('fabricacion.orden_produccion',$op->id)}}" class="" title="Ver orden de producción"><i class="far fa-eye"></i></a>
              @endif
              @if ($op->status==4)
              <a href="{{route('fabricacion.orden_produccion',$op->id)}}" class="" title="Ver orden de producción"><i class="far fa-eye"></i></a>
              @endif
            </td>
          </tr>
        @endforeach
        @foreach ($opsInventario as $op)
          <tr class="{{$op->status==2?'table-warning':''}} {{$op->status==3?'table-warning':''}} {{$op->status==4?'table-success':''}}">
            <td>{{$op->id}}</td>
            <td>{{date("d/m/Y", strtotime($op->created_at))}}</td>
            <td>{{$op->cliente->nombre??'Inventario'}}</td>
            <td>{{$op->cantidad}} {{$op->producto->medida->nombre}}</td>
            <td>{{$op->producto->nombre}}</td>
            
            <td>{{$op->cliente->info_ejecutivo->name??'Inventario'}}</td>
            <td>{{$op->fecha_entrega?date("d/m/Y", strtotime($op->fecha_entrega)):''}}</td>

            <td>
              Pendiente autorización
            </td>
            <td>{{$op->producto->factor_conversion_kilos}}</td>
            <td>{{$op->producto->factor_conversion_kilos*$op->cantidad}}</td>
            <td>
              
            </td>
            <td>
              
            </td>
          </tr>
        @endforeach
      </tbody>
  </table>
  </div>
</div>
@endsection
