<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="{{ asset('images/favicon.png') }}">
    <!-- CSRF Token -->
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ config('app.name', 'Laravel') }}</title>

    <!-- Scripts -->
    <script src="{{ asset('js/app.js') }}" defer></script>

    <!-- Fonts -->
    <link rel="dns-prefetch" href="//fonts.gstatic.com">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">

    <!-- Styles -->
    <link href="{{ asset('css/app.css') }}" rel="stylesheet">
</head>

<body>
    <div id="app">
        <nav class="navbar navbar-light">

            <ul class="navbar-nav ml-auto">
                <!-- Authentication Links -->

                <li class="nav-item dropdown">
                    <a id="" class="nav-link dropdown-toggle menu-label" href="#" role="button"
                        data-toggle="dropdown" aria-haspopup="true" aria-expanded="false" v-pre>
                        {{ Auth::user()->name }}
                    </a>

                    <div class="dropdown-menu dropdown-menu-right" aria-labelledby="navbarDropdown">
                        <a class="dropdown-item menu-label" href="{{ route('logout') }}"
                            onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                            Cerrar sesión
                        </a>

                        <form id="logout-form" action="{{ route('logout') }}" method="POST" class="d-none">
                            @csrf
                        </form>
                    </div>
                </li>

            </ul>
        </nav>
        <div class="container">
            <div class="row">
                <img style="margin: auto" src="{{ asset('images/logo_concisa_t.png') }}" alt="">
                <div id="c_iconosDashboard" class="col-md-12">
                    @if ($usuario == 1 || $usuario >= 2)
                        @if ($usuario == 7 || $usuario == 12)
                            <a href="{{ route('ventas.dashboard_gerencia') }}">
                                <div class="link">
                                    <img class="iconosDashboard" src="{{ asset('images/iconos/ventas.png') }}"
                                        alt="Ventas">
                                    <p class="menu-label">Ventas</p>
                                </div>
                            </a>
                        @else
                            <a href="{{ route('ventas.dashboard') }}">
                                <div class="link">
                                    <img class="iconosDashboard" src="{{ asset('images/iconos/ventas.png') }}"
                                        alt="Ventas">
                                    <p class="menu-label">Ventas</p>
                                </div>
                            </a>
                        @endif
                        @if (in_array($usuario, [4, 7, 18, 12, 21]))
                            <a href="{{ route('compras.dashboard') }}">
                                <div class="link">
                                    <img class="iconosDashboard" src="{{ asset('images/iconos/compras.png') }}"
                                        alt="Ventas">
                                    <p class="menu-label">Compras</p>
                                </div>
                            </a>
                        @endif
                        <a href="{{ route('inventario.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/inventario.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Almacen</p>
                            </div>
                        </a>
                        <a href="{{ route('fabricacion.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/fabricacion.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Fabricación</p>
                            </div>
                        </a>
                        <a href="{{ route('contabilidad.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/contabilidad.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Contabilidad</p>
                            </div>
                        </a>
                        <a href="{{ route('ajustes.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/ajustes.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Ajustes</p>
                            </div>
                        </a>
                        <a href="{{ route('reportes.dashboard') }}">
                            <div class="link">
                                <img style="background-color: transparent;" class="iconosDashboard"
                                    src="{{ asset('images/iconos/reportes.png') }}" alt="Ventas">
                                <p class="menu-label">Reportes</p>
                            </div>
                        </a>
                        @if ($usuario == 18 || $usuario == 12 || $usuario == 7 || $usuario == 4 || $usuario == 1 || $usuario == 21)
                            <a href="{{ route('rrhh.dashboard') }}">
                                <div class="link">
                                    <img style="background-color: transparent;" class="iconosDashboard"
                                        src="{{ asset('images/iconos/rh.png') }}" alt="HR">
                                    <p class="menu-label">Recursos Humanos</p>
                                </div>
                            </a>
                        @endif
                    @endif
                    @if ($usuario == 2)
                        <a href="{{ route('fabricacion.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/fabricacion.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Fabricación</p>
                            </div>
                        </a>
                    @endif
                    @if ($usuario == 3)
                        <a href="{{ route('inventario.dashboard') }}">
                            <div class="link">
                                <img class="iconosDashboard" src="{{ asset('images/iconos/inventario.png') }}"
                                    alt="Ventas">
                                <p class="menu-label">Almacen</p>
                            </div>
                        </a>
                    @endif
                    <a href="http://192.168.1.42:8080/" target="_blank">
                        <div class="link">
                            <img class="iconosDashboard" src="{{ asset('images/iconos/sistema.png') }}"
                                alt="Ventas">
                            <p class="menu-label">Parametrizacion y produccion</p>
                        </div>
                    </a>
                </div>
            </div>
        </div>
    </div>
</body>

</html>
