@extends('layouts.app')
@extends('compras.menu')
@section('content')
<style>
    .import-success{
        background-color: red !important;
        border-radius: 5px;
    }
    .import-success a{
        color: white !important;
    }
</style>
    <div id="contenedor-dashboard" class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                {{-- <a type="button" href="{{ route('compras.orden_compra') }}" class="botonColor">ORDEN COMPRA </a> --}}
                <a type="button" href="{{ route('compras.nueva_importacion') }}" class="botonColorNaranja">PEDIDO AL
                    EXTERIOR</a>
            </div>
        </div>

        <div class="col-md-12" style="margin-top: 150px !important;">
            <br>
            <table id="compras-table" class="display" style="width:100%">
                <thead>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Pagado</th>
                        <th scope="col">Saldo</th>
                        <th scope="col">ETA</th>
                        <th scope="col">Observacion</th>
                    </tr>
                </thead>
                <tbody>
                    @php
                        $total = 0;
                        $total_pagado = 0;
                        $total_saldo = 0;
                    @endphp
                    @foreach ($compras as $compra)
                        <tr style="height: 60px !important;">
                            <td class="{{$compra->estado == 3 ? 'import-success' : ''}}">
                                <a href="{{ route('compras.detalle', $compra->id) }}">{{ $compra->correlativo }} {{$compra->estado == 3 ? ' revisado' : ''}}</a>
                            </td>
                            <td>
                                {{ $compra->proveedor->nombre ?? '' }}
                            </td>
                            <td>
                                <ul>
                                    @foreach ($compra->detalle as $detalle)
                                    <li>
                                        {{ substr($detalle->producto->nombre, 0, 12) }}...
                                    </li>
                                    @endforeach
                                </ul>
                            </td>
                            <td>
                                @php
                                    $ruta_documento =
                                        $compra->estado == 1
                                            ? '/proform_invoice/' . $compra->proforma_documento
                                            : '/facturas/' . $compra->factura_documento;
                                    $no_ducumento =
                                        $compra->estado == 1
                                            ? 'PI: ' . $compra->no_pi
                                            : 'Factura: ' . $compra->no_factura;
                                    $total_compra = $compra->estado == 1 ? $compra->total_pi : $compra->total_factura + $compra->total_flete_seguro ?? 0;
                                @endphp
                                <a href="{{ asset('storage/compras' . $ruta_documento) }}" target="_blank"
                                    rel="noopener noreferrer">{{ $no_ducumento }}</a>
                            </td>
                            <td>
                                {{ $tipo = $compra->estado == 1 ? 'PI:' : 'Factura:' }}
                                ${{ number_format($total_compra , 2, '.', ',') }}
                            </td>
                            <td>${{ number_format($compra->total_pagado, 2, '.', ',') }}</td>
                            <td>${{ number_format($total_compra - $compra->total_pagado, 2, '.', ',') }}</td>
                            <td>{{ $compra->envio->first()->fecha_estimada ?? 'No Disponible' }}</td>
                            <td>{{ $compra->observaciones }}</td>
                        </tr>

                        @php
                            $total += $total_compra;
                            $total_pagado += $compra->total_pagado;
                            $total_saldo += $total_compra - $compra->total_pagado;
                        @endphp
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th scope="col">Importacion</th>
                        <th scope="col">Proveedor</th>
                        <th scope="col">Producto</th>
                        <th scope="col">Documento</th>
                        <th scope="col">Valor</th>
                        <th scope="col">Pagado</th>
                        <th scope="col">Saldo</th>
                        <th scope="col">ETA</th>
                        <th scope="col">Observacion</th>
                    </tr>
                    <tr id="total_final2">
                        <td id="total_final">TOTAL</td>
                        <td></td>
                        <td></td>
                        <td></td>
                        <td id="data5">${{ number_format($total, 2, '.', ',') }}</td>
                        <td>${{ number_format($total_pagado, 2, '.', ',') }}</td>
                        <td>${{ number_format($total_saldo, 2, '.', ',') }}</td>
                        <td></td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>

    <script>
        $(document).ready(function() {
            $.fn.dataTable.moment('DD/MM/YYYY');
            $('#compras-table').dataTable({
                "paging": false,
                "order": [
                    [0, "desc"]
                ],
                dom: 'Bfrtip',
                buttons: [
                    'excel', 'print'
                ]
            });
        });
    </script>
@endsection
