<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateProduccionTallasTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('produccion_tallas', function (Blueprint $table) {
            $table->id();
            $table->string('descripcion')->nullable();
            $table->integer('cantidad');
            $table->tinyInteger('estado')->default(1); // Assuming 1 for active, 0 for inactive
            $table->tinyInteger('tipo')->nullable();
            $table->unsignedBigInteger('talla_id')->nullable();
            $table->unsignedBigInteger('linea_id')->nullable();
            $table->unsignedBigInteger('encargado_id')->nullable();
            $table->timestamps();
            $table->softDeletes();

            // Foreign keys
            $table->foreign('talla_id')->references('id')->on('catalogo');
            $table->foreign('linea_id')->references('id')->on('catalogo');
            $table->foreign('encargado_id')->references('id')->on('users');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('produccion_tallas');
    }
}
