<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateOrdenCortesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('orden_cortes', function (Blueprint $table) {
            $table->id();
            $table->string('correlativo')->nullable();
            $table->string('marca');
            $table->string('cortador');
            $table->string('tendedor');
            $table->integer('lienzos');
            $table->float('ancho');
            $table->float('largo_trazo');
            $table->float('consumo');
            $table->float('yardas_utilizar');
            $table->dateTime('inicio_tendido')->nullable();
            $table->dateTime('fin_tendido')->nullable();
            $table->dateTime('inicio_corte')->nullable();
            $table->dateTime('fin_corte')->nullable();
            $table->tinyInteger('estado')->default(1);
            $table->string('imagen')->nullable();
            $table->unsignedBigInteger('linea_negocio_id');
            $table->unsignedBigInteger('color_id');
            $table->unsignedBigInteger('estilo_id');
            $table->unsignedBigInteger('cliente_id');
            $table->timestamps();
            $table->softDeletes();

            // // Definir las llaves foráneas
            // $table->foreign('linea_negocio_id')->references('id')->on('linea_negocios')->onDelete('cascade');
            $table->foreign('color_id')->references('id')->on('catalogo')->onDelete('cascade');
            $table->foreign('estilo_id')->references('id')->on('catalogo')->onDelete('cascade');
            $table->foreign('cliente_id')->references('id')->on('catalogo')->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('orden_cortes');
    }
}
