<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInventariosTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inventarios', function (Blueprint $table) {
            $table->id();
            $table->string('correlativo');
            $table->string('descripcion');
            $table->string('po');
            $table->string('observaciones');
            $table->tinyInteger('estado');
            $table->boolean('reclamo');
            $table->dateTime('fecha_ingreso');
            $table->unsignedBigInteger('cliente_id');
            $table->unsignedBigInteger('linea_negocio_id');
            $table->unsignedBigInteger('tipo_inventario_id');
            $table->foreign('cliente_id')->references('id')->on('clientes');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inventarios');
    }
}
