<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class TrazabilidadProduccion extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'trazabilidad_produccion';
    protected $fillable = [
        'producto',
        'estilo',
        'descripcion',
        'meta_curva',
        'produccion',
        'smv',
        'operarios',
        'minutos',
        'meta',
        'curva_porcentaje',
        'po',
        'estado',
        'tipo',
        'linea_id'
    ];

    public function linea()
    {
        return $this->belongsTo(LineaProduccion::class, 'linea_id');
    }
}
