<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenProduccionDetalle extends Model
{
    use HasFactory, SoftDeletes;
    protected $table = 'orden_produccion_detalle';

    protected $fillable = [
        'genero',
        'talla',
        'personalizacion',
        'bordados',
        'serigrafia',
        'sublimacion',
        'color',
        'ilustraciones_prenda',
        'logos_prenda',
        'orden_produccion_id',
    ];

    protected $casts = [
        'logos_prenda' => 'array',
        'ilustraciones_prenda' => 'array',
    ];

    public function orden_produccion()
    {
        return $this->belongsTo('App\OrdenProduccion', 'id', 'orden_produccion_id');
    }
}
