<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class OrdenProduccion extends Model
{
    //
    protected $table = 'orden_produccion';

    public function cliente(){
        return $this->hasOne('App\Cliente', 'id', 'id_cliente')->with('info_ejecutivo');
    }
    public function producto(){
        return $this->hasOne('App\Producto', 'id', 'id_producto')->with('medida');
    }
    public function almacen_inventario(){
        return $this->hasMany('App\IngresoAlmacen', 'id_producto', 'id_producto');
    }
    public function ordenes_paciales(){
        return $this->hasMany('App\OrdenProduccionParcial', 'id_op', 'id');
    }
    public function cotizaciones_p(){
        return $this->hasOne('App\CotizacionProductos', 'id', 'id_cotizacion_producto');
    }

    public function detalle(){
        return $this->hasOne('App\OrdenProduccionDetalle', 'orden_produccion_id', 'id');
    }
}
