<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenCorteDetalle extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'rollos',
        'lote',
        'yardas',
        'lienzos',
        'yardas_tendidas',
        'puntas',
        'unidad_medida_id',
        'tipo_defecto_id',
        'puntas_utilizadas',
        'sobrantes',
        'faltantes',
        'empalmes',
        'observaciones',
        'orden_corte_id',
    ];

    // Definir las relaciones
    public function unidadMedida()
    {
        return $this->belongsTo(ProductoMedidas::class);
    }

    public function tipoDefecto()
    {
        return $this->belongsTo(CatalogoCampo::class);
    }

    public function ordenCorte()
    {
        return $this->belongsTo(OrdenCorte::class);
    }
}
