<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class OrdenCorte extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'correlativo',
        'cortador',
        'tendedor',
        'lienzos',
        'ancho',
        'consumo',
        'yardas_utilizar',
        'marca',
        'largo_trazo',
        'inicio_tendido',
        'fin_tendido',
        'inicio_corte',
        'fin_corte',
        'estado',
        'imagen',
        'linea_negocio_id',
        'color_id',
        'estilo_id',
        'cliente_id',
    ];

    // Definir las relaciones
    public function color()
    {
        return $this->belongsTo(CatalogoCampo::class);
    }

    public function estilo()
    {
        return $this->belongsTo(CatalogoCampo::class);
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }

    public function detalle()
    {
        return $this->hasMany(OrdenCorteDetalle::class);
    }
}
