<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LineaProduccion extends Model
{
    use HasFactory;
    protected $table = 'lineas_produccion';
    protected $fillable = [
        'descripcion',
        'nombre',
        'encargado_id'
    ];

    public function encargado()
    {
        return $this->belongsTo(User::class, 'encargado_id');
    }

    public function produccionTallas()
    {
        return $this->hasMany(ProduccionTalla::class, 'linea_id');
    }

    public function trazabilidadProduccion()
    {
        return $this->hasMany(TrazabilidadProduccion::class, 'linea_id');
    }
}
