<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Inventario extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'correlativo',
        'descripcion',
        'po',
        'observaciones',
        'estado',
        'reclamo',
        'fecha_ingreso',
        'imagen',
        'cliente_id',
        'linea_negocio_id',
        'tipo_inventario_id',
    ];

    public function detalle()
    {
        return $this->hasMany(InventarioDetalle::class)->orderBy('id', 'asc');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class);
    }
}
