<?php

namespace App\Http\Controllers;
//controladores

use App\User;
use App\Cliente;
use App\Maquinas;
use App\Producto;
use Carbon\Carbon;
use App\OrdenCorte;
use App\CatalogoCampo;
use App\LineaProduccion;
use App\OrdenProduccion;
use App\ProduccionTalla;
use App\ProductoMedidas;
use App\OrdenCorteDetalle;
use App\ReporteMaquinaria;
use Illuminate\Http\Request;
use App\ReporteMaquinaGeneral;
use App\OrdenProduccionParcial;
use App\TrazabilidadProduccion;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;


class FabricacionController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $ops = OrdenProduccion::where('status', '>=', 2)->where('status', '!=', 5)->with('cliente')->with('producto')->with('ordenes_paciales')->get();
        $opsInventario = OrdenProduccion::where('status', 1)->where('id_cliente', 999999)->with('cliente')->with('producto')->get();
        //dd($opsInventario);
        return view('fabricacion.dashboard', compact('ops', 'opsInventario'));
    }

    public function reporteMaquina()
    {
        $maquinas = Maquinas::orderBy('created_at', 'asc')->get();
        $medidas = ProductoMedidas::all();
        return view('fabricacion.reporte_maquina', compact('maquinas', 'medidas'));
    }

    public function crearMaquina(Request $request)
    {
        $maquina = new Maquinas;
        $maquina->maquina = $request->nombre_maquina;
        $maquina->save();

        $maquinas = Maquinas::all();
        return redirect()->route('fabricacion.reporte', compact('maquinas'))->with('mensaje', 'Proceso exitoso');
    }


    public function reporteMaquinas(Request $request)
    {
        // Validar datos si es necesario
        $request->validate([
            'id_maquina.*' => 'required',
            'trabajo.*' => 'required',
            'medida.*' => 'required',
            'cantidad.*' => 'required',
            'horas.*' => 'required',
            'minutos.*' => 'required',
            'id_usuario.*' => 'required',
            'fecha.*' => 'required|date',
            'observacion.*' => 'nullable', // Otra validación según tus requisitos
        ]);

        // Extraer datos del formulario
        $data = $request->only(['id_maquina', 'trabajo', 'medida', 'cantidad', 'horas', 'id_usuario', 'fecha', 'observacion']);

        // Preparar datos para la inserción masiva
        $reportes = [];
        $count = count($data['id_maquina']);

        for ($i = 0; $i < $count; $i++) {
            $reportes[] = [
                'id_maquina' => isset($data['id_maquina'][$i]) ? $data['id_maquina'][$i] : null,
                'trabajo' => isset($data['trabajo'][$i]) ? $data['trabajo'][$i] : null,
                'medida' => isset($data['medida'][$i]) ? $data['medida'][$i] : null,
                'cantidad' => isset($data['cantidad'][$i]) ? $data['cantidad'][$i] : null,
                'horas' => isset($data['horas'][$i]) ? $data['horas'][$i] : null,
                'minutos' => isset($data['minutos'][$i]) ? $data['minutos'][$i] : null,
                'usuario' => isset($data['usuario'][$i]) ? $data['usuario'][$i] : null,
                'fecha' => $request->fecha,
                'observacion' => isset($data['observacion'][$i]) ? $data['observacion'][$i] : null,
            ];
        }

        // Insertar registros en la base de datos
        ReporteMaquinaria::insert($reportes);

        $reporteGeneral = new ReporteMaquinaGeneral;
        $reporteGeneral->observacion = $request->general;
        $reporteGeneral->fecha = $request->fecha;
        $reporteGeneral->save();

        $maquinas = Maquinas::all();
        return redirect()->route('fabricacion.historico_reporte', compact('maquinas'))->with('mensaje', 'Proceso exitoso');
    }




    public function editReporteMaquinas(Request $request)
    {
        $maquina = ReporteMaquinaria::find($request->id);

        $maquina->trabajo = $request->trabajo;
        $maquina->medida = $request->medida;
        $maquina->cantidad = $request->cantidad;
        $maquina->horas = $request->horas;
        $maquina->fecha = $request->fecha;
        $maquina->save();

        return view('fabricacion.reporte_maquina');
    }

    public function historicoReportes()
    {
        $fechaAyer = Carbon::yesterday();
        $reportes = DB::table('reporte_maquina')
            ->join('maquinas', 'reporte_maquina.id_maquina', '=', 'maquinas.id')
            ->select(
                'maquinas.created_at',
                'reporte_maquina.id_maquina',
                'reporte_maquina.trabajo',
                'reporte_maquina.medida',
                'reporte_maquina.observacion',
                DB::raw('SUM(reporte_maquina.horas) as total_horas'),
                DB::raw('SUM(reporte_maquina.minutos) as total_minutos'),
                DB::raw('SUM(reporte_maquina.cantidad) as total_cantidad')
            )
            ->whereDate('reporte_maquina.fecha', '=', $fechaAyer)
            ->groupBy('reporte_maquina.id_maquina', 'reporte_maquina.trabajo', 'reporte_maquina.medida', 'reporte_maquina.observacion', 'maquinas.created_at')
            ->orderBy('maquinas.created_at', 'asc')
            ->get();

        $reportesGeneral = ReporteMaquinaGeneral::whereDate('fecha', '=', $fechaAyer)->get();

        return view('fabricacion.historico_maquinaria', compact('reportes', 'reportesGeneral', 'fechaAyer'));
    }

    public function historicoReportesMes()
    {

        $fechaInicio = Carbon::now()->subMonth()->startOfMonth();
        $fechaFin = Carbon::now()->subMonth()->endOfMonth();

        $reportes = DB::table('reporte_maquina')
            ->select('id_maquina', DB::raw('SUM(horas) as total_horas'), DB::raw('SUM(minutos) as total_minutos'), DB::raw('SUM(cantidad) as total_cantidad'))
            ->whereBetween('fecha', [$fechaInicio, $fechaFin])
            ->groupBy('id_maquina')
            ->get();


        return view('fabricacion.historico_maquinaria_mes', compact('reportes', 'fechaInicio', 'fechaFin'));
    }

    public function historicoReportesPost(Request $request)
    {
        $fechaAyer = $request->date;

        $reportes = DB::table('reporte_maquina')
            ->select('id_maquina', 'trabajo', 'medida', 'medida', 'observacion', DB::raw('SUM(horas) as total_horas'), DB::raw('SUM(minutos) as total_minutos'), DB::raw('SUM(cantidad) as total_cantidad'))
            ->whereDate('fecha', '=', $fechaAyer)
            ->groupBy('id_maquina')
            ->get();
        $reportesGeneral = ReporteMaquinaGeneral::whereDate('fecha', '=', $fechaAyer)->get();
        return view('fabricacion.historico_maquinaria', compact('reportes', 'reportesGeneral', 'fechaAyer'));
    }

    public function ordenProduccion($id)
    {
        //
        $op = OrdenProduccion::where('id', $id)->with('cliente')->with('producto')->first();
        $opParciales = OrdenProduccionParcial::where('id_op', $id)->with('op')->get();
        $acumulado = 0;
        return view('fabricacion.orden_produccion', compact('op', 'opParciales', 'acumulado'));
    }
    public function actualizarOP(Request $request, OrdenProduccion $op)
    {
        //        
        $op->id_usuario =  Auth::id();
        $op->id_cliente = $request->id_cliente;
        $op->id_producto = $request->id_producto;
        $op->cantidad = $request->cantidad;
        $op->lista_materiales = $request->lista_materiales;
        $op->condiciones_entrega = $request->condiciones_entrega;
        $op->fecha_prevista = date("Y-m-d", strtotime($request->fecha_prevista));
        $op->fecha_entrega = date("Y-m-d", strtotime($request->fecha_entrega));
        $op->id_cotizacion = $request->id_cotizacion;
        $op->id_cotizacion_producto = $request->id_cotizacion_producto;
        $op->kgs_millar = $request->kgs_millar;
        $op->kgs_procesar = $request->kgs_procesar;
        $op->numero_oc = $request->numero_oc;
        $op->micras = $request->micras;
        $op->caracteristicas = $request->caracteristicas;
        $op->observaciones = $request->observaciones;
        $op->status = 3;
        $op->inventario = $request->inventario;
        $op->update();

        $arrResponse = [
            'message' => 'Orde de Producción actualizada correctamente'
        ];
        //return redirect()->route('fabricacion.dashboard')->with($arrResponse);


        $arrResponse = [
            'message' => 'Orde de Producción actualizada correctamente'
        ];
        //al actualizar regresa a la misma orden de produccion.
        //
        $opParciales = OrdenProduccionParcial::where('id_op', $op->id)->with('op')->get();
        $acumulado = 0;
        return view('fabricacion.orden_produccion', compact('op', 'opParciales', 'acumulado'))->with($arrResponse);
    }

    public function parcialOP(Request $request)
    {
        //
        $ordenProduccionP = new OrdenProduccionParcial();
        $ordenProduccionP->id_op = $request->idOP;
        $ordenProduccionP->id_producto = $request->id_producto;
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->status = 1;
        $ordenProduccionP->save();
        return response($ordenProduccionP);
    }
    public function parcialOPEditar(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->update();
        return response($ordenProduccionP);
    }
    public function parcialOPActualizar(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->cantidad = $request->cantidad;
        $ordenProduccionP->observaciones = $request->descripcion;
        $ordenProduccionP->status = 1;
        $ordenProduccionP->update();
        return response($ordenProduccionP);
    }
    public function rechazarEntregaParcial(Request $request)
    {
        //


        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->status = 99;
        $ordenProduccionP->obseervacion_almacen = $request->rechazo;
        $ordenProduccionP->update();
        $idOP = $ordenProduccionP->id_op;

        Mail::send('email.rechazo', compact('ordenProduccionP'), function ($message) use ($idOP) {
            $message->from('info@laravelrp.com', 'Concisa OP ' . $idOP);
            $message->to('danny.concisa@gmail.com');
            $message->to('anylopeza3@gmail.com');
            $message->to('erickfernando85@gmail.com');
            //$message->to('erickfernando85@gmail.com');
            $message->subject('Rechazo de entrega - OP' . $idOP);
        });
        return response($ordenProduccionP);
    }

    public function eliminarEntregaParcial(Request $request)
    {
        //
        $ordenProduccionP = OrdenProduccionParcial::where('id', $request->idOP)->first();
        $ordenProduccionP->delete();
        return response($ordenProduccionP);
    }

    public function ordenProduccionTerminar($id)
    {
        //      
        //Buscar ordenes parciales
        $opParcialCantidad = OrdenProduccionParcial::where('id_op', $id)->sum('cantidad');
        $op = OrdenProduccion::where('id', $id)->first();
        $op->status = 4;
        $op->update();

        $arrResponse = [
            'message' => 'Orde de Producción terminada correctamente'
        ];
        return redirect()->route('fabricacion.dashboard')->with($arrResponse);
    }


    // CORTE
    public function dashboardCorte()
    {
        $ordenes_corte = OrdenCorte::with('cliente')->get();
        return view('fabricacion.dashboard_corte', compact('ordenes_corte'));
    }

    public function nuevoCorte()
    {
        $unidades_medida = ProductoMedidas::all();
        $tipo_defectos = CatalogoCampo::where('tipo_campo', 4)->get();
        $colores = CatalogoCampo::where('tipo_campo', 1)->get();
        $estilos = CatalogoCampo::where('tipo_campo', 3)->get();
        $clientes = Cliente::all();
        return view('fabricacion.nuevo_corte', compact('clientes', 'unidades_medida', 'tipo_defectos', 'estilos', 'colores'));
    }

    public function detalleCorte($corte_id)
    {
        $unidades_medida = ProductoMedidas::all();
        $tipo_defectos = CatalogoCampo::where('tipo_campo', 4)->get();
        $colores = CatalogoCampo::where('tipo_campo', 1)->get();
        $estilos = CatalogoCampo::where('tipo_campo', 3)->get();
        $corte = OrdenCorte::where('id', $corte_id)->with('cliente')->with('color')->with('estilo')->with('detalle')->first();
        return view('fabricacion.detalle_corte', compact('corte', 'unidades_medida', 'tipo_defectos', 'estilos', 'colores'));
    }

    public function actualizarCorte(Request $request)
    {
        DB::beginTransaction();

        try {
            // Buscar la OrdenCorte existente o crear una nueva si no existe
            if ($request->has('orden_corte_id') && $request->orden_corte_id) {
                $ordenCorte = OrdenCorte::findOrFail($request->orden_corte_id);
            } else {
                $ordenCorte = new OrdenCorte();
            }

            // Actualizar o llenar los campos del modelo principal
            $ordenCorte->fill($request->only([
                'linea_negocio_id',
                'cliente_id',
                'cortador',
                'tendedor',
                'estilo_id',
                'marca',
                'consumo',
                'yardas_utilizar',
                'color_id',
                'ancho',
                'largo_trazo',
                'inicio_tendido',
                'fin_tendido',
                'inicio_corte',
                'fin_corte',
            ]));

            $ordenCorte->lienzos = $request->lienzos_general;
            $ordenCorte->save();

            // Obtener los IDs de los detalles actuales
            $currentDetailIds = $ordenCorte->detalle->pluck('id')->toArray();

            // IDs recibidos en la solicitud
            $receivedDetailIds = $request->ids ?? [];

            // Identificar los IDs para eliminar
            $idsToDelete = array_diff($currentDetailIds, $receivedDetailIds);

            // Eliminar detalles que no están en la solicitud
            OrdenCorteDetalle::destroy($idsToDelete);

            // Procesar los detalles
            foreach ($request->rollos as $index => $rollo) {
                $detalleId = $request->ids[$index] ?? null;

                // Si el detalle ya existe, actualizarlo
                if ($detalleId) {
                    $detalle = OrdenCorteDetalle::find($detalleId);
                    $detalle->update([
                        'rollos' => $rollo,
                        'lote' => $request->lote[$index],
                        'lienzos' => $request->lienzos[$index],
                        'unidad_medida_id' => $request->medida_id[$index],
                        'yardas' => $request->yardas_etiqueta[$index],
                        'yardas_tendidas' => $request->yardas_tendidas[$index],
                        'tipo_defecto_id' => $request->tipo_defecto_id[$index],
                        'puntas' => $request->puntas[$index],
                        'puntas_utilizadas' => $request->puntas_utilizadas[$index],
                        'sobrantes' => $request->sobrantes[$index],
                        'faltantes' => $request->faltantes[$index],
                        'empalmes' => $request->empalmes[$index],
                        'observaciones' => $request->observaciones[$index],
                    ]);
                } else {
                    // Si el detalle no existe, crearlo
                    OrdenCorteDetalle::create([
                        'rollos' => $rollo,
                        'lote' => $request->lote[$index],
                        'lienzos' => $request->lienzos[$index],
                        'unidad_medida_id' => $request->medida_id[$index],
                        'yardas' => $request->yardas_etiqueta[$index],
                        'yardas_tendidas' => $request->yardas_tendidas[$index],
                        'tipo_defecto_id' => $request->tipo_defecto_id[$index],
                        'puntas' => $request->puntas[$index],
                        'puntas_utilizadas' => $request->puntas_utilizadas[$index],
                        'sobrantes' => $request->sobrantes[$index],
                        'faltantes' => $request->faltantes[$index],
                        'empalmes' => $request->empalmes[$index],
                        'observaciones' => $request->observaciones[$index],
                        'orden_corte_id' => $ordenCorte->id,
                    ]);
                }
            }

            DB::commit();
            return redirect()->route('fabricacion.dashboard_corte')->with('success', 'Orden de Corte actualizada correctamente');
        } catch (\Throwable $th) {
            DB::rollBack();
            return redirect()->route('fabricacion.dashboard_corte')->with('error', 'Error al actualizar la Orden de Corte');
        }
    }


    // FIN CORTE


    // TRAZABILIDAD PRODUCCION
    public function dashboardTrazabilidad()
    {
        $lineas = LineaProduccion::all();
        $producciones = TrazabilidadProduccion::where('estado', 1)->with('linea')->get();

        foreach ($producciones as $produccion) {
            // Obtener la fecha de created_at de $produccion sin la hora
            $fechaProduccion = $produccion->created_at->format('Y-m-d');

            // Sumar el total de 'cantidad' de la tabla produccion_tallas
            $producido = ProduccionTalla::where('linea_id', $produccion->linea_id)
                ->whereDate('created_at', $fechaProduccion)
                ->sum('cantidad');

            // Asignar el valor de $producido a $produccion
            $produccion->setAttribute('producido', $producido);
        }

        return view('fabricacion.dashboard_trazabilidad', compact('producciones', 'lineas'));
    }

    public function guardarTrazabilidad(Request $request)
    {
        if ($request->trazabilidad_id) {
            $produccion = TrazabilidadProduccion::find($request->trazabilidad_id);
        } else {
            $produccion = new TrazabilidadProduccion;
        }

        $produccion->estilo = $request->estilo;
        $produccion->smv = $request->smv;
        $produccion->operarios = $request->operarios;
        $produccion->minutos = $request->minutos;
        $produccion->curva_porcentaje = $request->curva_porcentaje;
        $produccion->po = $request->po;
        $produccion->linea_id = $request->linea_id;
        $produccion->created_at = $request->fecha;
        $produccion->save();

        $arrayResponse = [
            'message' => 'Producción registrada correctamente'
        ];

        return redirect()->route('fabricacion.dashboard_trazabilidad')->with($arrayResponse);
    }

    public function anularTrazabilidad($id)
    {
        $produccion = TrazabilidadProduccion::find($id);

        if (!$produccion) {
            return response()->json([
                'success' => false,
                'message' => 'Producción no encontrada'
            ], 404);
        }

        $produccion->estado = 2;
        $produccion->save();

        return response()->json([
            'success' => true,
            'message' => 'Producción anulada correctamente'
        ]);
    }
    public function filtrarTrazabilidad(Request $request)
    {
        $query = TrazabilidadProduccion::query();

        if ($request->filled('fecha_inicio') && $request->filled('fecha_fin')) {
            $query->whereBetween('created_at', [$request->fecha_inicio, $request->fecha_fin]);
        }

        if ($request->filled('linea_id')) {
            $query->where('linea_id', $request->linea_id);
        }

        $query->where('estado', 1);

        $producciones = $query->get();
        $lineas = LineaProduccion::all();

        foreach ($producciones as $produccion) {
            // Obtener la fecha de created_at de $produccion sin la hora
            $fechaProduccion = $produccion->created_at->format('Y-m-d');

            // Sumar el total de 'cantidad' de la tabla produccion_tallas
            $producido = ProduccionTalla::where('linea_id', $produccion->linea_id)
                ->whereDate('created_at', $fechaProduccion)
                ->sum('cantidad');

            // Asignar el valor de $producido a $produccion
            $produccion->setAttribute('producido', $producido);
        }

        return view('fabricacion.dashboard_trazabilidad', compact('producciones', 'lineas'));
    }

    // FIN TRAZABILIDAD PRODUCCION

    // PRODUCCION TALLA
    public function dashboardProduccionTalla()
    {
        $tallas = CatalogoCampo::where('tipo_campo', 2)->get();
        $lineas = LineaProduccion::all();
        $producciones = ProduccionTalla::where('estado', 1)->with('talla')->with('linea')->get();
        $productos = Producto::orderBy('id', 'asc')->limit(5)->get();
        return view('fabricacion.dashboard_produccion_talla', compact('producciones', 'lineas', 'tallas', 'productos'));
    }

    public function guardarProduccionTalla(Request $request)
    {
        // Validar que los arrays de cantidades y tallas estén presentes y sean del mismo tamaño
        $request->validate([
            'cantidades' => 'required|array',
            'tallas' => 'required|array',
            'cantidades.*' => 'required|numeric',
            'tallas.*' => 'required',
            'linea_id' => 'required',
            'fecha' => 'required|date',
        ]);

        $lineaId = $request->linea_id;
        $cantidades = $request->cantidades;
        $tallas = $request->tallas;
        $fecha = $request->fecha;

        // Guardar cada par cantidad-talla como un nuevo registro
        foreach ($cantidades as $index => $cantidad) {
            $produccion = new ProduccionTalla;
            $produccion->cantidad = $cantidad;
            $produccion->talla_id = $tallas[$index];
            $produccion->linea_id = $lineaId;
            $produccion->created_at = $fecha;
            $produccion->save();
        }

        $arrayResponse = [
            'message' => 'Producción registrada correctamente'
        ];

        return redirect()->route('fabricacion.dashboard_produccion_talla')->with($arrayResponse);
    }


    public function anularProduccionTalla($id)
    {
        $produccion = ProduccionTalla::find($id);

        if (!$produccion) {
            return response()->json([
                'success' => false,
                'message' => 'Producción no encontrada'
            ], 404);
        }

        $produccion->estado = 2;
        $produccion->save();

        return response()->json([
            'success' => true,
            'message' => 'Producción anulada correctamente'
        ]);
    }

    public function filtrarProduccionTalla(Request $request)
    {
        $query = ProduccionTalla::query();

        if ($request->filled('fecha_inicio') && $request->filled('fecha_fin')) {
            $query->whereBetween('created_at', [$request->fecha_inicio, $request->fecha_fin]);
        }

        if ($request->filled('linea_id')) {
            $query->where('linea_id', $request->linea_id);
        }

        if ($request->filled('producto_id')) {
            $query->where('producto_id', $request->producto_id);
        }

        if ($request->filled('estado')) {
            if ($request->estado == '1') {
                $query->where('estado', 1); // Activo
            } elseif ($request->estado == '2') {
                $query->where('estado', 2); // Anulado
            }
        }

        $tallas = CatalogoCampo::where('tipo_campo', 2)->get();
        $producciones = $query->get();
        $lineas = LineaProduccion::all();
        $encargados = User::where('role', 4)->get();
        $productos = Producto::orderBy('id', 'asc')->limit(5)->get();

        return view('fabricacion.dashboard_produccion_talla', compact('producciones', 'lineas', 'encargados', 'tallas', 'productos'));
    }

    // FIN PRODUCCION TALLA
}
