<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\SalidaAlmacen;
use App\CotizacionProductos;
use App\Cliente;
use App\Producto;
use App\Facturas;
use App\ReciboCaja;
use App\ReciboCajaFactura;
use App\NotaDebito;
use App\Cotizacion;
use App\Ajustes;
use PDF;
use DateTime;
use Illuminate\Support\Facades\Mail;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class ContabilidadController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth');
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
        $salidasAlmacen = SalidaAlmacen::where('estatus', 2)->with('cliente')->with('producto')->with('op')->with('cotizacion')->get();
        return view('contabilidad.dashboard', compact('salidasAlmacen'));
    }
    public function dashBoardSolicitudFactura()
    {
        //
        $salidasAlmacen = SalidaAlmacen::where('estatus', 6)->with('cliente')->with('producto')->with('op')->with('cotizacion')->get();
        return view('contabilidad.dashboard_solicitud_facturar', compact('salidasAlmacen'));
    }

    //reporte para mail diario
    public function reportePendienteFacturar()
    {
        $salidasAlmacen = SalidaAlmacen::where('estatus', 6)->with('cliente')->with('producto')->with('op')->with('cotizacion')->get();
        return view('contabilidad.dashboard_solicitud_facturar_reporte', compact('salidasAlmacen'));
    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
    public function mesGT($mesBuscar)
    {
        if ($mesBuscar == 1) {
            $mes = 'enero';
        }
        if ($mesBuscar == 2) {
            $mes = 'febrero';
        }
        if ($mesBuscar == 3) {
            $mes = 'marzo';
        }
        if ($mesBuscar == 4) {
            $mes = 'abril';
        }
        if ($mesBuscar == 5) {
            $mes = 'mayo';
        }
        if ($mesBuscar == 6) {
            $mes = 'junio';
        }
        if ($mesBuscar == 7) {
            $mes = 'julio';
        }
        if ($mesBuscar == 8) {
            $mes = 'agosto';
        }
        if ($mesBuscar == 9) {
            $mes = 'septiembre';
        }
        if ($mesBuscar == 10) {
            $mes = 'octubre';
        }
        if ($mesBuscar == 11) {
            $mes = 'noviembre';
        }
        if ($mesBuscar == 12) {
            $mes = 'diciembre';
        }
        return $mes;
    }
    public function factura($idSalida)
    {
        //
        $cotizacion = SalidaAlmacen::where('id', $idSalida)->with('cliente')->with('producto')->with('cotizacion')->with('op')->first();
        //dd($cotizacion);
        return view('contabilidad.factura', compact('cotizacion', 'idSalida'));
    }
    public function solicitudFactura(Request $request)
    {

        foreach ($request->crear_facturas as $id_salida) {
            $salida = SalidaAlmacen::where('id', $id_salida)->first();
            $salida->estatus =  6;
            $salida->update();
        }


        $arrResponse = [
            'message' => 'Solicitud de factura creada'
        ];
        return redirect()->route('contabilidad.dashboard')->with($arrResponse);
    }
    public function facturaNueva()
    {
        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        return view('contabilidad.nueva_factura', compact('clientes'));
    }
    public function archivarSalida(Request $request)
    {
        $salida = SalidaAlmacen::where('id', $request->id)->first();
        $salida->observacion_archivada =  $request->mensaje;
        $salida->estatus =  5;
        $salida->update();

        $salidasAlmacen = SalidaAlmacen::where('estatus', 2)->with('cliente')->with('producto')->get();
        return view('contabilidad.dashboard', compact('salidasAlmacen'));
    }
    public function guardarFactura(Request $request)
    {
        //Guardar Factura
        $imageName = $request->numero_factura . '.' . $request->pdf_factura->extension();
        $factura_image = $request->pdf_factura->move(public_path('facturas'), $imageName);
        $path = url('/facturas') . '/' . $imageName;

        $factura = new Facturas();
        $factura->id_usuario =  Auth::id();
        $factura->id_cliente = $request->id_cliente;
        $factura->id_op = $request->id_op;
        $factura->id_producto = $request->id_producto;
        $factura->id_salida = $request->id_salida;
        $factura->cantidad = $request->cantidad;
        $factura->precio = $request->precio;
        $factura->total = $request->total;
        $factura->no_sat = $request->numero_factura ?? '';
        $factura->nombre_img = $imageName;
        $factura->estatus = 1;
        $factura->save();

        $cliente = Cliente::where('id', $request->id_cliente)->first();
        $referencia = $cliente->referencia ?? '';
        $info = [
            'nombre_contacto' => $cliente->nombre_contacto,
            'id' => $factura->id,
            'sat' => $request->numero_factura ?? '',
            'url' => $path,
        ];


        $salida = SalidaAlmacen::where('id', $request->id_salida)->first();
        $salida->estatus =  3;
        $salida->update();

        $arrResponse = [
            'message' => 'Factura creada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard')->with($arrResponse);
    }
    public function guardarFacturaNueva(Request $request)
    {
        //Guardar Factura
        $imageName = $request->numero_factura . '.' . $request->pdf_factura->extension();
        $factura_image = $request->pdf_factura->move(public_path('facturas'), $imageName);
        $path = url('/facturas') . '/' . $imageName;

        $factura = new Facturas();
        $factura->id_usuario =  Auth::id();
        $factura->id_cliente = $request->cliente;
        $factura->id_op = 9999999;
        $factura->id_producto = 0;
        $factura->id_salida = 0;
        $factura->cantidad = 0;
        $factura->precio = 0;
        $factura->total = $request->total;
        $factura->no_sat = $request->numero_factura ?? '';
        $factura->estatus = 1;
        $factura->save();

        $cliente = Cliente::where('id', $request->cliente)->first();
        $referencia = $cliente->referencia ?? '';
        $info = [
            'nombre_contacto' => $cliente->nombre_contacto,
            'id' => $factura->id,
            'sat' => $request->numero_factura ?? '',
            'url' => $path,
        ];
        $arrResponse = [
            'message' => 'Factura creada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard')->with($arrResponse);
    }
    public function verReciboCaja($id_recibo)
    {
        //dd($id_recibo);
        $recibo_caja = ReciboCaja::where('id', $id_recibo)->with('cliente')->with('facturas')->first();
        //dd($recibo_caja);



        //$recibo_caja_fac=ReciboCajaFactura::where('id_factura',$recibo_caja->facturas->id_factura)->with('ver_recibo')->get();
        //dd($recibo_caja_fac);
        return view('contabilidad.ver_recibo_caja_v2', compact('recibo_caja'));
    }

    public function guardarReciboCaja(Request $request)
    {

        $recibo_caja = new ReciboCaja();
        $recibo_caja->id_usuario =  Auth::id();
        $recibo_caja->id_cliente = $request->id_cliente;
        $recibo_caja->id_total = $request->total_total;
        $recibo_caja->recibo_caja_numero = $request->numero_recibo_caja;
        $recibo_caja->fecha_ingreso = date("Y-m-d", strtotime($request->fecha_ingreso));
        $recibo_caja->observacion = $request->observacion_rc;
        $recibo_caja->saldo_favor = $request->saldo_favor ?? 0;
        $recibo_caja->save();
        foreach ($request->factura as $key => $id_factura) {
            // $verificar_total=floatval($request->total_factura[$key])-floatval($request->total[$key]); original
            $verificar_total = $request->total[$key] >= $request->total_factura[$key] ? 0 : floatval($request->total_factura[$key]) - floatval($request->total[$key]);
            $recibo_caja_factura = new ReciboCajaFactura();
            $recibo_caja_factura->id_recibo_caja =  $recibo_caja->id;
            $recibo_caja_factura->id_cliente = $request->id_cliente;
            $recibo_caja_factura->id_factura = $request->factura[$key];
            $recibo_caja_factura->id_factura_sat = $request->factura_sat[$key];
            $recibo_caja_factura->total_factura = $request->total_factura[$key];
            $recibo_caja_factura->abono = $verificar_total;
            $recibo_caja_factura->total_cancelar = $request->total[$key] ?? 0;
            $recibo_caja_factura->numero_cheque = $request->cheques[$key] ?? 0;
            $recibo_caja_factura->cheque_q = $request->chequesq[$key] ?? 0;
            $recibo_caja_factura->efectivo = $request->efectivo[$key] ?? 0;
            $recibo_caja_factura->retencion = $request->retencion[$key] ?? 0;
            $recibo_caja_factura->save();
            if ($verificar_total <= 0) {
                $factura = Facturas::where('id', $request->factura[$key])->first();
                $factura->id_recibo_caja_factura =  $recibo_caja->id;
                $factura->estatus =  2;
                $factura->update();
            } else {
                $factura = Facturas::where('id', $request->factura[$key])->first();
                $factura->id_recibo_caja_factura =  $recibo_caja->id;
                $factura->abono = $factura->abono + floatval($request->total[$key]);
                $factura->update();
            }
        }

        //Guardar Recibo
        if ($request->imagen_recibo) {
            $imageName = $recibo_caja->id . '.' . $request->imagen_recibo->extension();
            $request->imagen_recibo->move(public_path('recibo_caja'), $imageName);
        } else {
            $imageName = '';
        }
        //Buscar la factura mas antigua
        if ($request->saldo_favor > 0) {
            $factura = Facturas::where('id_cliente', $request->id_cliente)->where('estatus', 1)->first();
            if ($factura) {
                $factura->id_saldo = $recibo_caja->id;
                $factura->saldo_favor = $request->saldo_favor;
                $factura->total = $factura->total - $request->saldo_favor;
                $factura->save();
            } else {
                $cliente = Cliente::where('id', $request->id_cliente)->first();
                $cliente->id_saldo = $recibo_caja->id;
                $cliente->saldo_favor = $request->saldo_favor;
                $cliente->save();
            }
        }
        $recibo_caja->nombre_imagen_recibo =  $imageName;
        $recibo_caja->update();

        $arrResponse = [
            'message' => 'Recibo de caja creada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
    }
    public function reciboCajaFacturaNuevo(Request $request)
    {

        $clientes = Cliente::orderBy('nombre', 'asc')->get();
        return view('contabilidad.generar_recibo_nuevo', compact('clientes'));
    }
    public function guardarReciboCajaNuevo(Request $request)
    {
        DB::beginTransaction();
        try {
            $cantidad_total_recibo = $request->total_total;

            $recibo_caja = new ReciboCaja();
            $recibo_caja->id_usuario =  Auth::id();
            $recibo_caja->id_cliente = $request->cliente;
            $recibo_caja->id_total = $request->total_total;
            $recibo_caja->recibo_caja_numero = $request->numero_recibo_caja;
            $recibo_caja->observacion = $request->observacion_rc;
            $recibo_caja->fecha_ingreso = date("Y-m-d", strtotime($request->fecha_ingreso));
            $recibo_caja->saldo_favor = $request->saldo_favor ?? 0;
            $recibo_caja->save();

            $recibo_caja_factura = new ReciboCajaFactura();
            $recibo_caja_factura->id_recibo_caja =  $recibo_caja->id;
            $recibo_caja_factura->id_cliente = $request->cliente;

            $recibo_caja_factura->id_factura = '';

            $recibo_caja_factura->id_factura_sat = '';
            $recibo_caja_factura->total_factura = 0;
            $recibo_caja_factura->abono = 0;
            $recibo_caja_factura->total_cancelar = $request->total_total;

            $recibo_caja_factura->numero_cheque = $request->cheques ?? 0;
            $recibo_caja_factura->cheque_q = $request->chequesq ?? 0;
            $recibo_caja_factura->efectivo = $request->efectivo ?? 0;
            $recibo_caja_factura->retencion = $request->retencion ?? 0;
            $recibo_caja_factura->save();

            $cliente = Cliente::where('id', $request->cliente)->first();
            //Obtener todas las facturas del cliente
            $facturas = Facturas::where('id_cliente', $request->cliente)->where('estatus', 1)->get();

            foreach ($facturas as $factura) {
                $total_factura = $factura->total - $factura->abono;
                if($total_factura <= $cantidad_total_recibo){
                    $factura->abono += $total_factura;
                    $factura->id_recibo_caja_factura =  $recibo_caja->id;
                    $factura->estatus =  2;
                    $factura->update();
                }else{
                    $factura->id_recibo_caja_factura = $recibo_caja->id;
                    $factura->abono += $cantidad_total_recibo;
                    $factura->update();
                }
                $cantidad_total_recibo -= $total_factura;
            }

            if($cantidad_total_recibo > 0){
                $cliente->saldo_favor += $cantidad_total_recibo;
                $cliente->update();
            }

            $arrResponse = [
                'message' => 'Recibo de caja creada correctamente'
            ];

            DB::commit();

            return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
        } catch (\Throwable $th) {
            DB::rollBack();
            $arrResponse = [
                'message' => 'Error al crear el recibo de caja'
            ];

            return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
        }
    }
    public function guardarReciboCajaEditado(Request $request)
    {
        //dd($request->total_total);
        $recibo_caja = ReciboCaja::where('id', $request->id_recibo_editar)->first();
        $recibo_caja->id_total = $request->total_total ?? 0;
        $recibo_caja->recibo_caja_numero = $request->numero_recibo_caja;
        $recibo_caja->observacion = $request->observacion_rc;
        //dd($recibo_caja);
        $recibo_caja->save();

        $idRecibos = is_array($request->id_recibo) ? $request->id_recibo : [];
        foreach ($idRecibos as $key => $f) {
            $recibo_caja_factura = ReciboCajaFactura::where('id', $f)->first();
            $abono_anterior = $recibo_caja_factura->efectivo + $recibo_caja_factura->cheque_q + $recibo_caja_factura->retencion;
            $total_item = floatval($request->total[$key]);

            //$total_cancelar= ? $recibo_caja_factura->total_factura : $recibo_caja_factura->total_factura;
            if (floatval($recibo_caja_factura->total_factura) <= $total_item) {
                $recibo_caja_factura->abono = 0;
            } else {
                $recibo_caja_factura->abono = $total_item;
            }
            if (floatval($recibo_caja_factura->total_factura) <= $total_item) {
                $recibo_caja_factura->total_cancelar = $recibo_caja_factura->total_factura;
            } else {
                $recibo_caja_factura->total_cancelar = $recibo_caja_factura->total_factura - $total_item;
            }
            $recibo_caja_factura->numero_cheque = $request->cheques[$key] ?? 0;
            $recibo_caja_factura->cheque_q = $request->cheque_q[$key] ?? 0;
            $recibo_caja_factura->efectivo = $request->efectivo[$key] ?? 0;
            $recibo_caja_factura->retencion = $request->retencion[$key] ?? 0;

            $recibo_caja_factura->save();

            if ($recibo_caja_factura->abono <= 0) {
                $factura = Facturas::where('id', $recibo_caja_factura->id_factura)->first();
                $factura->estatus =  2;
                $factura->update();
            } else {
                $factura = Facturas::where('id', $recibo_caja_factura->id_factura)->first();
                $factura->abono = $factura->abono - $abono_anterior + floatval($request->total[$key]);
                $factura->update();
            }
        }

        //Guardar Recibo
        if ($request->imagen_recibo) {
            $imageName = $recibo_caja->id . '.' . $request->imagen_recibo->extension();
            $request->imagen_recibo->move(public_path('recibo_caja'), $imageName);
        } else {
            $imageName = '';
        }

        $recibo_caja->nombre_imagen_recibo =  $imageName;
        $recibo_caja->update();

        $arrResponse = [
            'message' => 'Recibo de caja creada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_recibos')->with($arrResponse);
    }
    public function regresarFactura(Facturas $factura)
    {
        //
        $id_salida = $factura->id_salida;
        $factura->delete();
        $regresar = SalidaAlmacen::where('id', $id_salida)->first();
        $regresar->estatus = 6;
        $regresar->update();
        $arrResponse = [
            'message' => 'Factura regresada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
    }
    public function eliminarFactura(Facturas $factura)
    {
        $factura->delete();
        $arrResponse = [
            'message' => 'Factura eliminada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
    }

    public function mostrarFacturas(Request $request)
    {
        if (isset($request->fechaInicio)) {
            $fechaInicio = Carbon::parse($request->fechaInicio);
            $fechaFin = Carbon::parse($request->fechaFin)->addDay();
            $salidasAlmacen = Facturas::whereBetween('created_at', [$fechaInicio, $fechaFin])->where('estatus', 1)->with('cliente')->with('producto')->with('nota')->get();
            $salidasAlmacen->fechaInicio = $fechaInicio->format('d-m-Y');
            $salidasAlmacen->fechaFin = $fechaFin->subDay()->format('d-m-Y');
        } else {
            $salidasAlmacen = Facturas::where('estatus', 1)->with('cliente')->with('producto')->with('nota')->get();
        }
        //dd($salidasAlmacen);
        return view('contabilidad.dashboard_facturas', compact('salidasAlmacen'));
    }
    public function mostrarFacturasTodas()
    {
        $salidasAlmacen = Facturas::where('estatus', '>', 0)->with('cliente')->with('producto')->with('nota')->get();
        //dd($salidasAlmacen);
        return view('contabilidad.dashboard_facturas_todas', compact('salidasAlmacen'));
    }
    public function ReporteVentasFacturas(Request $request)
    {
        if (isset($request->fechaInicio)) {
            $fechaInicio = Carbon::parse($request->fechaInicio);
            $fechaFin = Carbon::parse($request->fechaFin)->addDay();
            $salidasAlmacen = Facturas::whereBetween('created_at', [$fechaInicio, $fechaFin])->where('estatus', 1)->with('cliente')->with('producto')->with('nota')->get();
            $salidasAlmacen->fechaInicio = $fechaInicio->format('d-m-Y');
            $salidasAlmacen->fechaFin = $fechaFin->subDay()->format('d-m-Y');
        } else {
            $salidasAlmacen = Facturas::where('estatus', 1)->with('cliente')->with('producto')->with('nota')->get();
        }
        //dd($salidasAlmacen);
        return view('contabilidad.reporte_ventas', compact('salidasAlmacen'));
    }

    public function canceladas(Request $request)
    {
        if ($request->has(['fechaInicio', 'fechaFin'])) {
            $fechaInicio = Carbon::parse($request->fechaInicio);
            $fechaFin = Carbon::parse($request->fechaFin)->addDay();
            $facturas = Facturas::where('estatus', 'cancelada')
                ->whereBetween('created_at', [$fechaInicio, $fechaFin])
                ->get();
            $salidasAlmacen = Facturas::where('estatus', 2)
                ->whereBetween('created_at', [$fechaInicio, $fechaFin])
                ->with('cliente', 'recibo_caja', 'producto', 'nota')
                ->get();
        } else {
            $facturas = Facturas::where('estado', 'cancelada')->get();
            $salidasAlmacen = Facturas::where('estatus', 2)
                ->with('cliente', 'recibo_caja', 'producto', 'nota')
                ->get();
        }

        return view('contabilidad.dashboard_facturas_canceladas', compact('facturas', 'salidasAlmacen'));
    }
    public function notaDebito(Request $request)
    {

        $nota_debito = new NotaDebito();
        $nota_debito->id_usuario =  Auth::id();
        $nota_debito->id_factura = $request->id_factura;
        $nota_debito->id_tipo = $request->tipo;
        $nota_debito->cantidad = $request->cantidad;
        $nota_debito->estatus = 1;
        $nota_debito->observaciones = $request->observaciones;
        $nota_debito->save();
        //if($request->tipo==1){
        //    $salidasAlmacen->total=floatval($salidasAlmacen->total)+floatval($request->cantidad);
        //}else{
        //    $salidasAlmacen->total=floatval($salidasAlmacen->total)-floatval($request->cantidad);
        //    $total_cancelado=floatval($salidasAlmacen->abono)+floatval($request->cantidad);
        //    if($total_cancelado==$salidasAlmacen->total){
        //        $salidasAlmacen->estatus=2;
        //    }
        //}
        //$salidasAlmacen->id_debito=$nota_debito->id;
        //$salidasAlmacen->update();
        $salidasAlmacen = Facturas::where('id', $request->id_factura)->with('cliente')->first();
        if ($request->tipo == 1) {
            $tipo_nota = 'Nota de Debito';
        } else {
            $tipo_nota = 'Nota de Credito';
        }

        $info = [
            'id_nota' => $nota_debito->id, //aca se envia el id de la nota
            'tipo' => $tipo_nota,
            'valor' => $request->cantidad,
            'observaciones' => $request->observaciones,
            'numero_factura' => $salidasAlmacen->no_sat,
            'nombre_cliente' => $salidasAlmacen->cliente->nombre,
        ];

        //Mail::send('email.envio_nota_debito', compact('info'), function ($message) use ($tipo_nota){
        //    $message->from('info@laravelrp.com', $tipo_nota);
        //    $message->to('marlontahuite@concisa.com.gt');
        //    $message->to('anylopeza3@gmail.com', $tipo_nota);      
        //    $message->subject($tipo_nota);
        //});

        Mail::send('email.autorizar_nota_debito', compact('info'), function ($message) use ($tipo_nota) {
            $message->from('info@laravelrp.com', $tipo_nota);
            $message->to('kicas48@gmail.com', $tipo_nota);
            $message->to('anylopeza3@gmail.com', $tipo_nota);
            $message->subject($tipo_nota);
        });

        return response(200);
    }


    //notas de crédito y debito

    public function mostrarNotaDebito()
    {

        $notas = NotaDebito::with('usuarios')->with('facturacion')->get();

        return view('contabilidad.dashboard_notas_credito_debito', ['notas' => $notas]);
    }

    public function editarNotas($id_nota)
    {
        $notas = NotaDebito::where('id', $id_nota)->with('usuarios')->with('facturacion')->get();
        //dd($notas);
        return view('contabilidad.editar_notas_credito_debito', compact('notas'));
    }

    public function verAutorizarNotas($id_nota)
    {
        $notas = NotaDebito::where('id', $id_nota)->with('usuarios')->with('facturacion')->get();
        //dd($notas);
        return view('contabilidad.autorizar_notas_credito_debito', compact('notas'));
    }


    public function updateNotas(request $request, $id_nota)
    {
        $nota = NotaDebito::find($id_nota);

        $nota->observaciones = $request->observaciones_nota;
        $nota->cantidad     = $request->cantidad_update;

        $nota->save();
        return redirect()->back()->with('success', 'La nota fue actualizada');
    }

    public function autorizarNotas(Request $request, $id_nota)
    {
        $nota = NotaDebito::find($id_nota);

        $factura_db = Facturas::where('id', $nota->id_factura)->with('cliente')->first();

        if ($nota->id_tipo == 2) {
            //uno es credito asi que resta al saldo actual

            $factura_db->total = $factura_db->total - $nota->cantidad;
            $factura_db->id_debito = $nota->id;
            $factura_db->save();
            $nota->estatus = 0;
            $nota->save();
        } else {
            //dos es debito asi que suma al saldo actual

            $factura_db->total = $factura_db->total + $nota->cantidad;
            $factura_db->id_debito = $nota->id;
            $factura_db->save();
            $nota->estatus = 0;
            $nota->save();
        }
        //dd($request);

        $h_nota = [
            'id_nota' => $request->id_nota,
            'cliente' => $request->cliente,
            'factura' => $request->factura,
            'tipo' => $request->tipo,
            'motivo_creacion' => $request->motivo_creacion,
            'usuario' => $request->usuario,
            'razon' => $request->razon,
            'email' => $request->email,
            'monto' => $request->monto
        ];

        Mail::send('email.autorizado_nota_debito', compact('h_nota'), function ($message) use ($request) {
            $message->from('info@laravelrp.com');
            $message->to('marlontahuite@concisa.com.gt');
            $message->to('anylopeza3@gmail.com');
            //$message->to('soporte@paginawebguatemala.com');
            $message->to($request->email);
            $message->subject('Autorización de Nota - ' . $request->id_nota);
        });

        return redirect()->route('contabilidad.dashboard_notas_credito_debito')->with('success', 'La nota fue autorizada');
    }



    public function regresarNotas($id_nota)
    {

        $nota = NotaDebito::find($id_nota);
        //Quitar a la factura la nota
        $factura = Facturas::find($nota->id_factura);
        $factura->id_debito = 0;
        if ($nota->id_tipo == 1) {
            $factura->total = $factura->total - $nota->cantidad;
        } else {
            $factura->total = $factura->total + $nota->cantidad;
        }

        $notas = NotaDebito::where('id', $id_nota)->with('usuarios')->with('facturacion')->get();

        $arraydata = 0;
        $h_nota = 0;

        foreach ($notas as $notadata) {

            $arraydata = $notadata['usuarios']['email'];
            $h_nota = array(
                "id" => $notadata['id'],
                "usuario" => $notadata['usuarios']['name'],
                "monto" => $notadata['cantidad'],
                "no_sat" => $notadata['facturacion']['no_sat'],
            );
        }

        Mail::send('email.regresar_nota_debito', compact('h_nota'), function ($message) use ($arraydata) {
            $message->from('info@laravelrp.com');
            $message->to('marlontahuite@concisa.com.gt');
            $message->to('kicas48@gmail.com');
            $message->to('anylopeza3@gmail.com');
            $message->to($arraydata);
            $message->subject('Reversion de Nota');
        });

        $factura->update();
        $nota->delete();

        return redirect()->back()->with('success', 'La nota fue eliminada');
    }



    public function rechazarNotas(Request $request, $id_nota)
    {
        $nota = NotaDebito::find($id_nota);


        $h_nota = [
            'id_nota' => $request->id_nota,
            'cliente' => $request->cliente,
            'factura' => $request->factura,
            'tipo' => $request->tipo,
            'monto' => $request->monto,
            'motivo_creacion' => $request->motivo_creacion,
            'usuario' => $request->usuario,
            'razon' => $request->razon,
            'email' => $request->email,
        ];


        Mail::send('email.rechazar_nota_debito', compact('h_nota'), function ($message) use ($request) {
            $message->from('info@laravelrp.com');
            $message->to('marlontahuite@concisa.com.gt');
            $message->to('anylopeza3@gmail.com');
            //$message->to('soporte@paginawebguatemala.com');
            $message->to($request->email);
            $message->subject('Nota ' . $request->id_nota . ' rechazada');
        });


        $nota->delete();

        return redirect()->route('contabilidad.dashboard_notas_credito_debito')->with('success', 'La nota fue rechazada y eliminada');
    }


    public function imprimirNota($id_nota)
    {

        $notas = NotaDebito::where('id', $id_nota)->with('usuarios')->with('facturacion')->get();


        $dia = (int)date("d", strtotime($notas[0]['created_at']));
        $mesInt = (int)date("m", strtotime($notas[0]['created_at']));
        $ano = (int)date("Y", strtotime($notas[0]['created_at']));
        $mes = ContabilidadController::mesGT($mesInt);

        $pdf = PDF::loadView('contabilidad.imprimir_nota', compact('notas', 'dia', 'mes', 'ano'));
        return $pdf->download('notas_cr_db_- ' . $id_nota . '.pdf');
        dd();
    }




    public function mostrarFacturasHistorial(Request $request)
    {
        $total_final = 0;
        $fechaConsultada = (object) array('' => '');
        //dd(isset($request->fechaInicio));
        if (isset($request->fechaInicio)) {
            $fechaInicio = Carbon::parse($request->fechaInicio);
            $fechaFin = Carbon::parse($request->fechaFin)->addDay();
            $salidasAlmacen = Facturas::whereBetween('created_at', [$fechaInicio, $fechaFin])->with('cliente')->get();
            foreach ($salidasAlmacen as $salida) {
                $id_cliente = $salida->id_cliente;
                $facturas[$id_cliente]['id_cliente'] = $id_cliente;
                $facturas[$id_cliente]['nombre_cliente'] = $salida->cliente->nombre;
                $facturas[$id_cliente]['total'] = floatval($facturas[$id_cliente]['total'] ?? 0) + floatval($salida->total);
                $total_final = $total_final + floatval($salida->total);
            }
            $fechaConsultada->fechaInicio = $fechaInicio->format('d-m-Y');
            $fechaConsultada->fechaFin = $fechaFin->subDay()->format('d-m-Y');
        } else {
            $salidasAlmacen = Facturas::with('cliente')->get();
            foreach ($salidasAlmacen as $salida) {
                $id_cliente = $salida->id_cliente;
                $facturas[$id_cliente]['id_cliente'] = $id_cliente;
                $facturas[$id_cliente]['nombre_cliente'] = $salida->cliente->nombre;
                $facturas[$id_cliente]['total'] = floatval($facturas[$id_cliente]['total'] ?? 0) + floatval($salida->total);
                $total_final = $total_final + floatval($salida->total);
            }
        }
        return view('contabilidad.dashboard_historial_facturas', compact('facturas', 'total_final', 'fechaConsultada'));
    }

    public function mostrarRecibos(Request $request)
    {
        if (isset($request->fechaInicio)) {
            $fechaInicio = Carbon::parse($request->fechaInicio);
            $fechaFin = Carbon::parse($request->fechaFin)->addDay();
            $salidasAlmacen = ReciboCaja::whereBetween('created_at', [$fechaInicio, $fechaFin])->with('cliente')->with('facturas')->get();
            $salidasAlmacen->fechaInicio = $fechaInicio->format('d-m-Y');
            $salidasAlmacen->fechaFin = $fechaFin->subDay()->format('d-m-Y');
        } else {
            $salidasAlmacen = ReciboCaja::with('cliente')->with('facturas')->get();
            //dd($salidasAlmacen);
        }

        return view('contabilidad.dashboard_recibos', compact('salidasAlmacen'));
    }
    public function imprimirRecibo($id_recibo)
    {
        $recibos = ReciboCaja::where('id', $id_recibo)->with('facturas')->with('cliente')->first();
        if ($recibos->fecha_ingreso) {
            $fecha_ingreso = $recibos->fecha_ingreso;
        } else {
            $fecha_ingreso = $recibos->created_at;
        }

        $dia = (int)date("d", strtotime($fecha_ingreso));
        $mesInt = (int)date("m", strtotime($fecha_ingreso));
        $ano = (int)date("Y", strtotime($fecha_ingreso));

        $mes = ContabilidadController::mesGT($mesInt);
        $nombre_cliente = $recibos->cliente->nombre;
        $nombre_ejecutivo = $recibos->cliente->info_ejecutivo->name ?? '';
        $id_recibo = $recibos->id;
        $observacion = $recibos->observacion;
        //dd($recibos);
        foreach ($recibos->facturas as $i => $f) {
            $n_sat = isset($f->ver_factura) ? ($f->ver_factura->no_sat ?? "00000") : "00000";
            $facturas[$n_sat]['cheque'] = $f->cheque_q + ($facturas[$n_sat]['cheque'] ?? 0);
            $facturas[$n_sat]['efectivo'] = $f->efectivo + ($facturas[$n_sat]['efectivo'] ?? 0) + ($f->retencion ?? 0);
            $facturas[$n_sat]['total'] = $f->total_cancelar + ($facturas[$n_sat]['total'] ?? 0);
            $total_f = $f->cheque_q + $f->efectivo + ($total_f ?? 0) + ($f->retencion ?? 0);
        }
        $pdf = PDF::loadView('contabilidad.imprimir_recibo', compact('facturas', 'dia', 'ano', 'observacion', 'mes', 'nombre_cliente', 'total_f', 'nombre_ejecutivo', 'id_recibo'));
        return $pdf->download('recibo_caja - ' . $id_recibo . '.pdf');
        dd();
    }
    public function editarRecibos($id_recibo)
    {
        $recibo = ReciboCaja::where('id', $id_recibo)->with('facturas')->with('cliente')->first();
        //dd($recibo);   
        return view('contabilidad.editar_recibo', compact('recibo'));
    }

    public function BKregresarRecibos($id_recibo)
    {
        $recibo = ReciboCaja::where('id', $id_recibo)->with('facturas')->with('cliente')->first();
        $abonos = 0;
        foreach ($recibo->facturas as $recibo_facturas) {
            if ($recibo_facturas->id_factura == 0) {
                $cliente = Cliente::where('id', $recibo_facturas->id_cliente)->first();
                $saldo_cliente = $cliente->saldo_favor - $recibo_facturas->total_cancelar;
                $cliente->saldo_favor = $saldo_cliente;
                $cliente->update();
                $recibo_facturas->delete();
            } else {
                $factura = Facturas::where('id', $recibo_facturas->id_factura)->first();
                if ($factura->abono >= $recibo->id_total) {
                    $abono_factura = $factura->abono - $recibo->id_total;
                    $factura->abono = $abono_factura;
                    $factura->estatus = 1;
                    $factura->update();
                    $recibo_facturas->delete();
                } else {
                    $factura->id_recibo_caja_factura = 0;
                    $factura->estatus = 1;
                    $factura->update();
                    $recibo_facturas->delete();
                }
            }
        }
        //Eliminar recibo
        $recibo->delete();
        $arrResponse = [
            'message' => 'Recibo eliminada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
    }

    public function regresarRecibos($id_recibo)
    {

        $recibos = ReciboCajaFactura::where('id_recibo_caja', $id_recibo)->get();
        //Valida que tipo de recibo es sin o con factura (adelanto o pago de factura)
        foreach ($recibos as $recibo) {

            $cliente = Cliente::where('id', $recibo->id_cliente)->first();

            if ($recibo->id_factura == 0) {
                //valida que recibo no tenga factura adjunta
                $saldo_cliente = $cliente->saldo_favor - $recibo->total_cancelar;
                $cliente->saldo_favor = $saldo_cliente;
                $cliente->update();
                $reciboCajaF = ReciboCajaFactura::where('id', $recibo->id)->first();
                $reciboC = ReciboCaja::where('id', $recibo->id_recibo_caja)->first();
                $reciboCajaF->delete();
                $reciboC->delete();

                //elimina el recibo de caja.
                $arrResponse = ['message' => 'Recibo eliminada correctamente de facturas'];
            } else {
                //Si tiene id de factura entonces hace el proceso normal.
                $factura = Facturas::where('id', $recibo->id_factura)->first();

                if ($recibo->total_cancelar >= $factura->total) {
                    if ($factura->abono == 0) {
                        $new_saldo = 0;
                    } else {
                        $new_saldo = ($factura->abono) - ($recibo->total_cancelar);
                    }
                } else {
                    //valida si ya esta cancelada solo borra el recibo y cambia el estatus
                    if ($factura->estatus == 2) {
                        $new_saldo = $factura->abono;
                    } else {
                        $new_saldo = ($factura->abono) - ($recibo->total_cancelar);
                    }
                }

                $factura->abono = $new_saldo;

                //se valida si el total del recibo es mayor o igual al total de la factura
                if ($factura->total >= $recibo->total_cancelar) {
                    $factura->estatus = 1;
                }

                //guarda los datos
                $factura->update();
                $reciboCajaF = ReciboCajaFactura::where('id', $recibo->id)->first();
                $reciboCajaF->delete();
                $arrResponse = ['message' => 'Recibo eliminada correctamente de facturas'];
            }
        }

        $reciboCajaG = ReciboCaja::where('id', $id_recibo)->first();
        if ($reciboCajaG) {
            $reciboCajaG->delete();
        }

        return redirect()->route('contabilidad.dashboard_facturas')->with($arrResponse);
    }


    public function mostrarFacturasCanceladas()
    {
        //
        $salidasAlmacen = Facturas::where('estatus', 2)->with('cliente')->with('recibo_caja')->with('producto')->with('nota')->get();
        return view('contabilidad.dashboard_facturas_canceladas', compact('salidasAlmacen'));
    }
    public function reciboCaja($idFactura)
    {
        //
        //dd($idFactura);
        $factura = Facturas::where('id', $idFactura)->with('cliente')->with('producto')->first();
        $info_envio = [
            'id' => $factura->id,
            'referencia' => $factura->cliente->referencia,
            'dia' => date("d"),
            'mes' => date("m"),
            'ano' => date("Y"),
            'cliente' => $factura->cliente->nombre,
            'cantidad' => $factura->cantidad,
            'medida' => $factura->producto->medida->nombre,
            'producto' => $factura->producto->nombre,
        ];
        $pdf = PDF::loadView('contabilidad.generar_recibo', compact('info_envio'));
        return $pdf->download('recibo_caja - ' . $factura->id . '.pdf');
        dd();
        //return view('contabilidad.generar_recibo',compact('info_envio'));
    }
    public function mostrarRecibosDia(Request $request)
    {
        $date = date('Y-m-d');
        $fechaInicio = Carbon::parse($date)->subDay();

        $carbonCurrentDate = Carbon::now();
        $mesStart = ($carbonCurrentDate->day == 1) ? $carbonCurrentDate->subDay()->startOfMonth() : $carbonCurrentDate->startOfMonth();
        //dd($mesStart);
        $mesHoy = Carbon::parse($date)->subDay();

        $fechaFin = Carbon::parse($date);
        $salidasAlmacen = ReciboCaja::whereBetween('created_at', [$fechaInicio, $fechaFin])->with('cliente')->with('facturas')->get();

        $totalhastahoy = ReciboCaja::whereBetween('created_at', [$mesStart, $date])->with('cliente')->with('facturas')->selectRaw('*, sum(id_total) as total')->get();

        $salidasAlmacen->fechaInicio = $fechaInicio->format('d-m-Y');
        $salidasAlmacen->fechaFin = $fechaInicio->format('d-m-Y');
        //dd($salidasAlmacen);
        return view('contabilidad.dashboard_recibos_dia', compact('salidasAlmacen', 'totalhastahoy'));
    }


    public function mostrarRecibosMes()
    {
        $start = new Carbon('first day of last month');
        $end = new Carbon('last day of last month');

        $recibos = DB::table('recibo_caja')
            ->select('created_at', DB::raw('SUM(id_total) as total_sales'))
            ->whereBetween('created_at', [$start, $end])
            ->groupBy(DB::raw('DAY(created_at)'))
            ->get();
        $recibos->fechaInicio = $start;
        $recibos->fechaFin = $end;

        //$query = "SELECT `created_at`,SUM(`total`) FROM `facturas` WHERE YEAR( `created_at` ) = 2023 AND MONTH( `created_at` ) = 7 GROUP BY DAY( `created_at` )";
        //$ArrayData = DB::table('recibo_caja')->sum();
        //dd($recibos);
        //SELECT `created_at`,SUM(`id_total`) FROM recibo_caja WHERE YEAR( `created_at` ) = 2023 AND MONTH( `created_at` ) = 7 GROUP BY DAY( `created_at` );
        //$query = "SELECT `created_at`,SUM(`id_total`) FROM `facturas` WHERE BETWEEN '$start' AND '$end' GROUP BY DAY( `created_at` );";
        return view('contabilidad.dashboard_recibos_mes', compact('recibos'));
    }



    public function crearFacturas(Request $request)
    {
        $ajuste = Ajustes::where('nombre_campo', 'tipo_cambio')->first();
        $total_t = 0;
        foreach ($request->crear_facturas as $key => $id_factura) {
            $factura = SalidaAlmacen::where('id', $id_factura)->with('cliente')->with('producto')->with('cotizacion')->with('op')->first();
            $tipo_cambio = 1;
            if ($factura->op) {
                $id_cotizacion = $factura->op->id_cotizacion;
                $cotizacion = Cotizacion::where('id', $id_cotizacion)->first();
                $tipo_cambio = $cotizacion->id_moneda;
            }

            //para tipo de cambio 
            if ($factura->cotizacion) {
                $cotizacion = Cotizacion::where('id', $factura->cotizacion->id_cotizacion)->first();
                $tipo_cambio = $cotizacion->id_moneda;
            }


            if ($key == 0) {
                $id_cliente = $factura->id_cliente;
                $cliente = Cliente::where('id', $factura->id_cliente)->first();
            }
            if ($id_cliente == $factura->id_cliente) {
                if ($factura->id_cotizacion > 0) {
                    if ($cliente->tipo_regimen == 2) {
                        $precio = round(floatval($factura->cotizacion->precio), 5);
                    } else {
                        $precio = round($factura->cotizacion->precio, 5);
                    }
                } else {
                    if ($cliente->tipo_regimen == 2) {
                        $precio = round(floatval($factura->op->cotizaciones_p->precio), 5);
                    } else {
                        $precio = round($factura->op->cotizaciones_p->precio, 5);
                    }
                }
                if ($tipo_cambio == 2) {
                    $precio = $precio * round($ajuste->valor, 2);
                }
                $cantidad = $factura->cantidad;
                $total = $precio * $cantidad;
                $total_t = $total_t + $total;


                if ($cliente->tipo_regimen == 2) {
                    $iva = 0;
                    $iva_t = 0;
                } else {
                    $iva = round($total - ($total / 1.12), 2);
                    $iva_t = round($total_t - ($total_t / 1.12), 2);
                }
                if ($factura->op) {
                    $imagen = $factura->op->cotizaciones_p->id;
                    $comentario_cotizacion = $factura->op->observaciones ?? '';
                } else {
                    $imagen = $factura->cotizacion->id;
                    $comentario_cotizacion = $factura->cotizacion->observaciones ?? '';
                }
                $cliente->comentario_cotizacion = $comentario_cotizacion;
                if ($factura->cotizacion) {
                    $cotizacion = Cotizacion::where('id', $factura->cotizacion->id_cotizacion)->first();
                    $observacion_coti = $cotizacion->observaciones ?? '';
                } else {
                    $observacion_coti = '';
                }

                $no_cotizacion = $factura->id_cotizacion > 0 ? $factura->id_cotizacion : $factura->op->id_cotizacion_producto;
                $facturas[] = [
                    'id_producto' => $factura->id_producto,
                    'nombre' => $factura->producto->medida->nombre . ' ' . $factura->producto->nombre,
                    'medida' => $factura->producto->medida->nombre,
                    'cantidad' => $cantidad,
                    'id_co' => $imagen ?? 0,
                    'url' => '/cotizaciones/CO_' . $imagen . '.pdf',
                    'id_salida' => $factura->id,
                    'no_cotizacion' => $no_cotizacion,
                    'precio' => $precio,
                    'total' => $total,
                    'iva' => $iva,
                    'comentario_coti' => $observacion_coti
                ];
            } else {
                $error = 'Un cliente no corresponde';
            }
        }
        //dd($facturas);

        return view('contabilidad.crear_facturas', compact('facturas', 'cliente', 'total_t', 'iva_t'));
    }
    public function guardarFacturas(Request $request)
    {
        //Guardar Factura
        //dd($request);
        $imageName = time() . '.' . $request->pdf_factura->extension();
        $factura_image = $request->pdf_factura->move(public_path('facturas'), $imageName);
        $path = url('/facturas') . '/' . $imageName;
        if ($request->pdf_factura2 ?? "") {
            $imageName2 = time() . '2.' . $request->pdf_factura2->extension();
            $factura_image2 = $request->pdf_factura2->move(public_path('facturas'), $imageName2);
            $path2 = url('/facturas') . '/' . $imageName2;
        } else {
            $imageName2 = '';
            $path2 = '';
        }
        if ($request->pdf_factura3 ?? "") {
            $imageName3 = time() . '3.' . $request->pdf_factura3->extension();
            $factura_image3 = $request->pdf_factura3->move(public_path('facturas'), $imageName3);
            $path3 = url('/facturas') . '/' . $imageName3;
        } else {
            $imageName3 = '';
            $path3 = '';
        }
        if ($request->pdf_factura4 ?? "") {
            $imageName4 = time() . '4.' . $request->pdf_factura4->extension();
            $factura_image4 = $request->pdf_factura4->move(public_path('facturas'), $imageName4);
            $path4 = url('/facturas') . '/' . $imageName4;
        } else {
            $imageName4 = '';
            $path4 = '';
        }
        if ($request->pdf_factura5 ?? "") {
            $imageName5 = time() . '5.' . $request->pdf_factura5->extension();
            $factura_image5 = $request->pdf_factura5->move(public_path('facturas'), $imageName5);
            $path5 = url('/facturas') . '/' . $imageName5;
        } else {
            $imageName5 = '';
            $path5 = '';
        }


        foreach ($request->id_salida as $key => $id_salida) {
            $salida = SalidaAlmacen::where('id', $request->id_salida[$key])->first();
            if ($salida->estatus !=  3) {
                //Buscar saldo
                $cliente = Cliente::where('id', $request->id_cliente)->first();
                $factura = new Facturas();
                $factura->id_usuario =  Auth::id();
                $factura->id_cliente = $request->id_cliente;
                $factura->id_producto = $request->id_producto[$key];
                $factura->id_salida = $request->id_salida[$key];
                $factura->cantidad = $request->cantidad[$key];
                $factura->precio = $request->precio[$key];
                if ($cliente->saldo_favor > $request->total[$key]) {
                    $factura->abono = 0;
                    $factura->id_saldo = 0;
                    $factura->saldo_favor = 0;
                    $factura->estatus = 2;
                } else {
                    $factura->abono = $cliente->saldo_favor;
                    $factura->id_saldo = $cliente->id_saldo;
                    $factura->saldo_favor = $cliente->saldo_favor;
                    $factura->estatus = 1;
                }
                $factura->total = $request->total[$key];
                $factura->no_sat = $request->numero_factura ?? '';
                $factura->archivo_factura = $imageName;
                $factura->archivo_factura2 = $imageName2;
                $factura->archivo_factura3 = $imageName3;
                $factura->archivo_factura4 = $imageName4;
                $factura->archivo_factura5 = $imageName5;
                $factura->save();
                $id_salida = $factura->id;
                $salida->estatus =  3;
                $salida->update();

                //Inicio de codigo para vincular la factura con el recibo de caja
                if ($cliente->saldo_favor > 0) {
                    $recibos_caja_factura = ReciboCajaFactura::where('id_cliente', $request->id_cliente)
                        ->where('id_factura', 0)
                        ->where('id_factura_sat', 0)
                        ->where('efectivo', '>', 0)
                        ->orderBy('id', 'asc')
                        ->get();

                    foreach ($recibos_caja_factura as $recibo_caja_factura) {
                        if ($cliente->saldo_favor > $factura->total) {
                            $recibo_caja_factura_nuevo = new ReciboCajaFactura();
                            $recibo_caja_factura_nuevo->id_recibo_caja = $recibo_caja_factura->id_recibo_caja;
                            $recibo_caja_factura_nuevo->id_cliente = $recibo_caja_factura->id_cliente;
                            $recibo_caja_factura_nuevo->id_factura = $factura->id;
                            $recibo_caja_factura_nuevo->id_factura_sat = $request->numero_factura ?? '';
                            $recibo_caja_factura_nuevo->total_factura = $factura->total;
                            $recibo_caja_factura_nuevo->abono = 0;
                            $recibo_caja_factura_nuevo->total_cancelar = $factura->total;
                            $recibo_caja_factura_nuevo->numero_cheque = 0;
                            $recibo_caja_factura_nuevo->efectivo = $factura->total;
                            $recibo_caja_factura_nuevo->cheque_q = 0;
                            $recibo_caja_factura_nuevo->retencion = $recibo_caja_factura->retencion ?? 0;
                            $cliente->saldo_favor -= $factura->total;
                            $recibo_caja_factura_nuevo->save();
                            //Agregar referencia de recibo de caja a la factura
                            $factura->id_recibo_caja_factura = $recibo_caja_factura->id_recibo_caja;
                            $factura->save();
                        } else {
                            $cliente->saldo_favor = 0;
                            $cliente->id_saldo = 0;
                            $recibo_caja_factura->id_factura = $factura->id;
                            $recibo_caja_factura->id_factura_sat = $request->numero_factura ?? '';
                            $recibo_caja_factura->update();
                        }
                    }
                }
                $cliente->update();
                //Fin de codigo para vincular la factura con el recibo de caja 

                $listado_productos[] = [
                    'cantidad' => $request->cantidad[$key],
                    'nombre' => $request->nombre_producto[$key],
                    'total' => number_format($request->total[$key], 2, '.', ','),
                ];
            }
        }



        $cliente = Cliente::where('id', $request->id_cliente)->first();

        $referencia = $cliente->referencia ?? '';

        if ($cliente->nit == 'C/F') {
            $info = [
                'nombreCliente' => $cliente->nombre_contacto,
                'idSalida' => $factura->id,
                'idCotizacion' => $request->numero_factura ?? '',
                'url' => $path,
                'total_t' => number_format($request->total_t, 2, '.', ',')
            ];

            Mail::send('email.envio_generar_factura', compact('info', 'listado_productos'), function ($message) use ($id_salida, $referencia, $path, $path2, $path3, $path4, $path5) {
                $message->from('info@laravelrp.com', 'Generación Facturar No. ' . $id_salida . ' - ' . $referencia);
                $message->to('anylopeza3@gmail.com');
                $message->to('marlontahuite@concisa.com.gt');
                $message->attach($path);
                if ($path2) {
                    $message->attach($path2);
                }
                if ($path3) {
                    $message->attach($path3);
                }
                if ($path4) {
                    $message->attach($path4);
                }
                if ($path5) {
                    $message->attach($path5);
                }
                $message->subject('Generación Facturar CF - ' . $id_salida . ' - ' . $referencia);
            });
        }

        $arrResponse = [
            'message' => 'Factura creada correctamente'
        ];
        return redirect()->route('contabilidad.dashboard_solicitud_factura')->with($arrResponse);
    }
    public function reciboCajaFactura(Request $request)
    {
        foreach ($request->facturas_cancelar as $key => $id_factura) {
            $factura = Facturas::where('id', $id_factura)->with('cliente')->with('producto')->first();
            if ($key == 0) {
                $id_cliente = $factura->id_cliente;
            }
            if ($id_cliente == $factura->id_cliente) {
                $facturas[] = $factura;
            } else {
                $error = 'Un cliente no corresponde';
            }
        }
        //dd($facturas);
        return view('contabilidad.generar_recibo_v2', compact('facturas'));
    }

    public function cancelarFactura(Request $request)
    {
        $op = Facturas::where('id', $request->id_factura)->first();
        $op->estatus = 2;
        $op->update();
        return response($op);
    }


    public function cuentaCorriente()
    {
        //Facturas Pendientes
        $fecha = new DateTime(date("Y-m-d"));
        $facturas_pendientes = Facturas::where('estatus', 1)->with('cliente')->get();
        $clientes_saldo = Cliente::where('saldo_favor', '>', 0)->get();
        $total_total = 0;
        $total_total30 = 0;
        $total_total60 = 0;
        $total_total90 = 0;
        $total_total100 = 0;

        //script origninal
        //foreach($facturas_pendientes as $factura){
        //    //dd($factura);
        //    $clientes[$factura->id_cliente]=$factura->cliente;
        //    $fecha_factura=$fecha->diff($factura->created_at)->days;
        //    $notas_credito=$factura->nota->cantidad??0; 
        //    if($factura->nota->id_tipo??0==2){
        //        $total_cliente[$factura->id_cliente]=($total_cliente[$factura->id_cliente]??0)+($factura->total-$factura->abono)-$notas_credito;
        //        if($fecha_factura<=30){
        //            $facturas[$factura->id_cliente][30][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][30]=($total_cliente_dias[$factura->id_cliente][30]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total30=$total_total30+($factura->total-$factura->abono)-$notas_credito;
        //        }elseif($fecha_factura>30 && $fecha_factura<=60){
        //            $facturas[$factura->id_cliente][60][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][60]=($total_cliente_dias[$factura->id_cliente][60]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total60=$total_total60+($factura->total-$factura->abono)-$notas_credito;
        //        }elseif($fecha_factura>60 && $fecha_factura<=90){
        //            $facturas[$factura->id_cliente][90][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][90]=($total_cliente_dias[$factura->id_cliente][90]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total90=$total_total90+($factura->total-$factura->abono)-$notas_credito;
        //        }else{
        //            $facturas[$factura->id_cliente][100][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][100]=($total_cliente_dias[$factura->id_cliente][100]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total100=$total_total100+($factura->total-$factura->abono)-$notas_credito;
        //        }
        //        $total_total=$total_total+($factura->total-$factura->abono)-$notas_credito;
        //    }else{
        //        $total_cliente[$factura->id_cliente]=($total_cliente[$factura->id_cliente]??0)+($factura->total-$factura->abono)+$notas_credito;
        //        if($fecha_factura<=30){
        //            $facturas[$factura->id_cliente][30][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][30]=($total_cliente_dias[$factura->id_cliente][30]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total30=$total_total30+($factura->total-$factura->abono)+$notas_credito;
        //        }elseif($fecha_factura>30 && $fecha_factura<=60){
        //            $facturas[$factura->id_cliente][60][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][60]=($total_cliente_dias[$factura->id_cliente][60]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total60=$total_total60+($factura->total-$factura->abono)+$notas_credito;
        //        }elseif($fecha_factura>60 && $fecha_factura<=90){
        //            $facturas[$factura->id_cliente][90][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][90]=($total_cliente_dias[$factura->id_cliente][90]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total90=$total_total90+($factura->total-$factura->abono)+$notas_credito;
        //        }else{
        //            $facturas[$factura->id_cliente][100][]=$factura;
        //            $total_cliente_dias[$factura->id_cliente][100]=($total_cliente_dias[$factura->id_cliente][100]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total100=$total_total100+($factura->total-$factura->abono)+$notas_credito;
        //        }
        //        $total_total=$total_total+($factura->total-$factura->abono)+$notas_credito;
        //    }
        //    /*
        //    $total_cliente[$factura->id_cliente]=($total_cliente[$factura->id_cliente]??0)+($factura->total-$factura->abono);
        //    if($fecha_factura<=30){
        //        $facturas[$factura->id_cliente][30][]=$factura;
        //        $total_cliente_dias[$factura->id_cliente][30]=($total_cliente_dias[$factura->id_cliente][30]??0)+($factura->total-$factura->abono);
        //        $total_total30=$total_total30+($factura->total-$factura->abono);
        //    }elseif($fecha_factura>30 && $fecha_factura<=60){
        //        $facturas[$factura->id_cliente][60][]=$factura;
        //        $total_cliente_dias[$factura->id_cliente][60]=($total_cliente_dias[$factura->id_cliente][60]??0)+($factura->total-$factura->abono);
        //        $total_total60=$total_total60+($factura->total-$factura->abono);
        //    }elseif($fecha_factura>60 && $fecha_factura<=90){
        //        $facturas[$factura->id_cliente][90][]=$factura;
        //        $total_cliente_dias[$factura->id_cliente][90]=($total_cliente_dias[$factura->id_cliente][90]??0)+($factura->total-$factura->abono);
        //        $total_total90=$total_total90+($factura->total-$factura->abono);
        //    }else{
        //        $facturas[$factura->id_cliente][100][]=$factura;
        //        $total_cliente_dias[$factura->id_cliente][100]=($total_cliente_dias[$factura->id_cliente][100]??0)+($factura->total-$factura->abono);
        //        $total_total100=$total_total100+($factura->total-$factura->abono);
        //        
        //    }
        //    $total_total=$total_total+($factura->total-$factura->abono);*/
        //    
        //}

        foreach ($facturas_pendientes as $factura) {
            //dd($factura);
            $clientes[$factura->id_cliente] = $factura->cliente;
            $fecha_factura = $fecha->diff($factura->created_at)->days;
            $notas_credito = $factura->nota->cantidad ?? 0;
            if ($factura->nota->id_tipo ?? 0 == 2) {
                $total_cliente[$factura->id_cliente] = ($total_cliente[$factura->id_cliente] ?? 0) + ($factura->total - $factura->abono);
                if ($fecha_factura <= 30) {
                    $facturas[$factura->id_cliente][30][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][30] = ($total_cliente_dias[$factura->id_cliente][30] ?? 0) + ($factura->total - $factura->abono);
                    $total_total30 = $total_total30 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 30 && $fecha_factura <= 60) {
                    $facturas[$factura->id_cliente][60][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][60] = ($total_cliente_dias[$factura->id_cliente][60] ?? 0) + ($factura->total - $factura->abono);
                    $total_total60 = $total_total60 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 60 && $fecha_factura <= 90) {
                    $facturas[$factura->id_cliente][90][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][90] = ($total_cliente_dias[$factura->id_cliente][90] ?? 0) + ($factura->total - $factura->abono);
                    $total_total90 = $total_total90 + ($factura->total - $factura->abono);
                } else {
                    $facturas[$factura->id_cliente][100][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][100] = ($total_cliente_dias[$factura->id_cliente][100] ?? 0) + ($factura->total - $factura->abono);
                    $total_total100 = $total_total100 + ($factura->total - $factura->abono);
                }
                $total_total = $total_total + ($factura->total - $factura->abono);
            } else {
                $total_cliente[$factura->id_cliente] = ($total_cliente[$factura->id_cliente] ?? 0) + ($factura->total - $factura->abono);
                if ($fecha_factura <= 30) {
                    $facturas[$factura->id_cliente][30][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][30] = ($total_cliente_dias[$factura->id_cliente][30] ?? 0) + ($factura->total - $factura->abono);
                    $total_total30 = $total_total30 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 30 && $fecha_factura <= 60) {
                    $facturas[$factura->id_cliente][60][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][60] = ($total_cliente_dias[$factura->id_cliente][60] ?? 0) + ($factura->total - $factura->abono);
                    $total_total60 = $total_total60 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 60 && $fecha_factura <= 90) {
                    $facturas[$factura->id_cliente][90][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][90] = ($total_cliente_dias[$factura->id_cliente][90] ?? 0) + ($factura->total - $factura->abono);
                    $total_total90 = $total_total90 + ($factura->total - $factura->abono);
                } else {
                    $facturas[$factura->id_cliente][100][] = $factura;
                    $total_cliente_dias[$factura->id_cliente][100] = ($total_cliente_dias[$factura->id_cliente][100] ?? 0) + ($factura->total - $factura->abono);
                    $total_total100 = $total_total100 + ($factura->total - $factura->abono);
                }
                $total_total = $total_total + ($factura->total - $factura->abono);
            }
            /*
            $total_cliente[$factura->id_cliente]=($total_cliente[$factura->id_cliente]??0)+($factura->total-$factura->abono);
            if($fecha_factura<=30){
                $facturas[$factura->id_cliente][30][]=$factura;
                $total_cliente_dias[$factura->id_cliente][30]=($total_cliente_dias[$factura->id_cliente][30]??0)+($factura->total-$factura->abono);
                $total_total30=$total_total30+($factura->total-$factura->abono);
            }elseif($fecha_factura>30 && $fecha_factura<=60){
                $facturas[$factura->id_cliente][60][]=$factura;
                $total_cliente_dias[$factura->id_cliente][60]=($total_cliente_dias[$factura->id_cliente][60]??0)+($factura->total-$factura->abono);
                $total_total60=$total_total60+($factura->total-$factura->abono);
            }elseif($fecha_factura>60 && $fecha_factura<=90){
                $facturas[$factura->id_cliente][90][]=$factura;
                $total_cliente_dias[$factura->id_cliente][90]=($total_cliente_dias[$factura->id_cliente][90]??0)+($factura->total-$factura->abono);
                $total_total90=$total_total90+($factura->total-$factura->abono);
            }else{
                $facturas[$factura->id_cliente][100][]=$factura;
                $total_cliente_dias[$factura->id_cliente][100]=($total_cliente_dias[$factura->id_cliente][100]??0)+($factura->total-$factura->abono);
                $total_total100=$total_total100+($factura->total-$factura->abono);
                
            }
            $total_total=$total_total+($factura->total-$factura->abono);*/
        }

        return view('contabilidad.cuenta_corriente', compact('facturas', 'clientes_saldo', 'clientes', 'fecha', 'total_cliente', 'total_cliente_dias', 'total_total', 'total_total30', 'total_total100', 'total_total90', 'total_total60', 'total_total30'));
    }

    public function verCuentaCorrienteInfo($id_cliente)
    {
        //Facturas Pendientes
        $fecha = new DateTime(date("Y-m-d"));
        $facturas_pendientes = Facturas::where('id_cliente', $id_cliente)->where('estatus', 1)->with('cliente')->with('nota')->get();
        $total_total = 0;
        $total_total30 = 0;
        $total_total60 = 0;
        $total_total90 = 0;
        $total_total100 = 0;
        $clientes = '';
        $cliente_info = '';
        //dd($facturas_pendientes); 
        //script original
        //foreach($facturas_pendientes as $factura){
        //    //dd($factura);
        //    $clientes=$factura->cliente;
        //    $fecha_factura=$fecha->diff($factura->created_at)->days;
        //    
        //    $notas_credito=$factura->nota->cantidad??0;
        //    if($factura->nota->id_tipo??0==2){
        //        $total_cliente=($total_cliente??0)+($factura->total-$factura->abono)-$notas_credito;
        //        
        //        if($fecha_factura<=30){
        //            $facturas[30][$factura->no_sat]=$factura;
        //            $total_cliente_dias[30][$factura->no_sat]=($total_cliente_dias[30][$factura->no_sat]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total30=$total_total30+($factura->total-$factura->abono)-$notas_credito;
        //        }elseif($fecha_factura>30 && $fecha_factura<=60){
        //            $facturas[60][$factura->no_sat]=$factura;
        //            $total_cliente_dias[60][$factura->no_sat]=($total_cliente_dias[60][$factura->no_sat]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total60=$total_total60+($factura->total-$factura->abono)-$notas_credito;
        //        }elseif($fecha_factura>60 && $fecha_factura<=90){
        //            $facturas[90][$factura->no_sat]=$factura;
        //            $total_cliente_dias[90][$factura->no_sat]=($total_cliente_dias[90][$factura->no_sat]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total90=$total_total90+($factura->total-$factura->abono)-$notas_credito;
        //        }else{
        //            $facturas[100][$factura->no_sat]=$factura;
        //            $total_cliente_dias[100][$factura->no_sat]=($total_cliente_dias[100][$factura->no_sat]??0)+($factura->total-$factura->abono)-$notas_credito;
        //            $total_total100=$total_total100+($factura->total-$factura->abono)-$notas_credito;
        //        }
        //        $total_total=$total_total+($factura->total-$factura->abono)-$notas_credito;
        //    }else{
        //        $total_cliente=($total_cliente??0)+($factura->total-$factura->abono)+$notas_credito;
        //        if($fecha_factura<=30){
        //            $facturas[30][$factura->no_sat]=$factura;
        //            $total_cliente_dias[30][$factura->no_sat]=($total_cliente_dias[30][$factura->no_sat]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total30=$total_total30+($factura->total-$factura->abono)+$notas_credito;
        //        }elseif($fecha_factura>30 && $fecha_factura<=60){
        //            $facturas[60][$factura->no_sat]=$factura;
        //            $total_cliente_dias[60][$factura->no_sat]=($total_cliente_dias[60][$factura->no_sat]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total60=$total_total60+($factura->total-$factura->abono)+$notas_credito;
        //        }elseif($fecha_factura>60 && $fecha_factura<=90){
        //            $facturas[90][$factura->no_sat]=$factura;
        //            $total_cliente_dias[90][$factura->no_sat]=($total_cliente_dias[90][$factura->no_sat]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total90=$total_total90+($factura->total-$factura->abono)+$notas_credito;
        //        }else{
        //            $facturas[100][$factura->no_sat]=$factura;
        //            $total_cliente_dias[100][$factura->no_sat]=($total_cliente_dias[100][$factura->no_sat]??0)+($factura->total-$factura->abono)+$notas_credito;
        //            $total_total100=$total_total100+($factura->total-$factura->abono)+$notas_credito;
        //        }
        //        $total_total=$total_total+($factura->total-$factura->abono)+$notas_credito;
        //    }
        //    
        //}

        //dd($facturas_pendientes); 
        foreach ($facturas_pendientes as $factura) {
            //dd($factura);
            $clientes = $factura->cliente;
            $fecha_factura = $fecha->diff($factura->created_at)->days;

            $notas_credito = $factura->nota->cantidad ?? 0;
            if ($factura->nota->id_tipo ?? 0 == 2) {
                $total_cliente = ($total_cliente ?? 0) + ($factura->total - $factura->abono);

                if ($fecha_factura <= 30) {
                    $facturas[30][$factura->no_sat] = $factura;
                    $total_cliente_dias[30][$factura->no_sat] = ($total_cliente_dias[30][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total30 = $total_total30 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 30 && $fecha_factura <= 60) {
                    $facturas[60][$factura->no_sat] = $factura;
                    $total_cliente_dias[60][$factura->no_sat] = ($total_cliente_dias[60][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total60 = $total_total60 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 60 && $fecha_factura <= 90) {
                    $facturas[90][$factura->no_sat] = $factura;
                    $total_cliente_dias[90][$factura->no_sat] = ($total_cliente_dias[90][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total90 = $total_total90 + ($factura->total - $factura->abono);
                } else {
                    $facturas[100][$factura->no_sat] = $factura;
                    $total_cliente_dias[100][$factura->no_sat] = ($total_cliente_dias[100][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total100 = $total_total100 + ($factura->total - $factura->abono);
                }
                $total_total = $total_total + ($factura->total - $factura->abono);
            } else {
                $total_cliente = ($total_cliente ?? 0) + ($factura->total - $factura->abono);
                if ($fecha_factura <= 30) {
                    $facturas[30][$factura->no_sat] = $factura;
                    $total_cliente_dias[30][$factura->no_sat] = ($total_cliente_dias[30][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total30 = $total_total30 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 30 && $fecha_factura <= 60) {
                    $facturas[60][$factura->no_sat] = $factura;
                    $total_cliente_dias[60][$factura->no_sat] = ($total_cliente_dias[60][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total60 = $total_total60 + ($factura->total - $factura->abono);
                } elseif ($fecha_factura > 60 && $fecha_factura <= 90) {
                    $facturas[90][$factura->no_sat] = $factura;
                    $total_cliente_dias[90][$factura->no_sat] = ($total_cliente_dias[90][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total90 = $total_total90 + ($factura->total - $factura->abono);
                } else {
                    $facturas[100][$factura->no_sat] = $factura;
                    $total_cliente_dias[100][$factura->no_sat] = ($total_cliente_dias[100][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                    $total_total100 = $total_total100 + ($factura->total - $factura->abono);
                }
                $total_total = $total_total + ($factura->total - $factura->abono);
            }
        }
        if (!$clientes) {
            $cliente_info = Cliente::where('id', $id_cliente)->with('info_recibo')->first();
            return view('contabilidad.cuenta_corriente_info', compact('clientes', 'cliente_info'));
            dd();
        }
        //dd($facturas);
        return view('contabilidad.cuenta_corriente_info', compact('facturas', 'clientes', 'cliente_info', 'total_cliente', 'total_cliente_dias', 'total_total', 'total_total30', 'total_total100', 'total_total90', 'total_total60', 'total_total30'));
    }

    public function imprimir_estado_cuenta($id_cliente)
    {
        //Facturas Pendientes
        $fecha = new DateTime(date("Y-m-d"));
        $facturas_pendientes = Facturas::where('id_cliente', $id_cliente)->where('estatus', 1)->orderBy('id', 'desc')->with('cliente')->with('nota')->get();
        $total_total = 0;
        $total_total30 = 0;
        $total_total60 = 0;
        $total_total90 = 0;
        $total_total100 = 0;
        $clientes = '';
        $cliente_info = '';

        foreach ($facturas_pendientes as $factura) {
            $clientes = $factura->cliente;
            $fecha_factura = $fecha->diff($factura->created_at)->days;
            $total_cliente = ($total_cliente ?? 0) + ($factura->total - $factura->abono);

            if ($fecha_factura <= 30) {
                $facturas[30][$factura->no_sat] = $factura;
                $total_cliente_dias[30][$factura->no_sat] = ($total_cliente_dias[30][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                $total_total30 = $total_total30 + ($factura->total - $factura->abono);
            } elseif ($fecha_factura > 30 && $fecha_factura <= 60) {
                $facturas[60][$factura->no_sat] = $factura;
                $total_cliente_dias[60][$factura->no_sat] = ($total_cliente_dias[60][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                $total_total60 = $total_total60 + ($factura->total - $factura->abono);
            } elseif ($fecha_factura > 60 && $fecha_factura <= 90) {
                $facturas[90][$factura->no_sat] = $factura;
                $total_cliente_dias[90][$factura->no_sat] = ($total_cliente_dias[90][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                $total_total90 = $total_total90 + ($factura->total - $factura->abono);
            } else {
                $facturas[100][$factura->no_sat] = $factura;
                $total_cliente_dias[100][$factura->no_sat] = ($total_cliente_dias[100][$factura->no_sat] ?? 0) + ($factura->total - $factura->abono);
                $total_total100 = $total_total100 + ($factura->total - $factura->abono);
            }
            $total_total = $total_total + ($factura->total - $factura->abono);
        }
        if (!$clientes) {
            $cliente_info = Cliente::where('id', $id_cliente)->first();
            return view('contabilidad.cuenta_corriente_info', compact('clientes', 'cliente_info'));
            dd();
        }



        $pdf = PDF::loadView('contabilidad.imprimir_estado_cuenta', compact('facturas', 'clientes', 'cliente_info', 'total_cliente', 'total_cliente_dias', 'total_total', 'total_total30', 'total_total100', 'total_total90', 'total_total60', 'total_total30'));
        return $pdf->download('cuenta_corriente.pdf');
    }

    public function verCuentaCorriente($id_cliente)
    {
        //Cliente Pago
        $facturas_canceladas = Facturas::where('estatus', 2)->where('id_cliente', $id_cliente)->groupBy('id_cliente')->with('cliente')->selectRaw('*, sum(total) as total_t')->get();
        //Abono
        $facturas_abono = Facturas::where('estatus', 1)->where('id_cliente', $id_cliente)->where('abono', '>', 0)->groupBy('id_cliente')->with('cliente')->selectRaw('*, sum(abono) as total_t')->get();
        //Facturas Pendientes
        $facturas_pendientes = Facturas::where('estatus', 1)->where('id_cliente', $id_cliente)->where('abono', 0)->groupBy('id_cliente')->with('cliente')->selectRaw('*, sum(total) as total_t')->get();
        //Unir facturas por cliente

        foreach ($facturas_canceladas as $factura) {
            $clientes[$factura->id_cliente] = $factura->cliente;
            $facturas[$factura->id_cliente]['canceladas'] = $factura;
        }
        foreach ($facturas_abono as $factura) {
            $clientes[$factura->id_cliente] = $factura->cliente;
            $facturas[$factura->id_cliente]['abonos'] = $factura;
        }
        foreach ($facturas_pendientes as $factura) {
            $clientes[$factura->id_cliente] = $factura->cliente;
            $facturas[$factura->id_cliente]['pendientes'] = $factura;
        }
        $fecha = new DateTime(date("Y-m-d"));

        return view('contabilidad.cuenta_corriente_cliente', compact('facturas', 'clientes', 'fecha', 'id_cliente'));
    }


    public function verFactura($idFactura)
    {
        $facturaSeleccionada = Facturas::where('id', $idFactura)->with('cliente')->with('producto')->get();

        return view('contabilidad.ver_factura', compact('facturaSeleccionada'));
    }

    public function editarFactura(Request $request)
    {
        $facturaEditar = Facturas::where('id', $request->idFactura)->first();
        $mensaje = 'Error al guardar el archivo';
        try {
            if ($facturaEditar->archivo_factura) {
                $path = url('/facturas') . '/' . $facturaEditar->archivo_factura;
                if ($path) {
                    $imageName = $facturaEditar->id . '-' . $facturaEditar->no_sat . '.' . $request->archivo_factura->extension();
                    $factura_image = $request->archivo_factura->move(public_path('facturas'), $imageName);
                    $facturaEditar->archivo_factura = $imageName;
                    $facturaEditar->no_sat = $request->fel;
                    $facturaEditar->save();
                } else {
                    $mensaje = 'error al eliminar archivo';
                }
            } else {
                if (unlink(public_path('facturas') . '/' . $facturaEditar->no_sat . '.pdf')) {
                    $imageName = $facturaEditar->id . '-' . $facturaEditar->no_sat . '.' . $request->archivo_factura->extension();
                    $factura_image = $request->archivo_factura->move(public_path('facturas'), $imageName);
                    $facturaEditar->archivo_factura = $imageName;
                    $facturaEditar->no_sat = $request->fel;
                    $facturaEditar->save();
                } else {
                    $mensaje = 'error al eliminar archivo';
                }
            }
            return redirect()->route('contabilidad.dashboard_facturas');
        } catch (\Throwable $th) {
            return $mensaje;
        }
    }


    //////////////////////////////////////////////////////////////////////////////////////////////////
    /// Recursos humanos
    //////////////////////////////////////////////////////////////////////////////////////////////////

    public function dashboardHumanos($_mesEspecifico = 0, $_anioEspecifico = 0)
    {
        try {
            $usuarios = DB::table('users')->where('comision', '=', 0)->get();
            $mesEspecifico = $_mesEspecifico == 0 ? Carbon::now()->month : $_mesEspecifico;
            $anioEspecifico = $_anioEspecifico == 0 ? Carbon::now()->year : $_anioEspecifico;
            $hoy = Carbon::now();
            $fechaInicio = Carbon::createFromDate($anioEspecifico, $mesEspecifico, 1)->startOfDay();

            if ($anioEspecifico == $hoy->year && $mesEspecifico == $hoy->month) {
                $fechaFin = $hoy;
            } else {
                // Si el mes y el año corresponden a otro mes
                $fechaFin = $fechaInicio->copy()->endOfMonth()->endOfDay();
            }

            $periodo = $fechaInicio->format('d/m/Y') . ' - ' . $fechaFin->format('d/m/Y');


            foreach ($usuarios as $usuario) {
                $recibos = $this->getRecibosPorUsuario($usuario->id, $mesEspecifico, $anioEspecifico);
                $usuario->comisionTotal = $recibos->map(function ($recibo) {
                    return $this->getComisionPorFactura($recibo);
                })->sum();
            }

            $filtro = collect(['mes' => $mesEspecifico, 'anio' => $anioEspecifico]);
            return view('rrhh.dashboard', compact('usuarios', 'periodo', 'filtro'));
        } catch (\Throwable $th) {
            // Manejar el error apropiadamente, por ejemplo, registrándolo o mostrando un mensaje
            return view('rrhh.error')->with('error', $th->getMessage());
        }
    }

    public function dashboardHumanosFecha(Request $request)
    {
        return $this->dashboardHumanos($request->mes, $request->anio);
    }
    public function getRecibosPorUsuario($idUsuario, $mesEspecifico, $anioEspecifico)
    {
        $recibos = DB::table('recibo_caja_factura')
            ->join('clientes', 'recibo_caja_factura.id_cliente', '=', 'clientes.id')
            ->leftJoin('facturas', 'recibo_caja_factura.id_factura', '=', 'facturas.id')
            ->join('recibo_caja', 'recibo_caja_factura.id_recibo_caja', '=', 'recibo_caja.id')
            ->join('productos', 'facturas.id_producto', '=', 'productos.id')
            ->join('productos_categorias', 'productos.id_categoria', '=', 'productos_categorias.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'clientes.nombre as cliente',
                'clientes.id as id',
                'clientes.tipo_regimen as regimen',
                'clientes.nit as nit',

                'facturas.no_sat as no_sat',
                'facturas.total as facturado',

                'recibo_caja_factura.created_at as fecha_cobro',
                'recibo_caja_factura.total_cancelar as valor_cancelado',
                //Tomar en cuenta cada campo disponible ya sea efectivo, cheque o retención ingresado
                'recibo_caja_factura.efectivo as efectivo',
                'recibo_caja_factura.cheque_q as cheque',
                'recibo_caja_factura.retencion as retencion',

                'recibo_caja.recibo_caja_numero as no_recibo',
                'recibo_caja.id_total as total_recibo',

                'productos.nombre as producto',
                'productos_categorias.id as id_categoria',
                'productos_categorias.nombre as categoria',

                'users.name as vendedor'
            )
            ->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
            ->whereYear('recibo_caja.fecha_ingreso', '=', $anioEspecifico)
            ->where('users.id', '=', $idUsuario)
            ->where('clientes.comision', '=', '0')
            ->orderBy('clientes.id')
            ->orderBy('recibo_caja_factura.id', 'DESC')
            ->get();

        return $recibos;
    }
    public function getComisionPorFactura($factura)
    {
        $sum_totales = $factura->efectivo + $factura->cheque + $factura->retencion;
        $valor_real_cancelado = floatval($sum_totales);

        if ($factura->regimen == 1 && preg_match('/\d/', $factura->nit)) {
            if ($factura->id_categoria == 16) {
                $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                $comision = ($valor_real_cancelado - $iva) * 0.05;
            } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                $iva = $valor_real_cancelado - $valor_real_cancelado / 1.12;
                $comision = ($valor_real_cancelado - $iva) * 0.02;
            }
        } else {
            if ($factura->id_categoria == 16) {
                $comision = $valor_real_cancelado * 0.05;
            } elseif ($factura->id_categoria != 26 && $factura->id_categoria != 16) {
                $comision = $valor_real_cancelado * 0.02;
            }
        }

        return $comision;
    }

    //por usuario
    public function comisionesPorUsuario(Request $request, $id)
    {

        $mesEspecifico = $request->mes ?? Carbon::now()->month;
        $anoEspecifico = $request->anio ?? Carbon::now()->year;
        $idUsuario = $id;

        $recibos = DB::table('recibo_caja_factura')
            ->join('clientes', 'recibo_caja_factura.id_cliente', '=', 'clientes.id')
            ->leftJoin('facturas', 'recibo_caja_factura.id_factura', '=', 'facturas.id')
            ->join('recibo_caja', 'recibo_caja_factura.id_recibo_caja', '=', 'recibo_caja.id')
            ->join('productos', 'facturas.id_producto', '=', 'productos.id')
            ->join('productos_categorias', 'productos.id_categoria', '=', 'productos_categorias.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'clientes.nombre as cliente',
                'clientes.id as id',
                'clientes.tipo_regimen as regimen',
                'clientes.nit as nit',

                'facturas.no_sat as no_sat',
                'facturas.total as facturado',

                'recibo_caja_factura.created_at as fecha_cobro',
                'recibo_caja_factura.total_cancelar as valor_cancelado',
                //Tomar en cuenta cada campo disponible ya sea efectivo, cheque o retención ingresado
                'recibo_caja_factura.efectivo as efectivo',
                'recibo_caja_factura.cheque_q as cheque',
                'recibo_caja_factura.retencion as retencion',

                'recibo_caja.recibo_caja_numero as no_recibo',
                'recibo_caja.id_total as total_recibo',

                'productos.nombre as producto',
                'productos_categorias.id as id_categoria',
                'productos_categorias.nombre as categoria',

                'users.name as vendedor'
            )
            ->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
            ->whereYear('recibo_caja.fecha_ingreso', '=', $anoEspecifico)
            ->where('users.id', '=', $idUsuario)
            ->where('clientes.comision', '=', '0')
            ->orderBy('clientes.id')
            ->orderBy('recibo_caja_factura.id', 'DESC')
            ->get();


        $recibosAnticipo = DB::table('recibo_caja_factura')
            ->join('clientes', 'recibo_caja_factura.id_cliente', '=', 'clientes.id')
            ->join('recibo_caja', 'recibo_caja_factura.id_recibo_caja', '=', 'recibo_caja.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'recibo_caja_factura.*',
                'recibo_caja.recibo_caja_numero as no_recibo',
                'recibo_caja.observacion as razon',
                'recibo_caja.fecha_ingreso as fecha_cobro',
                'recibo_caja_factura.total_cancelar as monto',
                'clientes.nombre as cliente',
                'users.name as vendedor'
            )
            ->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
            ->whereYear('recibo_caja.fecha_ingreso', '=', $anoEspecifico)
            ->where('recibo_caja_factura.id_factura', '=', 0)
            ->where('users.id', '=', $idUsuario)
            ->get();

        //dd($facturas);
        return view('rrhh.comisiones_por_usuario', compact('recibos', 'recibosAnticipo', 'idUsuario'));
    }

    //por usuario pero por fechas
    public function comisionesPorUsuarioMes(Request $request)
    {


        $mesEspecifico = $request->mes == 0 ? Carbon::now()->month : $request->mes;
        $anoEspecifico = $request->anio == 0 ? Carbon::now()->year : $request->anio;
        //$anoEspecifico = Carbon::now()->year;
        $idUsuario = $request->userselect;

        $recibosAnticipo = DB::table('recibo_caja_factura')
            ->join('clientes', 'recibo_caja_factura.id_cliente', '=', 'clientes.id')
            ->join('recibo_caja', 'recibo_caja_factura.id_recibo_caja', '=', 'recibo_caja.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->leftJoin('facturas', 'recibo_caja_factura.id_factura', '=', 'facturas.id') // Agregamos la unión con la tabla factura
            ->select(
                'recibo_caja_factura.*',
                'recibo_caja.recibo_caja_numero as no_recibo',
                'recibo_caja.observacion as razon',
                'recibo_caja.fecha_ingreso as fecha_cobro',
                'recibo_caja_factura.total_cancelar as monto',
                'clientes.nombre as cliente',
                'users.name as vendedor'
            )
            ->where(function ($query) use ($mesEspecifico, $anoEspecifico, $idUsuario) {
                $query->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
                    ->whereYear('recibo_caja.fecha_ingreso', '=', $anoEspecifico)
                    ->where(function ($query) use ($idUsuario) {
                        $query->where('recibo_caja_factura.id_factura', '=', 0)
                            ->where('users.id', '=', $idUsuario);
                    })
                    ->orWhere(function ($query) use ($mesEspecifico, $anoEspecifico, $idUsuario) {
                        $query->where('recibo_caja_factura.id_factura', '>', 0)
                            ->where('facturas.id_producto', '=', 0)
                            ->where('users.id', '=', $idUsuario)
                            ->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
                            ->whereYear('recibo_caja.fecha_ingreso', '=', $anoEspecifico);
                    });
            })
            ->get();

        $recibos = DB::table('recibo_caja_factura')
            ->join('clientes', 'recibo_caja_factura.id_cliente', '=', 'clientes.id')
            ->leftJoin('facturas', 'recibo_caja_factura.id_factura', '=', 'facturas.id')
            ->join('recibo_caja', 'recibo_caja_factura.id_recibo_caja', '=', 'recibo_caja.id')
            ->join('productos', 'facturas.id_producto', '=', 'productos.id')
            ->join('productos_categorias', 'productos.id_categoria', '=', 'productos_categorias.id')
            ->join('users', 'clientes.ejecutivo', '=', 'users.id')
            ->select(
                'clientes.nombre as cliente',
                'clientes.id as id',
                'clientes.tipo_regimen as regimen',
                'clientes.nit as nit',

                'facturas.no_sat as no_sat',
                'facturas.total as facturado',

                'recibo_caja_factura.created_at as fecha_cobro',
                'recibo_caja_factura.total_cancelar as valor_cancelado',
                //Tomar en cuenta cada campo disponible ya sea efectivo, cheque o retención ingresado
                'recibo_caja_factura.efectivo as efectivo',
                'recibo_caja_factura.cheque_q as cheque',
                'recibo_caja_factura.retencion as retencion',

                'recibo_caja.recibo_caja_numero as no_recibo',
                'recibo_caja.id_total as total_recibo',

                'productos.nombre as producto',
                'productos_categorias.id as id_categoria',
                'productos_categorias.nombre as categoria',

                'users.name as vendedor'
            )
            ->whereMonth('recibo_caja.fecha_ingreso', '=', $mesEspecifico)
            ->whereYear('recibo_caja.fecha_ingreso', '=', $anoEspecifico)
            ->where('users.id', '=', $idUsuario)
            ->where('clientes.comision', '=', '0')
            ->orderBy('clientes.id')
            ->orderBy('recibo_caja_factura.id', 'DESC')
            ->get();





        //dd($facturas);
        return view('rrhh.comisiones_por_usuario', compact('recibos', 'recibosAnticipo', 'idUsuario'));
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////
    /// fin de modulo recuros humanos
    //////////////////////////////////////////////////////////////////////////////////////////////////



}
