<?php

namespace App;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CompraProducto extends Model
{
    use SoftDeletes;
    protected $fillable = [
        'cantidad',
        'precio',
        'total_impuestos',
        'total_flete_seguro',
        'otros_gastos',
        'estado',
        'compra_id',
        'producto_id',
        'unidad_id'
    ];

    public function compra()
    {
        return $this->belongsTo(Compra::class);
    }

    public function producto()
    {
        return $this->belongsTo(Producto::class);
    }
}
